/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.network.play.server.S03PacketTimeUpdate;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.PacketReadEvent;
import org.ginafro.notenoughfakepixel.utils.RandomUtils;

@RegisterEvents
public class PartyCommands {
    private static final Pattern partyRegex = Pattern.compile("^Party > (?:\\[[^]]*])?\\s*(\\w{1,16}):\\s*(.+)$");
    private static final String[] responses = new String[]{"It is certain", "It is decidedly so", "Without a doubt", "Yes definitely", "You may rely on it", "As I see it, yes", "Most likely", "Outlook good", "Yes", "Signs point to yes", "Reply hazy try again", "Ask again later", "Better not tell you now", "Cannot predict now", "Concentrate and ask again", "Don't count on it", "My reply is no", "My sources say no", "Outlook not so good", "Very doubtful"};
    private final Minecraft mc = Minecraft.func_71410_x();
    private final Random random = RandomUtils.getInstance();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private long prevTime = 0L;
    public double averageTps = 20.0;

    @SubscribeEvent
    public void onPacket(PacketReadEvent event) {
        if (event.packet instanceof S03PacketTimeUpdate) {
            long currentTime = System.currentTimeMillis();
            if (this.prevTime != 0L) {
                double tps = 20000.0 / (double)(currentTime - this.prevTime + 1L);
                this.averageTps = Math.max(0.0, Math.min(20.0, tps));
            }
            this.prevTime = currentTime;
        }
    }

    @SubscribeEvent
    public void onClientChat(ClientChatReceivedEvent event) {
        String message = StringUtils.func_76338_a((String)event.message.func_150254_d());
        Matcher matcher = partyRegex.matcher(message);
        if (!matcher.matches()) {
            return;
        }
        String content = matcher.group(2);
        if (content == null) {
            return;
        }
        String response = null;
        switch (content.toLowerCase()) {
            case "!dice": {
                response = String.valueOf(this.random.nextInt(6) + 1);
                break;
            }
            case "!cf": {
                response = this.random.nextBoolean() ? "heads" : "tails";
                break;
            }
            case "!tps": {
                response = "Current TPS: " + (int)this.averageTps;
            }
        }
        if (response != null && this.mc.field_71439_g != null) {
            String finalResponse = response;
            this.scheduler.schedule(() -> {
                if (this.mc.field_71439_g != null) {
                    this.mc.field_71439_g.func_71165_d("/pc " + finalResponse);
                }
            }, 1500L, TimeUnit.MILLISECONDS);
        }
    }
}

