/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ItemUtils;
import org.ginafro.notenoughfakepixel.utils.Logger;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.variables.Rarity;
import org.lwjgl.input.Mouse;

@RegisterEvents
public class SalvagePrevention {
    private final Minecraft mc = Minecraft.func_71410_x();
    private static final int[] salvageSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25};

    @SubscribeEvent
    public void onMouseClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (Mouse.getEventButton() < 0 || !ScoreboardUtils.currentGamemode.isSkyblock() || !(this.mc.field_71462_r instanceof GuiChest) || !Config.feature.qol.salvageLegendaryPrevention && !Config.feature.qol.salvageEpicPrevention) {
            return;
        }
        GuiChest chestGui = (GuiChest)this.mc.field_71462_r;
        ContainerChest container = (ContainerChest)chestGui.field_147002_h;
        if (!this.isValidClick(chestGui)) {
            return;
        }
        for (int slot : salvageSlots) {
            Rarity rarity;
            ItemStack item = container.func_75139_a(slot).func_75211_c();
            if (item == null || ((rarity = ItemUtils.getRarity(item)) != Rarity.LEGENDARY || !Config.feature.qol.salvageLegendaryPrevention) && (rarity != Rarity.EPIC || !Config.feature.qol.salvageEpicPrevention)) continue;
            this.cancelEvents(event, (rarity == Rarity.LEGENDARY ? " Legendary item, " : "n Epic item, ") + item.func_82833_r());
            return;
        }
    }

    private void cancelEvents(GuiScreenEvent.MouseInputEvent.Pre event, String itemName) {
        event.setCanceled(true);
        Logger.logOnlyOnce("\u00a7cNEF prevented you from salvaging a" + itemName);
    }

    private boolean isValidClick(GuiChest chestGui) {
        ContainerChest container = (ContainerChest)chestGui.field_147002_h;
        if (container == null) {
            return false;
        }
        String chestName = container.func_85151_d().func_145748_c_().func_150260_c();
        if (chestName == null || !chestName.contains("Salvage Item")) {
            return false;
        }
        Slot slotClicked = chestGui.getSlotUnderMouse();
        if (slotClicked == null || slotClicked.getSlotIndex() != 40) {
            return false;
        }
        ItemStack item = container.func_75139_a(slotClicked.getSlotIndex()).func_75211_c();
        return item != null && item.func_82833_r().contains("Salvage Item") && Block.func_149634_a((Item)item.func_77973_b()) == Blocks.field_150461_bJ;
    }
}

