/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.StringUtils;
import org.ginafro.notenoughfakepixel.variables.Gamemode;

@RegisterEvents
public class VisualCooldowns {
    public HashMap<ItemStack, Integer> cooldowns = new HashMap();
    public long lastUpdatedtime = 0L;
    public long currentTime = 0L;

    @SubscribeEvent
    public void onDraw(RenderGameOverlayEvent.Text e) {
        if (!Config.feature.qol.qolVisualCooldowns) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        int xPos = sr.func_78326_a() - 20;
        int yPos = 16;
        for (ItemStack stack : this.cooldowns.keySet()) {
            Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, xPos, yPos);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(String.valueOf(this.cooldowns.get(stack)), xPos - 16, yPos + 3, -1);
            if (stack == null) {
                return;
            }
            int x = xPos + 12 - Minecraft.func_71410_x().field_71466_p.func_78256_a(stack.func_82833_r());
            Minecraft.func_71410_x().field_71466_p.func_78276_b(net.minecraft.util.StringUtils.func_76338_a((String)stack.func_82833_r()), x, yPos + 17, -1);
            yPos += 20;
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        this.currentTime = System.currentTimeMillis();
        if (this.currentTime - this.lastUpdatedtime > 1000L) {
            this.lastUpdatedtime = System.currentTimeMillis();
            Iterator<Map.Entry<ItemStack, Integer>> iterator = this.cooldowns.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ItemStack, Integer> entry = iterator.next();
                int newCooldown = entry.getValue() - 1;
                if (newCooldown <= 0) {
                    iterator.remove();
                    continue;
                }
                entry.setValue(newCooldown);
            }
        }
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent e) {
        if (ScoreboardUtils.currentGamemode != Gamemode.SKYBLOCK) {
            return;
        }
        if (e.message.func_150260_c().startsWith("This ability is on cooldown for")) {
            int cooldownTime = 0;
            for (String s : e.message.func_150260_c().split(" ")) {
                if (!StringUtils.isNumeric(s)) continue;
                cooldownTime = Integer.parseInt(s);
                break;
            }
            ItemStack item = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
            for (ItemStack stack : this.cooldowns.keySet()) {
                if (!stack.func_82833_r().equals(item.func_82833_r())) continue;
                this.cooldowns.replace(item, cooldownTime);
                return;
            }
            this.cooldowns.put(item, cooldownTime);
        }
    }
}

