/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol.customaliases;

import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.ginafro.notenoughfakepixel.features.skyblock.qol.customaliases.AddAliasGui;
import org.ginafro.notenoughfakepixel.features.skyblock.qol.customaliases.CustomAliases;
import org.ginafro.notenoughfakepixel.features.skyblock.qol.customaliases.EditButton;
import org.ginafro.notenoughfakepixel.utils.Utils;
import org.lwjgl.input.Mouse;

public class AliasManagementGui
extends GuiScreen {
    private int scrollOffset = 0;
    private static final int MAX_DISPLAYED = 12;
    private static final int ENTRY_HEIGHT = 30;
    private int sliderY = 40;
    private boolean dragging = false;

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 50, 10, 100, 20, "Add Alias"));
        this.updateButtons();
    }

    private void updateButtons() {
        this.field_146292_n.removeIf(button -> button.field_146127_k != 0);
        int y = 40;
        List<CustomAliases.Alias> displayedAliases = CustomAliases.aliases.subList(Math.min(this.scrollOffset, CustomAliases.aliases.size()), Math.min(this.scrollOffset + 12, CustomAliases.aliases.size()));
        for (int i = 0; i < displayedAliases.size(); ++i) {
            CustomAliases.Alias alias = displayedAliases.get(i);
            int buttonX = this.field_146294_l - 130;
            int buttonY = y + 5;
            this.field_146292_n.add(new GuiButton(2 * i + 1, buttonX, buttonY, 50, 20, "Toggle"));
            this.field_146292_n.add(new GuiButton(2 * i + 2, buttonX + 60, buttonY, 50, 20, "Remove"));
            this.field_146292_n.add(new EditButton(2 * i + 3, buttonX - 60, buttonY, 50, 20, "Edit"));
            y += 30;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        AliasManagementGui.func_73734_a((int)10, (int)10, (int)(this.field_146294_l - 10), (int)(this.field_146295_m - 10), (int)Integer.MIN_VALUE);
        int y = 40;
        int textX = 15;
        int buttonX = this.field_146294_l - 125;
        List<CustomAliases.Alias> displayedAliases = CustomAliases.aliases.subList(Math.min(this.scrollOffset, CustomAliases.aliases.size()), Math.min(this.scrollOffset + 12, CustomAliases.aliases.size()));
        for (CustomAliases.Alias alias : displayedAliases) {
            String display = "Alias: " + alias.alias + " | Command: " + alias.command + " " + (alias.toggled ? "[Enabled]" : "[Disabled]") + " | Location: " + alias.location + " | Key: " + Utils.getKeyDesc(alias.key);
            AliasManagementGui.func_73734_a((int)(textX - 5), (int)y, (int)(buttonX + 110), (int)(y + 30 - 5), (int)-13421773);
            this.field_146289_q.func_78276_b(display, textX, y + 10, 0xFFFFFF);
            y += 30;
        }
        int scrollbarX = this.field_146294_l - 10;
        int scrollbarHeight = (int)(12.0f / (float)CustomAliases.aliases.size() * (float)(this.field_146295_m - 60));
        AliasManagementGui.func_73734_a((int)scrollbarX, (int)this.sliderY, (int)(scrollbarX + 5), (int)(this.sliderY + scrollbarHeight), (int)-5592406);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            this.scrollOffset = scroll > 0 ? Math.max(this.scrollOffset - 1, 0) : Math.min(this.scrollOffset + 1, Math.max(CustomAliases.aliases.size() - 12, 0));
            this.updateButtons();
            this.updateSlider();
        }
    }

    private void updateSlider() {
        int maxScroll = Math.max(CustomAliases.aliases.size() - 12, 0);
        if (maxScroll > 0) {
            this.sliderY = 40 + (int)((float)this.scrollOffset / (float)maxScroll * (float)(this.field_146295_m - 100));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int scrollbarX = this.field_146294_l - 10;
        int scrollbarHeight = (int)(12.0f / (float)CustomAliases.aliases.size() * (float)(this.field_146295_m - 60));
        if (mouseX >= scrollbarX && mouseX <= scrollbarX + 5 && mouseY >= this.sliderY && mouseY <= this.sliderY + scrollbarHeight) {
            this.dragging = true;
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.dragging = false;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        int maxScroll;
        if (this.dragging && (maxScroll = Math.max(CustomAliases.aliases.size() - 12, 0)) > 0) {
            int scrollRange = this.field_146295_m - 100;
            this.scrollOffset = (int)((float)(mouseY - 40) / (float)scrollRange * (float)maxScroll);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, maxScroll));
            this.updateButtons();
            this.updateSlider();
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new AddAliasGui(this));
            return;
        }
        int aliasIndex = (button.field_146127_k - 1) / 3 + this.scrollOffset;
        if (aliasIndex < 0 || aliasIndex >= CustomAliases.aliases.size()) {
            return;
        }
        CustomAliases.Alias alias = CustomAliases.aliases.get(aliasIndex);
        int buttonType = (button.field_146127_k - 1) % 3;
        if (buttonType == 0) {
            alias.toggle();
            if (alias.toggled) {
                CustomAliases.registerAliases();
            } else {
                CustomAliases.unregisterAlias(alias);
            }
            CustomAliases.save();
        } else if (buttonType == 1) {
            CustomAliases.aliases.remove(aliasIndex);
            CustomAliases.unregisterAlias(alias);
            CustomAliases.save();
            this.updateButtons();
        } else if (buttonType == 2 && button instanceof EditButton) {
            this.field_146297_k.func_147108_a((GuiScreen)new AddAliasGui(this, alias));
        }
    }
}

