/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol.customaliases;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.qol.Aliases;
import org.lwjgl.input.Keyboard;

@RegisterEvents
public class CustomAliases {
    public static List<Alias> aliases = new ArrayList<Alias>();
    public static HashMap<String, Pattern> patterns = new HashMap();
    private static final Set<Integer> pressed = new HashSet<Integer>();
    public static final String configFile = "/nefalias.json";
    private static final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onInput(InputEvent.KeyInputEvent e) {
        for (Alias alias : aliases) {
            if (alias.key <= 0) continue;
            int k = alias.key;
            boolean down = Keyboard.isKeyDown((int)k);
            if (down && !pressed.contains(k)) {
                if (CustomAliases.mc.field_71439_g != null) {
                    CustomAliases.mc.field_71439_g.func_71165_d(alias.command);
                }
                pressed.add(k);
                continue;
            }
            if (down) continue;
            pressed.remove(k);
        }
    }

    public CustomAliases() {
        CustomAliases.load();
        CustomAliases.registerAliases();
    }

    public static void unregisterAlias(Alias alias) {
        if (alias != null) {
            ClientCommandHandler.instance.func_71555_a().remove(alias.alias);
        }
    }

    private static File getConfigFile() {
        File dir = Config.configDirectory;
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, configFile);
    }

    @SubscribeEvent
    public void onJoin(PlayerEvent.PlayerLoggedInEvent e) {
        CustomAliases.registerAliases();
    }

    public static void registerAliases() {
        for (Alias a : aliases) {
            if (a == null || !a.toggled || a.alias == null || a.command == null || ClientCommandHandler.instance.func_71555_a().containsKey(a.alias)) continue;
            ClientCommandHandler.instance.func_71560_a((ICommand)new Aliases.AliasCommand(a.alias, a.command));
        }
    }

    public static void save() {
        File file = CustomAliases.getConfigFile();
        try (FileWriter writer = new FileWriter(file);){
            new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(aliases, (Appendable)writer);
            writer.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.out.println("Failed to save aliases to " + file.getAbsolutePath());
        }
    }

    public static void load() {
        File file = CustomAliases.getConfigFile();
        if (!file.exists()) {
            System.out.println("No aliases file found at " + file.getAbsolutePath() + ", starting empty");
            return;
        }
        try (FileReader reader = new FileReader(file);){
            List loaded = (List)new GsonBuilder().create().fromJson((Reader)reader, new TypeToken<List<Alias>>(){}.getType());
            aliases.clear();
            if (loaded != null) {
                aliases.addAll(loaded);
            }
            patterns.clear();
            for (Alias a : aliases) {
                if (a == null || a.command == null) continue;
                patterns.put(a.alias, Pattern.compile(a.command));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.out.println("Failed to load aliases from " + file.getAbsolutePath());
        }
    }

    public static class Alias {
        public String location;
        public String command;
        public String alias;
        public int key;
        public boolean toggled;

        public Alias(String location, String command, String a, boolean toggled) {
            this.location = location;
            this.command = command;
            this.alias = a;
            this.toggled = toggled;
            this.key = 0;
        }

        public Alias(String location, String command, String a, boolean toggled, int key) {
            this.location = location;
            this.command = command;
            this.alias = a;
            this.toggled = toggled;
            this.key = key;
        }

        public void toggle() {
            this.toggled = !this.toggled;
        }
    }
}

