/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol.shortcuts;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.ginafro.notenoughfakepixel.config.gui.core.config.KeybindHelper;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;

public abstract class KeyShortcut {
    private final Set<Integer> activeKeySet = new HashSet<Integer>();

    @SubscribeEvent
    public void onKeyPress(InputEvent.KeyInputEvent event) {
        if (!this.getConfigOption() || !ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        int keyBind = this.getKeyBind();
        if (KeybindHelper.isKeyDown(keyBind)) {
            if (this.activeKeySet.add(keyBind)) {
                Minecraft.func_71410_x().field_71439_g.func_71165_d(this.getCommand());
            }
        } else {
            this.activeKeySet.remove(keyBind);
        }
    }

    @SubscribeEvent
    public void onKeyPressOnGui(GuiScreenEvent event) {
        if (!this.getConfigOption() || !ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (!(event.gui instanceof GuiChest)) {
            return;
        }
        Container container = ((GuiChest)event.gui).field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        String title = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c();
        if (!title.startsWith(this.getMenuTitle())) {
            return;
        }
        int keyBind = this.getKeyBind();
        if (KeybindHelper.isKeyDown(keyBind) && this.activeKeySet.add(keyBind)) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        } else if (!KeybindHelper.isKeyDown(keyBind)) {
            this.activeKeySet.remove(keyBind);
        }
    }

    public abstract boolean getConfigOption();

    public abstract int getKeyBind();

    public abstract String getCommand();

    public abstract String getMenuTitle();
}

