/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol.shortcuts;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.config.gui.core.config.KeybindHelper;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;

@RegisterEvents
public class WardrobeShortcut {
    private final Set<Integer> activeKeySet = new HashSet<Integer>();
    private static final int[] WARDROBE_SLOTS = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44};
    private int currentWindowId = -1;
    private final boolean[] keyStates = new boolean[9];
    private long lastClickTime = 0L;

    @SubscribeEvent
    public void onKeyPress(InputEvent.KeyInputEvent event) {
        if (!Config.feature.qol.qolShortcutWardrobe) {
            return;
        }
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean keyPressed = KeybindHelper.isKeyDown(Config.feature.qol.qolWardrobeKey);
        if (keyPressed && !this.activeKeySet.contains(Config.feature.qol.qolWardrobeKey)) {
            player.func_71165_d("/wardrobe");
            this.activeKeySet.add(Config.feature.qol.qolWardrobeKey);
        }
        if (!KeybindHelper.isKeyDown(Config.feature.qol.qolWardrobeKey)) {
            this.activeKeySet.remove(Config.feature.qol.qolWardrobeKey);
        }
    }

    @SubscribeEvent
    public void onKeyPressOnGui(GuiScreenEvent.KeyboardInputEvent event) {
        if (!Config.feature.qol.qolShortcutWardrobe) {
            return;
        }
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (!(event.gui instanceof GuiChest)) {
            return;
        }
        GuiChest chest = (GuiChest)event.gui;
        Container container = chest.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        String title = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c();
        if (!title.startsWith("Wardrobe")) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean keyPressed = KeybindHelper.isKeyDown(Config.feature.qol.qolWardrobeKey);
        if (keyPressed && !this.activeKeySet.contains(Config.feature.qol.qolWardrobeKey)) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            this.activeKeySet.add(Config.feature.qol.qolWardrobeKey);
        }
        if (!KeybindHelper.isKeyDown(Config.feature.qol.qolWardrobeKey)) {
            this.activeKeySet.remove(Config.feature.qol.qolWardrobeKey);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (!(event.gui instanceof GuiChest)) {
            this.resetState();
            return;
        }
        GuiChest chestGui = (GuiChest)event.gui;
        ContainerChest container = (ContainerChest)chestGui.field_147002_h;
        String chestName = container.func_85151_d().func_145748_c_().func_150260_c();
        if (chestName.startsWith("Wardrobe")) {
            this.currentWindowId = container.field_75152_c;
            this.handleWardrobeInput(chestGui);
        } else {
            this.resetState();
        }
    }

    private void handleWardrobeInput(GuiChest chestGui) {
        if (!ScoreboardUtils.currentGamemode.isSkyblock() || !Config.feature.qol.qolShortcutSlotsWardrobe) {
            return;
        }
        long now = System.currentTimeMillis();
        for (int slot = 0; slot < 9; ++slot) {
            int keyCode = this.getKeyCode(slot + 1);
            boolean keyDown = KeybindHelper.isKeyDown(keyCode);
            if (keyDown && !this.keyStates[slot] && now - this.lastClickTime > 100L) {
                this.clickSlot(chestGui, slot);
                this.lastClickTime = now;
                this.keyStates[slot] = true;
                continue;
            }
            if (keyDown) continue;
            this.keyStates[slot] = false;
        }
    }

    private void clickSlot(GuiChest chestGui, int slotIndex) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71442_b == null) {
            return;
        }
        mc.field_71442_b.func_78753_a(this.currentWindowId, WARDROBE_SLOTS[slotIndex], 0, 0, (EntityPlayer)mc.field_71439_g);
    }

    private int getKeyCode(int slot) {
        switch (slot) {
            case 1: {
                return Config.feature.qol.qolWardrobeKey1;
            }
            case 2: {
                return Config.feature.qol.qolWardrobeKey2;
            }
            case 3: {
                return Config.feature.qol.qolWardrobeKey3;
            }
            case 4: {
                return Config.feature.qol.qolWardrobeKey4;
            }
            case 5: {
                return Config.feature.qol.qolWardrobeKey5;
            }
            case 6: {
                return Config.feature.qol.qolWardrobeKey6;
            }
            case 7: {
                return Config.feature.qol.qolWardrobeKey7;
            }
            case 8: {
                return Config.feature.qol.qolWardrobeKey8;
            }
            case 9: {
                return Config.feature.qol.qolWardrobeKey9;
            }
        }
        return 0;
    }

    private void resetState() {
        this.currentWindowId = -1;
        for (int i = 0; i < this.keyStates.length; ++i) {
            this.keyStates[i] = false;
        }
    }
}

