/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol.slothighlight;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.utils.InventoryUtils;
import org.ginafro.notenoughfakepixel.utils.ItemUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.variables.Gamemode;

public abstract class HightlightSlot {
    public abstract String getLoreLine();

    public abstract String getName();

    public abstract String getContainerName();

    public abstract boolean getConfigOption();

    public boolean onlyInSkyblock() {
        return true;
    }

    public Color getHighlightColor() {
        return new Color(55, 255, 55);
    }

    public boolean highlightOnlyFirst() {
        return false;
    }

    @SubscribeEvent
    public void onOpen(GuiScreenEvent.BackgroundDrawnEvent e) {
        if (!this.getConfigOption() || this.onlyInSkyblock() && ScoreboardUtils.currentGamemode != Gamemode.SKYBLOCK || !(e.gui instanceof GuiChest) || !this.checkForEssentials()) {
            return;
        }
        GuiChest chest = (GuiChest)e.gui;
        Container container = chest.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        String title = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c();
        if (!title.startsWith(this.getContainerName())) {
            return;
        }
        for (Slot slot : container.field_75151_b) {
            boolean matchesName;
            ItemStack item;
            if (slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || (item = slot.func_75211_c()) == null || item.func_77973_b() == null) continue;
            boolean matchesLore = this.getLoreLine() != null && !this.getLoreLine().isEmpty() && ItemUtils.getLoreLine(item, this.getLoreLine()) != null;
            boolean bl = matchesName = this.getName() != null && !this.getName().isEmpty() && item.func_82833_r().contains(this.getName());
            if (!matchesLore && !matchesName) continue;
            this.highlightSlot(slot, chest);
            if (!this.highlightOnlyFirst()) continue;
            return;
        }
    }

    private boolean checkForEssentials() {
        return this.getLoreLine() != null && !this.getLoreLine().isEmpty() || this.getName() != null && !this.getName().isEmpty() && this.getContainerName() != null && !this.getContainerName().isEmpty();
    }

    private void highlightSlot(Slot slot, GuiChest chest) {
        InventoryUtils.highlightSlot(slot, (GuiContainer)chest, this.getHighlightColor());
    }
}

