/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.slayers;

import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.Configuration;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.RenderEntityModelEvent;
import org.ginafro.notenoughfakepixel.utils.EntityHighlightUtils;
import org.ginafro.notenoughfakepixel.utils.MapUtils;
import org.ginafro.notenoughfakepixel.utils.OutlineUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;

@RegisterEvents
public class BlazeAttunements {
    public final Set<EntityLivingBase> blazeEntity = new HashSet<EntityLivingBase>();
    private long lastUpdateTime = 0L;
    public static final Pattern COLOR_PATTERN = Pattern.compile("ASHEN|SPIRIT|CRYSTAL|AURIC");
    private static final Map<String, Integer> ATTUNEMENT_COLORS = MapUtils.mapOf(MapUtils.Pair.of("ASHEN", Color.DARK_GRAY.getRGB()), MapUtils.Pair.of("SPIRIT", Color.WHITE.getRGB()), MapUtils.Pair.of("CRYSTAL", Color.CYAN.getRGB()), MapUtils.Pair.of("AURIC", Color.YELLOW.getRGB()));

    @SubscribeEvent
    public void onRenderEntity(RenderLivingEvent.Pre<EntityLivingBase> event) {
        if (!Config.feature.slayer.slayerBlazeAttunements) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime > 20L) {
            this.blazeEntity.clear();
            this.lastUpdateTime = currentTime;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        if (!ScoreboardUtils.currentGamemode.isSkyblock() || !TablistParser.currentLocation.isCrimson()) {
            return;
        }
        EntityLivingBase entity = event.entity;
        if (entity.func_82150_aj() || entity == mc.field_71439_g) {
            return;
        }
        List armorStands = mc.field_71441_e.func_72872_a(EntityArmorStand.class, entity.func_174813_aQ().func_72317_d(0.0, 2.0, 0.0).func_72314_b(1.0, 1.0, 1.0));
        for (Entity armorStand : armorStands) {
            String displayName;
            Matcher matcher;
            if (!(armorStand instanceof EntityArmorStand) || !(matcher = COLOR_PATTERN.matcher(displayName = armorStand.func_145748_c_().func_150260_c())).find()) continue;
            String attunement = matcher.group().toUpperCase();
            boolean isValidEntity = entity instanceof EntityBlaze || entity instanceof EntityPigZombie || entity instanceof EntitySkeleton && ((EntitySkeleton)entity).func_82202_m() == 1;
            if (!isValidEntity) continue;
            boolean allowed = false;
            if (entity instanceof EntitySkeleton && ((EntitySkeleton)entity).func_82202_m() == 1) {
                allowed = attunement.equals("SPIRIT") || attunement.equals("CRYSTAL");
            } else if (entity instanceof EntityPigZombie) {
                allowed = attunement.equals("ASHEN") || attunement.equals("AURIC");
            } else if (entity instanceof EntityBlaze) {
                allowed = true;
            }
            if (!allowed) continue;
            this.blazeEntity.add(entity);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderEntityModel(RenderEntityModelEvent event) {
        if (!Config.feature.slayer.slayerBlazeAttunements) {
            return;
        }
        if (!ScoreboardUtils.currentGamemode.isSkyblock() || !TablistParser.currentLocation.isCrimson()) {
            return;
        }
        EntityLivingBase entity = event.getEntity();
        if (entity == null || !this.blazeEntity.contains(entity)) {
            return;
        }
        List armorStands = Minecraft.func_71410_x().field_71441_e.func_72872_a(EntityArmorStand.class, entity.func_174813_aQ().func_72317_d(0.0, 2.0, 0.0).func_72314_b(1.0, 1.0, 1.0));
        for (Entity armorStand : armorStands) {
            String displayName;
            Matcher matcher;
            if (!(armorStand instanceof EntityArmorStand) || !(matcher = COLOR_PATTERN.matcher(displayName = armorStand.func_145748_c_().func_150260_c())).find()) continue;
            String attunement = matcher.group().toUpperCase();
            Color color = new Color(BlazeAttunements.getColorForAttunement(attunement));
            if (Configuration.isPojav()) {
                EntityHighlightUtils.renderEntityOutline(event, color);
            } else {
                OutlineUtils.outlineEntity(event, 6.0f, color, true);
            }
            return;
        }
    }

    public static int getColorForAttunement(String attunement) {
        return ATTUNEMENT_COLORS.getOrDefault(attunement, -1);
    }

    public Set<EntityLivingBase> getBlazeEntity() {
        return this.blazeEntity;
    }
}

