/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.slayers;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.utils.TitleUtils;

@RegisterEvents
public class FirePillarDisplay {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private EntityArmorStand trackedPillar;
    private long lastSoundTime;
    private static final String displayText = "";
    private static final long endTime = 0L;

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Pre<EntityLivingBase> event) {
        if (!Config.feature.slayer.slayerFirePillarDisplay || FirePillarDisplay.mc.field_71441_e == null) {
            return;
        }
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (!TablistParser.currentLocation.isCrimson()) {
            return;
        }
        if (FirePillarDisplay.mc.field_71441_e.func_82737_E() % 5L != 0L) {
            return;
        }
        FirePillarDisplay.mc.field_71441_e.func_72910_y().stream().filter(e -> e instanceof EntityArmorStand).map(e -> (EntityArmorStand)e).forEach(this::processArmorStand);
    }

    private void processArmorStand(EntityArmorStand armorStand) {
        if (armorStand.func_145748_c_() == null) {
            return;
        }
        String rawName = armorStand.func_145748_c_().func_150260_c();
        String cleanName = rawName.trim().replaceAll("\u00a7.", displayText);
        String[] parts = cleanName.split(" ");
        if (parts.length != 3) {
            return;
        }
        if (!parts[0].endsWith("s") || !parts[2].equals("hits")) {
            return;
        }
        if (this.trackedPillar == null || this.trackedPillar.field_70128_L) {
            this.trackedPillar = armorStand;
            this.lastSoundTime = System.currentTimeMillis();
        }
        if (this.trackedPillar.equals((Object)armorStand)) {
            this.updatePillarDisplay(cleanName);
        }
    }

    private void updatePillarDisplay(String cleanName) {
        int seconds = Integer.parseInt(cleanName.split(" ")[0].replace("s", displayText));
        TitleUtils.showTitle(this.trackedPillar.func_145748_c_().func_150254_d(), 500);
        if (System.currentTimeMillis() - this.lastSoundTime > (long)seconds * 150L) {
            SoundUtils.playSound(FirePillarDisplay.mc.field_71439_g.func_180425_c(), "note.pling", 1.0f, 1.0f);
            this.lastSoundTime = System.currentTimeMillis();
        }
    }
}

