/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.slayers;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.config.gui.core.config.Position;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.lwjgl.opengl.GL11;

@RegisterEvents
public class SlayerHealthDisplay {
    private final Minecraft mc = Minecraft.func_71410_x();
    private String displayText = "";
    private boolean isBoss = false;
    private final Position position;
    private int ticks = 0;
    public static final String[] SLAYER_BOSSES = new String[]{"Revenant Horror", "Atoned Horror", "Sven Packmaster", "Tarantula Broodfather", "Voidgloom Seraph", "Inferno Demonlord"};

    public SlayerHealthDisplay() {
        this.position = Config.feature.slayer.slayerBossHPPos;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.side != Side.CLIENT || this.mc.field_71441_e == null) {
            return;
        }
        ++this.ticks;
        if (this.ticks % 10 != 0) {
            return;
        }
        if (Config.feature.slayer.slayerBossHP) {
            List<String> sidebarLines = ScoreboardUtils.getScoreboardLines();
            this.isBoss = ScoreboardUtils.isSlayerActive;
            if (this.isBoss && this.mc.field_71439_g != null) {
                List entities = this.mc.field_71441_e.func_72910_y();
                Entity closestBoss = null;
                double closestDistance = Double.MAX_VALUE;
                String bossNameFound = "";
                block0: for (Entity entity : entities) {
                    if (!(entity instanceof EntityArmorStand) || !entity.func_145818_k_()) continue;
                    String entityName = entity.func_95999_t();
                    for (String bossName : SLAYER_BOSSES) {
                        if (!entityName.contains(bossName)) continue;
                        double distance = this.mc.field_71439_g.func_70032_d(entity);
                        if (!(distance < closestDistance)) continue block0;
                        closestDistance = distance;
                        closestBoss = entity;
                        bossNameFound = entityName;
                        continue block0;
                    }
                }
                this.displayText = closestBoss != null ? bossNameFound : "";
            } else {
                this.displayText = "";
            }
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL || this.displayText.isEmpty() || !this.isBoss) {
            return;
        }
        ScaledResolution resolution = event.resolution;
        FontRenderer fr = this.mc.field_71466_p;
        float scale = 2.0f;
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        int textWidth = fr.func_78256_a(this.displayText);
        int textHeight = fr.field_78288_b;
        int x = this.position.getAbsX(resolution, textWidth) / (int)scale;
        int y = this.position.getAbsY(resolution, textHeight) / (int)scale;
        fr.func_175063_a(this.displayText, (float)x, (float)y, 0xFF5555);
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.displayText = "";
        this.isBoss = false;
    }
}

