/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.slayers;

import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.Configuration;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.RenderEntityModelEvent;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.EntityHighlightUtils;
import org.ginafro.notenoughfakepixel.utils.OutlineUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Constants;
import org.ginafro.notenoughfakepixel.variables.MobDisplayTypes;

@RegisterEvents
public class SlayerMobsDisplay {
    public final Set<EntityLivingBase> slayerEntity = new HashSet<EntityLivingBase>();
    public final Set<EntityLivingBase> slayerMiniEntity = new HashSet<EntityLivingBase>();
    private long lastUpdateTime = 0L;

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71441_e == null) {
            return;
        }
        if (Config.feature.slayer.slayerBossesOutline) {
            return;
        }
        if (Config.feature.slayer.slayerBosses) {
            this.onRender(event, true);
        }
        if (Config.feature.slayer.slayerMinibosses) {
            this.onRender(event, false);
        }
    }

    private void onRender(RenderWorldLastEvent event, boolean isBoss) {
        switch (TablistParser.currentLocation) {
            case HUB: 
            case PRIVATE_HUB: {
                this.showHitboxHub(event.partialTicks);
                break;
            }
            case PARK: {
                this.showHitbox(MobDisplayTypes.WOLF, event.partialTicks, Constants.SVEN_SLAYER_MINIBOSSES, isBoss);
                break;
            }
            case SPIDERS_DEN: {
                this.showHitbox(MobDisplayTypes.SPIDER, event.partialTicks, Constants.TARANTULA_SLAYER_MINIBOSSES, isBoss);
                break;
            }
            case THE_END: {
                this.showHitbox(MobDisplayTypes.ENDERMAN, event.partialTicks, Constants.VOIDGLOOM_SLAYER_MINIBOSSES, isBoss);
                break;
            }
            case CRIMSON_ISLE: {
                this.showHitbox(MobDisplayTypes.NONE, event.partialTicks, Constants.BLAZE_SLAYER_MINIBOSSES, isBoss);
            }
        }
    }

    private void showHitboxHub(float partialTicks) {
        Color bossColor = ColorUtils.getColor(Config.feature.slayer.slayerBossColor);
        Color minibossColor = ColorUtils.getColor(Config.feature.slayer.slayerColor);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        world.field_72996_f.forEach(entity -> {
            if (entity == null || entity.func_70005_c_() == null) {
                return;
            }
            if (!(entity instanceof EntityArmorStand)) {
                return;
            }
            for (String name : Constants.SLAYER_BOSSES) {
                if (!entity.func_70005_c_().contains(name)) continue;
                MobDisplayTypes type = entity.func_70005_c_().contains("Sven Packmaster") ? MobDisplayTypes.WOLF : MobDisplayTypes.NONE;
                RenderUtils.renderEntityHitbox(entity, partialTicks, bossColor, type);
                return;
            }
            for (String name : Constants.SVEN_SLAYER_MINIBOSSES) {
                if (!entity.func_70005_c_().contains(name)) continue;
                RenderUtils.renderEntityHitbox(entity, partialTicks, minibossColor, MobDisplayTypes.WOLF);
                return;
            }
            for (String name : Constants.REVENANT_SLAYER_MINIBOSSES) {
                if (!entity.func_70005_c_().contains(name)) continue;
                RenderUtils.renderEntityHitbox(entity, partialTicks, minibossColor, MobDisplayTypes.NONE);
                return;
            }
        });
    }

    private void showHitbox(MobDisplayTypes type, float partialTicks, String[] namesList, boolean isBoss) {
        Color color = ColorUtils.getColor(Config.feature.slayer.slayerBossColor);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        world.field_72996_f.forEach(entity -> {
            String[] names;
            if (entity == null || entity.func_70005_c_() == null) {
                return;
            }
            if (!(entity instanceof EntityArmorStand)) {
                return;
            }
            for (String name : names = isBoss ? Constants.SLAYER_BOSSES : namesList) {
                if (!entity.func_70005_c_().contains(name)) continue;
                RenderUtils.renderEntityHitbox(entity, partialTicks, color, type);
            }
        });
    }

    @SubscribeEvent
    public void onRenderEntity(RenderLivingEvent.Pre<EntityLivingBase> event) {
        if (!Config.feature.slayer.slayerBossesOutline) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime > 20L) {
            this.slayerEntity.clear();
            this.lastUpdateTime = currentTime;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityLivingBase entity = event.entity;
        if (mc.field_71441_e == null || entity == null || entity.func_82150_aj() || entity instanceof EntityPlayer) {
            return;
        }
        List armorStands = mc.field_71441_e.func_72872_a(EntityArmorStand.class, entity.func_174813_aQ().func_72317_d(0.0, 2.0, 0.0).func_72314_b(1.0, 1.0, 1.0));
        for (Entity armorStand : armorStands) {
            if (!(armorStand instanceof EntityArmorStand) || armorStand.func_70005_c_() == null) continue;
            for (String name : Constants.SLAYER_BOSSES) {
                if (!armorStand.func_70005_c_().contains(name) || !Config.feature.slayer.slayerBosses) continue;
                this.slayerEntity.add(entity);
                return;
            }
            String[] stringArray = new String[][]{Constants.SVEN_SLAYER_MINIBOSSES, Constants.REVENANT_SLAYER_MINIBOSSES, Constants.TARANTULA_SLAYER_MINIBOSSES, Constants.VOIDGLOOM_SLAYER_MINIBOSSES, Constants.BLAZE_SLAYER_MINIBOSSES};
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String minibosses;
                for (String name : minibosses = stringArray[i]) {
                    if (!armorStand.func_70005_c_().contains(name) || !Config.feature.slayer.slayerMinibosses) continue;
                    this.slayerMiniEntity.add(entity);
                    return;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderEntityModel(RenderEntityModelEvent event) {
        Color minibossColor;
        if (!Config.feature.slayer.slayerBossesOutline) {
            return;
        }
        EntityLivingBase entity = event.getEntity();
        if (entity == null || !this.slayerEntity.contains(entity)) {
            return;
        }
        Color bossColor = ColorUtils.getColor(Config.feature.slayer.slayerBossColor);
        Color color = minibossColor = ColorUtils.getColor(Config.feature.slayer.slayerColor);
        List armorStands = Minecraft.func_71410_x().field_71441_e.func_72872_a(EntityArmorStand.class, entity.func_174813_aQ().func_72317_d(0.0, 2.0, 0.0).func_72314_b(1.0, 1.0, 1.0));
        block0: for (Entity armorStand : armorStands) {
            if (!(armorStand instanceof EntityArmorStand) || armorStand.func_70005_c_() == null) continue;
            for (String name : Constants.SLAYER_BOSSES) {
                if (!armorStand.func_70005_c_().contains(name) || !Config.feature.slayer.slayerBosses) continue;
                color = bossColor;
                continue block0;
            }
        }
        if (Configuration.isPojav()) {
            EntityHighlightUtils.renderEntityOutline(event, color);
        } else {
            OutlineUtils.outlineEntity(event, 6.0f, color, true);
        }
    }

    public Set<EntityLivingBase> getSlayerEntity() {
        return this.slayerEntity;
    }

    public Set<EntityLivingBase> getSlayerMiniEntity() {
        return this.slayerMiniEntity;
    }
}

