/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.slayers;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;

@RegisterEvents
public class SlayerTimer {
    private long startTime = -1L;
    private boolean isBossActive = false;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Config.feature.slayer.slayerBossTimer && ScoreboardUtils.currentGamemode.isSkyblock() && event.side == Side.CLIENT) {
            List<String> sidebarLines = ScoreboardUtils.getScoreboardLines();
            for (String line : sidebarLines) {
                if (!line.contains("Slay the boss!")) continue;
                if (this.isBossActive) break;
                this.startTime = System.currentTimeMillis();
                this.isBossActive = true;
                break;
            }
        }
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent event) {
        if (Config.feature.slayer.slayerBossTimer && ScoreboardUtils.currentGamemode.isSkyblock()) {
            String message = StringUtils.func_76338_a((String)event.message.func_150260_c());
            if (message.contains("SLAYER QUEST COMPLETE!") && this.isBossActive) {
                long endTime = System.currentTimeMillis();
                long duration = endTime - this.startTime;
                double seconds = (double)duration / 1000.0;
                String chatMessage = String.format("[NEF] Boss took %.3f seconds!", seconds);
                ChatComponentText formattedMessage = new ChatComponentText(chatMessage);
                formattedMessage.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)formattedMessage);
                this.startTime = -1L;
                this.isBossActive = false;
            }
            if (message.contains("SLAYER QUEST FAILED!")) {
                this.startTime = -1L;
                this.isBossActive = false;
            }
        }
    }
}

