/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.slayers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockBeacon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.NefPacketBlockChange;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.utils.TitleUtils;
import org.ginafro.notenoughfakepixel.utils.Waypoint;
import org.ginafro.notenoughfakepixel.variables.Slayer;

@RegisterEvents
public class VoidgloomSeraph {
    public static final Minecraft mc = Minecraft.func_71410_x();
    public static final Map<Waypoint, Long> waypoints = new ConcurrentHashMap<Waypoint, Long>();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && !ScoreboardUtils.isSlayerActive) {
            VoidgloomSeraph.clearWaypointsSafe();
        }
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        if (VoidgloomSeraph.checkEssentials() || !Config.feature.slayer.slayerShowBeaconPath || ScoreboardUtils.currentSlayer != Slayer.VOIDGLOOM) {
            return;
        }
        if (!ScoreboardUtils.isSlayerActive) {
            return;
        }
        long now = System.currentTimeMillis();
        VoidgloomSeraph.removeExpiredWaypoints(now, 20000L);
        for (Map.Entry<Waypoint, Long> entry : waypoints.entrySet()) {
            BlockPos waypoint = entry.getKey().getBlockPos();
            if (Config.feature.slayer.showTracerToBeacon) {
                RenderUtils.draw3DLine(new Vec3((double)waypoint.func_177958_n() + 0.5, (double)waypoint.func_177956_o() + 0.5, (double)waypoint.func_177952_p() + 0.5), VoidgloomSeraph.mc.field_71439_g.func_174824_e(event.partialTicks), ColorUtils.getColor(Config.feature.slayer.slayerBeaconColor), 8, true, event.partialTicks);
            }
            RenderUtils.renderBeaconBeam(waypoint, ColorUtils.getColor(Config.feature.slayer.slayerBeaconColor).getRGB(), 1.0f, event.partialTicks);
        }
    }

    private static void notifyPlayer() {
        if (Config.feature.slayer.notifyBeaconInScreen && VoidgloomSeraph.mc.field_71439_g != null && VoidgloomSeraph.mc.field_71441_e != null && VoidgloomSeraph.mc.field_71456_v != null && VoidgloomSeraph.mc.field_71456_v.func_146158_b() != null) {
            TitleUtils.showTitle(EnumChatFormatting.RED + "Beacon", 1000);
            SoundUtils.playSound(VoidgloomSeraph.mc.field_71439_g.func_180425_c(), "note.pling", 1.0f, 1.0f);
        }
    }

    public static void addWaypointSafe(Waypoint wp) {
        Minecraft mc = Minecraft.func_71410_x();
        Runnable r = () -> waypoints.put(wp, System.currentTimeMillis());
        if (mc.func_152345_ab()) {
            r.run();
        } else {
            mc.func_152344_a(r);
        }
    }

    public static void removeExpiredWaypoints(long now, long maxAgeMs) {
        Minecraft mc = Minecraft.func_71410_x();
        Runnable r = () -> waypoints.entrySet().removeIf(e -> now - (Long)e.getValue() > maxAgeMs);
        if (mc.func_152345_ab()) {
            r.run();
        } else {
            mc.func_152344_a(r);
        }
    }

    public static void removeWaypointSafe(BlockPos position) {
        Minecraft mc = Minecraft.func_71410_x();
        Runnable r = () -> waypoints.entrySet().removeIf(e -> VoidgloomSeraph.sameBlockPos(((Waypoint)e.getKey()).getBlockPos(), position));
        if (mc.func_152345_ab()) {
            r.run();
        } else {
            mc.func_152344_a(r);
        }
    }

    private static boolean sameBlockPos(BlockPos a, BlockPos b) {
        return a.func_177958_n() == b.func_177958_n() && a.func_177956_o() == b.func_177956_o() && a.func_177952_p() == b.func_177952_p();
    }

    public static void clearWaypointsSafe() {
        Minecraft mc = Minecraft.func_71410_x();
        Runnable r = waypoints::clear;
        if (mc.func_152345_ab()) {
            r.run();
        } else {
            mc.func_152344_a(r);
        }
    }

    public static void processBlockChange(NefPacketBlockChange packetIn) {
        if (!Config.feature.slayer.slayerShowBeaconPath) {
            return;
        }
        Block block = packetIn.getBlock();
        BlockPos position = packetIn.getPacket().func_179827_b();
        if (block instanceof BlockBeacon && block.func_149732_F().contains("Beacon") && ScoreboardUtils.isSlayerActive) {
            EntityPlayerSP player = VoidgloomSeraph.mc.field_71439_g;
            if (player == null || player.func_180425_c() == null) {
                return;
            }
            double distance = new Vec3((Vec3i)player.func_180425_c()).func_72438_d(new Vec3((Vec3i)position));
            if (distance > 32.0) {
                return;
            }
            VoidgloomSeraph.notifyPlayer();
            VoidgloomSeraph.addWaypointSafe(new Waypoint("BEACON", new int[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()}));
        } else if (block instanceof BlockAir) {
            VoidgloomSeraph.removeWaypointSafe(position);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        VoidgloomSeraph.clearWaypointsSafe();
    }

    private static boolean checkEssentials() {
        return VoidgloomSeraph.mc.field_71439_g == null || !ScoreboardUtils.currentGamemode.isSkyblock() || !TablistParser.currentLocation.isEnd();
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent event) {
        String message;
        if (Config.feature.slayer.slayerShowBeaconPath && ScoreboardUtils.currentGamemode.isSkyblock() && TablistParser.currentLocation.isEnd() && ((message = StringUtils.func_76338_a((String)event.message.func_150260_c())).contains("SLAYER QUEST COMPLETE!") || message.contains("SLAYER QUEST FAILED!"))) {
            ScoreboardUtils.isSlayerActive = false;
            VoidgloomSeraph.clearWaypointsSafe();
        }
    }
}

