/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.slotlocking;

import java.io.File;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.config.gui.core.config.KeybindHelper;
import org.ginafro.notenoughfakepixel.config.gui.core.util.StringUtils;
import org.ginafro.notenoughfakepixel.config.gui.core.util.render.RenderUtils;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterInstance;
import org.ginafro.notenoughfakepixel.events.ReplaceItemEvent;
import org.ginafro.notenoughfakepixel.events.SlotClickEvent;
import org.ginafro.notenoughfakepixel.mixin.accesors.AccessorGuiContainer;
import org.ginafro.notenoughfakepixel.serverdata.SkyblockData;
import org.ginafro.notenoughfakepixel.utils.ConfigHandler;
import org.ginafro.notenoughfakepixel.utils.ItemUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Resources;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class SlotLocking {
    @RegisterInstance
    public static final SlotLocking INSTANCE = new SlotLocking();
    private static final int HOTBAR_SIZE = 9;
    private static final int INV_SIZE = 40;
    private static final int INV_LAST = 39;
    private static final int HOTBAR_LAST = 8;
    private static final int ARMOR_START = 36;
    private static final int SLOT_THROW = 8;
    private static final long[] EMPTY_CHANGES = new long[9];
    private static final Pattern WINDOW_REGEX = Pattern.compile(".+ Backpack (?:\u2726 )?\\(Slot #(\\d+)\\)");
    private static final Pattern ECHEST_WINDOW_REGEX = Pattern.compile("Ender Chest \\(Page (\\d+)\\)");
    private static final LockedSlot DEFAULT_LOCKED_SLOT = new LockedSlot();
    private SlotLockingConfig config = new SlotLockingConfig();
    private boolean lockKeyHeld = false;
    private Slot pairingSlot = null;
    private final long[] slotChanges = new long[9];
    private Slot realSlot = null;
    boolean setTopHalfBarrier = false;

    public static SlotLocking getInstance() {
        return INSTANCE;
    }

    public void loadConfig(File file) {
        SlotLockingConfig loaded = ConfigHandler.loadConfig(SlotLockingConfig.class, file, ConfigHandler.GSON);
        this.config = loaded != null ? loaded : new SlotLockingConfig();
    }

    public void saveConfig() {
        ConfigHandler.saveConfig(this.config, new File(Config.configDirectory, "slotlocking.json"), ConfigHandler.GSON);
    }

    public void resetSlotLocking() {
        String profile = SlotLocking.currentProfileOrGeneric();
        SlotLockProfile p = this.config.profileData.get(profile);
        if (p != null) {
            p.slotLockData[0] = new SlotLockData();
        }
    }

    private static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    private static boolean isSkyblock() {
        return ScoreboardUtils.currentGamemode.isSkyblock();
    }

    private static boolean featureOn() {
        return Config.feature.sl.enableSlotLocking;
    }

    private static boolean bindingOn() {
        return Config.feature.sl.enableSlotBinding;
    }

    private static boolean lockAndOnSkyblock() {
        return SlotLocking.isSkyblock() && SlotLocking.featureOn();
    }

    private static GuiContainer currentContainer() {
        return SlotLocking.mc().field_71462_r instanceof GuiContainer ? (GuiContainer)SlotLocking.mc().field_71462_r : null;
    }

    private static boolean isValidIndex(int idx) {
        return idx >= 0 && idx <= 39;
    }

    private static boolean isHotbar(int idx) {
        return idx >= 0 && idx < 9;
    }

    private static boolean isInventory(int idx) {
        return idx >= 9 && idx < 36;
    }

    private static boolean isArmor(int idx) {
        return idx >= 36 && idx <= 39;
    }

    private static boolean isPlayerInventorySlot(Slot s) {
        return s != null && s.field_75224_c == SlotLocking.mc().field_71439_g.field_71071_by && SlotLocking.isValidIndex(s.getSlotIndex());
    }

    private static String currentProfileOrGeneric() {
        String p = SkyblockData.getCurrentProfile();
        return p == null ? "generic" : p;
    }

    private static int[] getMouseScaled() {
        ScaledResolution sr = new ScaledResolution(SlotLocking.mc());
        int sw = sr.func_78326_a();
        int sh = sr.func_78328_b();
        int mx = Mouse.getX() * sw / SlotLocking.mc().field_71443_c;
        int my = sh - Mouse.getY() * sh / SlotLocking.mc().field_71440_d - 1;
        return new int[]{mx, my};
    }

    private static Slot getSlotAtMouse(GuiContainer container) {
        int[] m = SlotLocking.getMouseScaled();
        return ((AccessorGuiContainer)container).doGetSlotAtPosition(m[0], m[1]);
    }

    private LockedSlot[] getDataForProfile() {
        if (!SlotLocking.lockAndOnSkyblock()) {
            return null;
        }
        if (Config.feature.sl.disableInStorage) {
            String raw = TablistParser.lastOpenChestName.trim();
            if ("Storage".equals(raw)) {
                return null;
            }
            String name = StringUtils.cleanColour(raw);
            if (WINDOW_REGEX.matcher(name).matches() || ECHEST_WINDOW_REGEX.matcher(name).matches()) {
                return null;
            }
        }
        String profile = SlotLocking.currentProfileOrGeneric();
        SlotLockProfile prof = this.config.profileData.computeIfAbsent(profile, k -> new SlotLockProfile());
        if (prof.slotLockData[0] == null) {
            prof.slotLockData[0] = new SlotLockData();
        }
        return prof.slotLockData[0].lockedSlots;
    }

    private static LockedSlot getLockedOrDefault(LockedSlot[] arr, int idx) {
        if (arr == null || !SlotLocking.isValidIndex(idx)) {
            return DEFAULT_LOCKED_SLOT;
        }
        LockedSlot s = arr[idx];
        return s != null ? s : DEFAULT_LOCKED_SLOT;
    }

    private static LockedSlot getOrCreateLocked(LockedSlot[] arr, int idx) {
        if (arr[idx] == null) {
            arr[idx] = new LockedSlot();
        }
        return arr[idx];
    }

    public LockedSlot getLockedSlot(Slot slot) {
        if (!SlotLocking.lockAndOnSkyblock() || slot == null || slot.field_75224_c != SlotLocking.mc().field_71439_g.field_71071_by) {
            return null;
        }
        int idx = slot.getSlotIndex();
        if (!SlotLocking.isValidIndex(idx)) {
            return null;
        }
        return this.getLockedSlotIndex(idx);
    }

    public LockedSlot getLockedSlotIndex(int index) {
        if (!SlotLocking.lockAndOnSkyblock()) {
            return null;
        }
        return SlotLocking.getLockedOrDefault(this.getDataForProfile(), index);
    }

    public boolean isSlotLocked(Slot slot) {
        LockedSlot l = this.getLockedSlot(slot);
        return l != null && (l.locked || Config.feature.sl.bindingAlsoLocks && l.boundTo != -1);
    }

    public boolean isSlotIndexLocked(int index) {
        LockedSlot l = this.getLockedSlotIndex(index);
        return l != null && (l.locked || Config.feature.sl.bindingAlsoLocks && l.boundTo != -1);
    }

    public void changedSlot(int slotNumber) {
        int delay = Config.feature.sl.slotLockSwapDelay;
        if (delay == 0 || !this.isSlotIndexLocked(slotNumber) || !SlotLocking.isHotbar(slotNumber)) {
            return;
        }
        long now = System.currentTimeMillis();
        for (int i = 0; i < this.slotChanges.length; ++i) {
            if (i == slotNumber || this.slotChanges[i] == 0L || this.slotChanges[i] + (long)delay <= now) continue;
            this.slotChanges[i] = 0L;
        }
        this.slotChanges[slotNumber] = now;
    }

    public boolean isSwapedSlotLocked() {
        int delay = Config.feature.sl.slotLockSwapDelay;
        if (delay == 0) {
            return false;
        }
        long now = System.currentTimeMillis();
        for (int i = 0; i < this.slotChanges.length; ++i) {
            if (this.slotChanges[i] == 0L || !this.isSlotIndexLocked(i) || this.slotChanges[i] + (long)delay <= now) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void keyboardInput(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (!SlotLocking.lockAndOnSkyblock()) {
            return;
        }
        GuiContainer container = SlotLocking.currentContainer();
        if (container == null) {
            return;
        }
        int key = Config.feature.sl.slotLockKey;
        if (!this.lockKeyHeld && KeybindHelper.isKeyPressed(key) && !Keyboard.isRepeatEvent()) {
            Slot foc = SlotLocking.getSlotAtMouse(container);
            if (!SlotLocking.isPlayerInventorySlot(foc)) {
                return;
            }
            int idx = foc.getSlotIndex();
            if (idx == 8) {
                return;
            }
            this.pairingSlot = SlotLocking.isInventory(idx) || SlotLocking.isArmor(idx) ? foc : null;
            LockedSlot[] arr = this.getDataForProfile();
            if (arr != null) {
                LockedSlot ls = SlotLocking.getOrCreateLocked(arr, idx);
                ls.locked = !ls.locked;
                ls.boundTo = -1;
                this.playToggleSound(ls.locked);
                if (SlotLocking.isHotbar(idx) && ls.locked) {
                    for (int i = 9; i <= 39; ++i) {
                        LockedSlot other = arr[i];
                        if (other == null || other.boundTo != idx) continue;
                        other.boundTo = -1;
                    }
                }
            }
        }
        this.lockKeyHeld = KeybindHelper.isKeyDown(key);
        if (!this.lockKeyHeld) {
            this.pairingSlot = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void mouseEvent(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!SlotLocking.lockAndOnSkyblock()) {
            return;
        }
        GuiContainer container = SlotLocking.currentContainer();
        if (container == null) {
            return;
        }
        if (SlotLocking.bindingOn() && this.lockKeyHeld && this.pairingSlot != null) {
            Slot hover = SlotLocking.getSlotAtMouse(container);
            if (SlotLocking.isPlayerInventorySlot(hover) && hover.getSlotIndex() != 8) {
                LockedSlot[] arr;
                int targetIdx = hover.getSlotIndex();
                if (!SlotLocking.isValidIndex(targetIdx)) {
                    return;
                }
                boolean targetHotbar = SlotLocking.isHotbar(targetIdx);
                int pairingIdx = this.pairingSlot.getSlotIndex();
                if (targetHotbar && targetIdx != pairingIdx && (arr = this.getDataForProfile()) != null) {
                    LockedSlot target = SlotLocking.getOrCreateLocked(arr, targetIdx);
                    if (!target.locked) {
                        LockedSlot src = SlotLocking.getOrCreateLocked(arr, pairingIdx);
                        src.boundTo = targetIdx;
                        src.locked = false;
                        target.boundTo = pairingIdx;
                    }
                }
            } else {
                int pairingIdx = this.pairingSlot.getSlotIndex();
                LockedSlot[] arr = this.getDataForProfile();
                if (arr != null && arr[pairingIdx] != null) {
                    if (arr[pairingIdx].boundTo >= 0) {
                        arr[arr[pairingIdx].boundTo] = null;
                    }
                    arr[pairingIdx] = null;
                }
            }
        }
    }

    public void toggleLock(int lockIndex) {
        if (lockIndex == 8) {
            return;
        }
        LockedSlot[] arr = this.getDataForProfile();
        if (arr == null) {
            return;
        }
        LockedSlot ls = SlotLocking.getOrCreateLocked(arr, lockIndex);
        ls.locked = !ls.locked;
        ls.boundTo = -1;
        this.playToggleSound(ls.locked);
        if (SlotLocking.isHotbar(lockIndex) && ls.locked) {
            for (int i = 9; i <= 39; ++i) {
                LockedSlot other = arr[i];
                if (other == null || other.boundTo != lockIndex) continue;
                other.boundTo = -1;
            }
        }
    }

    @SubscribeEvent
    public void onWindowClick(SlotClickEvent e) {
        LockedSlot locked = this.getLockedSlot(e.slot);
        if (locked == null) {
            return;
        }
        if (locked.locked || e.clickType == 2 && this.isSlotIndexLocked(e.clickedButton)) {
            e.setCanceled(true);
            return;
        }
        if (SlotLocking.bindingOn() && e.clickType == 1 && locked.boundTo != -1) {
            int to;
            int from;
            int size;
            GuiContainer container = SlotLocking.currentContainer();
            if (container == null) {
                return;
            }
            Slot bound = container.field_147002_h.func_75147_a((IInventory)SlotLocking.mc().field_71439_g.field_71071_by, locked.boundTo);
            if (bound == null) {
                return;
            }
            LockedSlot boundLocked = this.getLockedSlot(bound);
            int id = e.slot.getSlotIndex();
            int idChest = id + ((size = container.field_147002_h.field_75151_b.size()) - 45);
            if (idChest >= 9 && 0 <= locked.boundTo && locked.boundTo < 9 && !boundLocked.locked) {
                from = idChest;
                to = locked.boundTo;
                if (boundLocked == DEFAULT_LOCKED_SLOT) {
                    LockedSlot[] arr = this.getDataForProfile();
                    LockedSlot tmp = SlotLocking.getOrCreateLocked(arr, locked.boundTo);
                    tmp.boundTo = idChest;
                } else {
                    boundLocked.boundTo = id;
                }
            } else if (0 <= id && id < 9 && locked.boundTo >= 9 && locked.boundTo <= 39) {
                if (boundLocked.locked || boundLocked.boundTo != id) {
                    locked.boundTo = -1;
                    return;
                }
                from = bound.field_75222_d;
                to = id;
            } else {
                return;
            }
            if (from == 39) {
                from = 5;
            }
            if (from == 38) {
                from = 6;
            }
            if (from == 37) {
                from = 7;
            }
            if (from == 36) {
                from = 8;
            }
            SlotLocking.mc().field_71442_b.func_78753_a(container.field_147002_h.field_75152_c, from, to, 2, (EntityPlayer)SlotLocking.mc().field_71439_g);
            e.setCanceled(true);
        } else if (SlotLocking.bindingOn() && locked.boundTo != -1 && Config.feature.sl.bindingAlsoLocks) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void drawScreenEvent(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!SlotLocking.bindingOn() || event.isCanceled() || this.pairingSlot == null || !this.lockKeyHeld) {
            this.setTopHalfBarrier = false;
            return;
        }
        LockedSlot[] arr = this.getDataForProfile();
        LockedSlot locked = SlotLocking.getLockedOrDefault(arr, this.pairingSlot.getSlotIndex());
        if (locked.boundTo >= 0 && locked.boundTo < 8) {
            return;
        }
        GuiContainer container = SlotLocking.currentContainer();
        if (container == null) {
            return;
        }
        AccessorGuiContainer agc = (AccessorGuiContainer)container;
        int x1 = agc.getGuiLeft() + this.pairingSlot.field_75223_e + 8;
        int y1 = agc.getGuiTop() + this.pairingSlot.field_75221_f + 8;
        int x2 = event.mouseX;
        int y2 = event.mouseY;
        if (x2 > x1 - 8 && x2 < x1 + 8 && y2 > y1 - 8 && y2 < y1 + 8) {
            return;
        }
        this.drawLinkArrow(x1, y1, x2, y2);
        this.setTopHalfBarrier = true;
    }

    private void drawLinkArrow(int x1, int y1, int x2, int y2) {
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)287044);
        GlStateManager.func_179140_f();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
        GlStateManager.func_179131_c((float)0.2f, (float)0.93333334f, (float)0.8666667f, (float)1.0f);
        GlStateManager.func_179090_x();
        GL11.glLineWidth((float)1.0f);
        GL11.glEnable((int)2848);
        this.drawLine(x1, y1, x2, y2);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
        GL11.glPopAttrib();
        GlStateManager.func_179121_F();
    }

    private void drawLine(int x1, int y1, int x2, int y2) {
        Vector2f vec = new Vector2f((float)(x2 - x1), (float)(y2 - y1));
        vec.normalise(vec);
        Vector2f side = new Vector2f(vec.y, -vec.x);
        Tessellator t = Tessellator.func_178181_a();
        WorldRenderer w = t.func_178180_c();
        int lines = 6;
        for (int i = 0; i < 6; ++i) {
            w.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            w.func_181662_b((double)((float)x1 - side.x + side.x * (float)i / 6.0f), (double)((float)y1 - side.y + side.y * (float)i / 6.0f), 0.0).func_181675_d();
            w.func_181662_b((double)((float)x2 - side.x + side.x * (float)i / 6.0f), (double)((float)y2 - side.y + side.y * (float)i / 6.0f), 0.0).func_181675_d();
            t.func_78381_a();
        }
    }

    public void drawSlot(Slot slot) {
        LockedSlot locked = this.getLockedSlot(slot);
        if (locked == null) {
            return;
        }
        if (locked.locked) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)400.0f);
            SlotLocking.mc().func_110434_K().func_110577_a(Resources.LOCK.getResource());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GlStateManager.func_179132_a((boolean)false);
            RenderUtils.drawTexturedRect(slot.field_75223_e, slot.field_75221_f, 16.0f, 16.0f, 0.0f, 1.0f, 0.0f, 1.0f, 9728);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179147_l();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-400.0f);
            return;
        }
        if (!SlotLocking.bindingOn()) {
            return;
        }
        int idx = slot.getSlotIndex();
        if (slot.func_111238_b() && locked.boundTo >= 0 && locked.boundTo <= 39) {
            int y1;
            int x1;
            GuiContainer container = SlotLocking.currentContainer();
            if (container == null) {
                return;
            }
            AccessorGuiContainer agc = (AccessorGuiContainer)container;
            int[] m = SlotLocking.getMouseScaled();
            boolean hoverOver = agc.doIsMouseOverSlot(slot, m[0], m[1]);
            Slot boundSlot = container.field_147002_h.func_75147_a((IInventory)SlotLocking.mc().field_71439_g.field_71071_by, locked.boundTo);
            if (boundSlot == null) {
                return;
            }
            if (hoverOver || idx >= 9) {
                SlotLocking.drawBoundOverlay(slot);
                SlotLocking.rerenderItemOverlay(slot);
            } else if (this.pairingSlot != null && this.lockKeyHeld && idx < 9 && !SlotLocking.pointInRect(m[0], m[1], x1 = agc.getGuiLeft() + this.pairingSlot.field_75223_e, y1 = agc.getGuiTop() + this.pairingSlot.field_75221_f, 16, 16)) {
                Gui.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)-2130706433);
            }
            if (hoverOver) {
                LockedSlot boundLocked = this.getLockedSlot(boundSlot);
                if (boundLocked == null || boundLocked.locked || boundSlot.getSlotIndex() >= 9 && boundLocked.boundTo != idx) {
                    locked.boundTo = -1;
                    return;
                }
                SlotLocking.drawBoundOverlay(boundSlot);
                SlotLocking.rerenderItemOverlay(boundSlot);
                int maxIter = 100;
                float x12 = slot.field_75223_e + 8;
                float y12 = slot.field_75221_f + 8;
                float x2 = boundSlot.field_75223_e + 8;
                float y2 = boundSlot.field_75221_f + 8;
                Vector2f dir = new Vector2f(x2 - x12, y2 - y12);
                dir.normalise(dir);
                while (SlotLocking.insideSlot(x12, y12, slot) && maxIter-- > 50) {
                    x12 += dir.x;
                    y12 += dir.y;
                }
                while (SlotLocking.insideSlot(x2, y2, boundSlot) && maxIter-- > 0) {
                    x2 -= dir.x;
                    y2 -= dir.y;
                }
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
                this.drawLinkArrow((int)x12, (int)y12, (int)x2, (int)y2);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-200.0f);
            }
        } else if (idx < 9 && this.pairingSlot != null && this.lockKeyHeld) {
            int y1;
            int x1;
            GuiContainer container = SlotLocking.currentContainer();
            if (container == null) {
                return;
            }
            AccessorGuiContainer agc = (AccessorGuiContainer)container;
            int[] m = SlotLocking.getMouseScaled();
            if (!SlotLocking.pointInRect(m[0], m[1], x1 = agc.getGuiLeft() + this.pairingSlot.field_75223_e, y1 = agc.getGuiTop() + this.pairingSlot.field_75221_f, 16, 16)) {
                Gui.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)-2130706433);
            }
        }
    }

    private static boolean pointInRect(int px, int py, int rx, int ry, int w, int h) {
        return px > rx && px < rx + w && py > ry && py < ry + h;
    }

    private static boolean insideSlot(float x, float y, Slot s) {
        return x > (float)s.field_75223_e && x < (float)(s.field_75223_e + 16) && y > (float)s.field_75221_f && y < (float)(s.field_75221_f + 16);
    }

    private static void drawBoundOverlay(Slot s) {
        SlotLocking.mc().func_110434_K().func_110577_a(Resources.BOUND.getResource());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
        GlStateManager.func_179132_a((boolean)false);
        RenderUtils.drawTexturedRect(s.field_75223_e, s.field_75221_f, 16.0f, 16.0f, 0.0f, 1.0f, 0.0f, 1.0f, 9728);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179147_l();
    }

    private static void rerenderItemOverlay(Slot s) {
        ItemStack st = s.func_75211_c();
        if (st != null) {
            SlotLocking.mc().func_175599_af().func_180453_a(SlotLocking.mc().field_71466_p, st, s.field_75223_e, s.field_75221_f, null);
        }
    }

    private void playToggleSound(final boolean locked) {
        if (!Config.feature.sl.slotLockSound) {
            return;
        }
        final float vol = Math.min(1.0f, Math.max(0.0f, Config.feature.sl.slotLockSoundVol / 100.0f));
        if (vol <= 0.0f) {
            return;
        }
        PositionedSound sound = new PositionedSound(new ResourceLocation("random.orb")){
            {
                super(x0);
                this.field_147662_b = vol;
                this.field_147663_c = locked ? 0.943f : 0.1f;
                this.field_147659_g = false;
                this.field_147665_h = 0;
                this.field_147666_i = ISound.AttenuationType.NONE;
            }
        };
        float old = SlotLocking.mc().field_71474_y.func_151438_a(SoundCategory.PLAYERS);
        SlotLocking.mc().field_71474_y.func_151439_a(SoundCategory.PLAYERS, 1.0f);
        SlotLocking.mc().func_147118_V().func_147682_a((ISound)sound);
        SlotLocking.mc().field_71474_y.func_151439_a(SoundCategory.PLAYERS, old);
    }

    private boolean shouldShowBarrier(int slotNumber, IInventory inv) {
        if (!(inv instanceof InventoryPlayer)) {
            return false;
        }
        if (slotNumber < 9) {
            return false;
        }
        if (this.pairingSlot != null && (slotNumber == this.pairingSlot.field_75222_d || this.isArmourSlot(slotNumber, this.pairingSlot.field_75222_d))) {
            return false;
        }
        return this.setTopHalfBarrier;
    }

    @SubscribeEvent
    public void barrierInventory(ReplaceItemEvent event) {
        if (!this.shouldShowBarrier(event.getSlotNumber(), event.getInventory())) {
            return;
        }
        ItemStack stack = new ItemStack(Blocks.field_180401_cv);
        ItemUtils.getOrCreateTag(stack).func_74757_a("NEFHIDETOOLTIP", true);
        event.replaceWith(stack);
    }

    boolean isArmourSlot(int eventSlotNumber, int pairingSlotNumber) {
        return eventSlotNumber == 39 && pairingSlotNumber == 5 || eventSlotNumber == 38 && pairingSlotNumber == 6 || eventSlotNumber == 37 && pairingSlotNumber == 7 || eventSlotNumber == 36 && pairingSlotNumber == 8;
    }

    public void setRealSlot(Slot realSlot) {
        this.realSlot = realSlot;
    }

    public Slot getRealSlot() {
        return this.realSlot;
    }

    public static class SlotLockingConfig {
        public HashMap<String, SlotLockProfile> profileData = new HashMap();
    }

    public static class SlotLockProfile {
        public SlotLockData[] slotLockData = new SlotLockData[1];
    }

    public static class SlotLockData {
        public LockedSlot[] lockedSlots = new LockedSlot[40];
    }

    public static class LockedSlot {
        public boolean locked = false;
        public int boundTo = -1;
    }
}

