/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.mixin;

import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.ItemStack;
import org.ginafro.notenoughfakepixel.features.skyblock.qol.ItemAnimations;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class}, priority=1010)
public class MixinItemRenderer {
    @Shadow
    private ItemStack field_78453_b;

    @Inject(method={"transformFirstPersonItem(FF)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void itemTransform(float equipProgress, float swingProgress, CallbackInfo ci) {
        if (!ItemAnimations.shouldChange()) {
            return;
        }
        ci.cancel();
        ItemAnimations.processItemAnimation(equipProgress, swingProgress);
    }

    @Inject(method={"doItemUsedTransformations"}, at={@At(value="HEAD")}, cancellable=true)
    public void useTransform(float swingProgress, CallbackInfo ci) {
        if (!ItemAnimations.shouldChangeScaleSwing()) {
            return;
        }
        ci.cancel();
        ItemAnimations.changeSwingScale(swingProgress);
    }

    @Inject(method={"performDrinking"}, at={@At(value="HEAD")}, cancellable=true)
    public void drinkTransform(AbstractClientPlayer clientPlayer, float partialTicks, CallbackInfo ci) {
        if (ItemAnimations.shouldRotationlessDrink()) {
            ci.cancel();
            ItemAnimations.rotationlessDrink(clientPlayer, partialTicks);
            return;
        }
        if (ItemAnimations.shouldScaledDrink()) {
            ci.cancel();
            ItemAnimations.scaledDrinking(clientPlayer, partialTicks, this.field_78453_b);
        }
    }
}

