/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.mixin;

import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.events.RenderEntityModelEvent;
import org.ginafro.notenoughfakepixel.features.skyblock.diana.Diana;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.mobs.LividDisplay;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.mobs.StarredMobDisplay;
import org.ginafro.notenoughfakepixel.features.skyblock.slayers.BlazeAttunements;
import org.ginafro.notenoughfakepixel.features.skyblock.slayers.SlayerMobsDisplay;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RendererLivingEntity.class})
public abstract class MixinRendererLivingEntity<T extends EntityLivingBase> {
    @Shadow
    protected ModelBase field_77045_g;
    @Shadow
    protected FloatBuffer field_177095_g;
    @Final
    @Shadow
    private static DynamicTexture field_177096_e;
    private final StarredMobDisplay notEnoughFakepixel$starredMobDisplay = new StarredMobDisplay();
    private final Diana notEnoughFakepixel$diana = new Diana();
    private final LividDisplay notEnoughFakepixel$lividDisplay = new LividDisplay();
    private final SlayerMobsDisplay notEnoughFakepixel$slayerMobsDisplay = new SlayerMobsDisplay();
    private final BlazeAttunements notEnoughFakepixel$blaze = new BlazeAttunements();
    private final Set<EntityLivingBase> notEnoughFakepixel$starredEntities = this.notEnoughFakepixel$starredMobDisplay.getCurrentEntities();
    private final Set<EntityLivingBase> notEnoughFakepixel$inqEntities = this.notEnoughFakepixel$diana.getCurrentEntities();
    private final Set<EntityLivingBase> notEnoughFakepixel$lividEntities = this.notEnoughFakepixel$lividDisplay.getLividEntity();
    private final Set<EntityLivingBase> notEnoughFakepixel$slayerEntities = this.notEnoughFakepixel$slayerMobsDisplay.getSlayerEntity();
    private final Set<EntityLivingBase> notEnoughFakepixel$slayerMiniEntities = this.notEnoughFakepixel$slayerMobsDisplay.getSlayerMiniEntity();
    private final Set<EntityLivingBase> notEnoughFakepixel$blazeEntities = this.notEnoughFakepixel$blaze.getBlazeEntity();

    @Redirect(method={"renderName*"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;getDisplayName()Lnet/minecraft/util/IChatComponent;"))
    public IChatComponent renderName_getDisplayName(EntityLivingBase entity) {
        return entity.func_145748_c_();
    }

    @Inject(method={"setBrightness"}, at={@At(value="HEAD")}, cancellable=true)
    private void setBrightness(T entity, float partialTicks, boolean combineTextures, CallbackInfoReturnable<Boolean> cir) {
        if (this.shouldApplyBrightnessBoost(entity)) {
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179098_w();
            GL11.glTexEnvi((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_77478_a);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176093_u);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_77478_a);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179098_w();
            GL11.glTexEnvi((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176099_x, (int)OpenGlHelper.field_176094_t);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_176092_v);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176091_w);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176080_A, (int)OpenGlHelper.field_176092_v);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176076_D, (int)770);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_176091_w);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
            this.field_177095_g.position(0);
            Color color = this.getBrightnessColor(entity);
            if (color == null) {
                color = Color.WHITE;
            }
            this.field_177095_g.put((float)color.getRed() / 255.0f);
            this.field_177095_g.put((float)color.getGreen() / 255.0f);
            this.field_177095_g.put((float)color.getBlue() / 255.0f);
            this.field_177095_g.put((float)color.getAlpha() / 255.0f);
            this.field_177095_g.flip();
            GL11.glTexEnv((int)8960, (int)8705, (FloatBuffer)this.field_177095_g);
            GlStateManager.func_179138_g((int)OpenGlHelper.field_176096_r);
            GlStateManager.func_179098_w();
            GlStateManager.func_179144_i((int)field_177096_e.func_110552_b());
            GL11.glTexEnvi((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_176091_w);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_77476_b);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_176091_w);
            GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            cir.setReturnValue(true);
        }
    }

    private boolean shouldApplyBrightnessBoost(T entity) {
        if (this.notEnoughFakepixel$starredEntities.contains(entity)) {
            return true;
        }
        if (this.notEnoughFakepixel$inqEntities.contains(entity)) {
            return true;
        }
        if (this.notEnoughFakepixel$lividEntities.contains(entity)) {
            return true;
        }
        if (this.notEnoughFakepixel$slayerEntities.contains(entity)) {
            return true;
        }
        if (this.notEnoughFakepixel$slayerMiniEntities.contains(entity)) {
            return true;
        }
        if (this.notEnoughFakepixel$blazeEntities.contains(entity)) {
            return true;
        }
        if (Config.feature.dungeons.dungeonsWithersBox && entity instanceof EntityWither) {
            String name = EnumChatFormatting.func_110646_a((String)entity.func_70005_c_());
            return name != null && (name.equals("Maxor") || name.equals("Storm") || name.equals("Goldor") || name.equals("Necron"));
        }
        return false;
    }

    private Color getBrightnessColor(T entity) {
        String name;
        if (this.notEnoughFakepixel$starredEntities.contains(entity)) {
            return ColorUtils.getColor(Config.feature.dungeons.dungeonsStarredBoxColor);
        }
        if (this.notEnoughFakepixel$inqEntities.contains(entity)) {
            return ColorUtils.getColor(Config.feature.diana.dianaInqOutlineColor);
        }
        if (this.notEnoughFakepixel$lividEntities.contains(entity)) {
            return new Color(LividDisplay.LIVID_COLOUR);
        }
        if (this.notEnoughFakepixel$slayerEntities.contains(entity)) {
            return ColorUtils.getColor(Config.feature.slayer.slayerBossColor);
        }
        if (this.notEnoughFakepixel$slayerMiniEntities.contains(entity)) {
            return ColorUtils.getColor(Config.feature.slayer.slayerColor);
        }
        if (this.notEnoughFakepixel$blazeEntities.contains(entity)) {
            List armorStands = ((EntityLivingBase)entity).field_70170_p.func_72872_a(EntityArmorStand.class, entity.func_174813_aQ().func_72317_d(0.0, 2.0, 0.0).func_72314_b(1.0, 1.0, 1.0));
            for (Entity armorStand : armorStands) {
                String attunement;
                int colorInt;
                String displayName;
                Matcher matcher;
                if (!(armorStand instanceof EntityArmorStand) || !(matcher = BlazeAttunements.COLOR_PATTERN.matcher(displayName = armorStand.func_145748_c_().func_150260_c())).find() || (colorInt = BlazeAttunements.getColorForAttunement(attunement = matcher.group().toUpperCase())) == -1) continue;
                return new Color(colorInt);
            }
        }
        if (Config.feature.dungeons.dungeonsWithersBox && entity instanceof EntityWither && (name = EnumChatFormatting.func_110646_a((String)entity.func_70005_c_())) != null && (name.equals("Maxor") || name.equals("Storm") || name.equals("Goldor") || name.equals("Necron"))) {
            return ColorUtils.getColor(Config.feature.dungeons.dungeonsWithersBoxColor);
        }
        return null;
    }

    @Inject(method={"doRender(Lnet/minecraft/entity/EntityLivingBase;DDDFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/RendererLivingEntity;renderLayers(Lnet/minecraft/entity/EntityLivingBase;FFFFFFF)V", shift=At.Shift.AFTER)})
    private void onPostRenderLayers(T entity, double x, double y, double z, float entityYaw, float partialTicks, CallbackInfo ci) {
        float limbSwing = ((EntityLivingBase)entity).field_70754_ba - ((EntityLivingBase)entity).field_70721_aZ * (1.0f - partialTicks);
        float limbSwingAmount = ((EntityLivingBase)entity).field_70722_aY + (((EntityLivingBase)entity).field_70721_aZ - ((EntityLivingBase)entity).field_70722_aY) * partialTicks;
        float ageInTicks = (float)((EntityLivingBase)entity).field_70173_aa + partialTicks;
        float headYaw = ((EntityLivingBase)entity).field_70758_at + (((EntityLivingBase)entity).field_70759_as - ((EntityLivingBase)entity).field_70758_at) * partialTicks;
        float headPitch = ((EntityLivingBase)entity).field_70127_C + (((EntityLivingBase)entity).field_70125_A - ((EntityLivingBase)entity).field_70127_C) * partialTicks;
        float scaleFactor = 0.0625f;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderEntityModelEvent((EntityLivingBase)entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch, scaleFactor, this.field_77045_g))) {
            // empty if block
        }
    }
}

