/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.serverdata;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ginafro.notenoughfakepixel.events.handlers.RepoHandler;

public class AccessoriesData {
    public static AccessoriesData INSTANCE = new AccessoriesData();
    public static boolean finalPage = false;
    public static boolean show = false;
    public static int totalMp = 0;
    public static int maxMp = 0;
    public static int maxMpRec = 0;
    private static int bonuses = 0;
    private Set<Accessory> repoAccessories;
    private Set<Accessory> currentAccessories;
    private static final RepoWrapper STUB = new RepoWrapper();

    public AccessoriesData() {
        RepoWrapper wrapper = RepoHandler.getData("accessories", RepoWrapper.class, STUB);
        this.repoAccessories = wrapper.getAccessories() != null ? wrapper.getAccessories() : Collections.emptySet();
        this.currentAccessories = new HashSet<Accessory>();
        bonuses = wrapper.getBonuses();
    }

    public List<Accessory> getMissingAccessories() {
        return this.repoAccessories.stream().filter(acc -> {
            for (Accessory current : this.currentAccessories) {
                if (this.handleSpecialCases(current, (Accessory)acc)) {
                    return false;
                }
                if (!current.getName().equalsIgnoreCase(acc.getName())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private boolean handleSpecialCases(Accessory current, Accessory accessory) {
        String name = current.getName().toLowerCase();
        String accName = accessory.getName().toLowerCase();
        if (name.contains("abicase") && accName.contains("abicase")) {
            for (Accessory acc : this.currentAccessories) {
                if (!acc.getName().toLowerCase().contains("abicase")) continue;
                return true;
            }
        }
        return false;
    }

    public void addAccessory(Accessory accessory) {
        if (this.currentAccessories.stream().noneMatch(acc -> acc.getName().equalsIgnoreCase(accessory.getName()))) {
            this.currentAccessories.add(accessory);
        }
    }

    public void clearAccessories() {
        this.currentAccessories.clear();
    }

    public static void calculateMp() {
        AccessoriesData.calculateTotalMp();
        AccessoriesData.calculateMaxMp();
        AccessoriesData.calculateMaxRecomb();
    }

    private static int getMpByRarity(String rarity) {
        return AccessoriesData.getMpByRarity(rarity, false);
    }

    private static int getMpByRarity(String rarity, boolean withRecomb) {
        rarity = rarity.trim();
        if (withRecomb) {
            switch (rarity.toLowerCase()) {
                case "special": 
                case "common": {
                    return 5;
                }
                case "uncommon": {
                    return 8;
                }
                case "rare": {
                    return 12;
                }
                case "epic": {
                    return 16;
                }
                case "legendary": {
                    return 22;
                }
                case "mythic": 
                case "divine": {
                    return 28;
                }
            }
            return 0;
        }
        switch (rarity.toLowerCase()) {
            case "special": 
            case "common": {
                return 3;
            }
            case "uncommon": {
                return 5;
            }
            case "rare": {
                return 8;
            }
            case "epic": {
                return 12;
            }
            case "legendary": {
                return 16;
            }
            case "mythic": {
                return 22;
            }
            case "divine": {
                return 28;
            }
        }
        return 0;
    }

    public static void calculateTotalMp() {
        totalMp = INSTANCE.getCurrentAccessories().stream().mapToInt(acc -> AccessoriesData.getMpByRarity(acc.getRarity())).sum();
    }

    public static void calculateMaxMp() {
        maxMp = INSTANCE.getRepoAccessories().stream().mapToInt(acc -> AccessoriesData.getMpByRarity(acc.getRarity())).sum();
        maxMp += bonuses;
    }

    private static void calculateMaxRecomb() {
        maxMpRec = INSTANCE.getRepoAccessories().stream().mapToInt(acc -> AccessoriesData.getMpByRarity(acc.getRarity(), true)).sum();
        maxMpRec += bonuses;
    }

    public static String getColorLevel(int max) {
        int total = totalMp;
        if (total >= max) {
            return "\u00a7b";
        }
        if (total >= 2 * max / 3) {
            return "\u00a7a";
        }
        if (total >= max / 3) {
            return "\u00a7e";
        }
        return "\u00a7c";
    }

    public Set<Accessory> getRepoAccessories() {
        return this.repoAccessories;
    }

    public Set<Accessory> getCurrentAccessories() {
        return this.currentAccessories;
    }

    public void setRepoAccessories(Set<Accessory> repoAccessories) {
        this.repoAccessories = repoAccessories;
    }

    public void setCurrentAccessories(Set<Accessory> currentAccessories) {
        this.currentAccessories = currentAccessories;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessoriesData)) {
            return false;
        }
        AccessoriesData other = (AccessoriesData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<Accessory> this$repoAccessories = this.getRepoAccessories();
        Set<Accessory> other$repoAccessories = other.getRepoAccessories();
        if (this$repoAccessories == null ? other$repoAccessories != null : !((Object)this$repoAccessories).equals(other$repoAccessories)) {
            return false;
        }
        Set<Accessory> this$currentAccessories = this.getCurrentAccessories();
        Set<Accessory> other$currentAccessories = other.getCurrentAccessories();
        return !(this$currentAccessories == null ? other$currentAccessories != null : !((Object)this$currentAccessories).equals(other$currentAccessories));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccessoriesData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Accessory> $repoAccessories = this.getRepoAccessories();
        result = result * 59 + ($repoAccessories == null ? 43 : ((Object)$repoAccessories).hashCode());
        Set<Accessory> $currentAccessories = this.getCurrentAccessories();
        result = result * 59 + ($currentAccessories == null ? 43 : ((Object)$currentAccessories).hashCode());
        return result;
    }

    public String toString() {
        return "AccessoriesData(repoAccessories=" + this.getRepoAccessories() + ", currentAccessories=" + this.getCurrentAccessories() + ")";
    }

    private static class RepoWrapper {
        private Set<Accessory> accessories = Collections.emptySet();
        private int bonuses = 0;

        public Set<Accessory> getAccessories() {
            return this.accessories;
        }

        public int getBonuses() {
            return this.bonuses;
        }

        public void setAccessories(Set<Accessory> accessories) {
            this.accessories = accessories;
        }

        public void setBonuses(int bonuses) {
            this.bonuses = bonuses;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RepoWrapper)) {
                return false;
            }
            RepoWrapper other = (RepoWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getBonuses() != other.getBonuses()) {
                return false;
            }
            Set<Accessory> this$accessories = this.getAccessories();
            Set<Accessory> other$accessories = other.getAccessories();
            return !(this$accessories == null ? other$accessories != null : !((Object)this$accessories).equals(other$accessories));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RepoWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getBonuses();
            Set<Accessory> $accessories = this.getAccessories();
            result = result * 59 + ($accessories == null ? 43 : ((Object)$accessories).hashCode());
            return result;
        }

        public String toString() {
            return "AccessoriesData.RepoWrapper(accessories=" + this.getAccessories() + ", bonuses=" + this.getBonuses() + ")";
        }
    }

    public static class Accessory {
        public String rarity;
        public String name;

        public Accessory(String rarity, String name) {
            this.rarity = rarity;
            this.name = name;
        }

        public String getRarity() {
            return this.rarity;
        }

        public String getName() {
            return this.name;
        }

        public void setRarity(String rarity) {
            this.rarity = rarity;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accessory)) {
                return false;
            }
            Accessory other = (Accessory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$rarity = this.getRarity();
            String other$rarity = other.getRarity();
            if (this$rarity == null ? other$rarity != null : !this$rarity.equals(other$rarity)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Accessory;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $rarity = this.getRarity();
            result = result * 59 + ($rarity == null ? 43 : $rarity.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "AccessoriesData.Accessory(rarity=" + this.getRarity() + ", name=" + this.getName() + ")";
        }
    }
}

