/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.utils;

import java.awt.Color;
import org.ginafro.notenoughfakepixel.config.gui.core.ChromaColour;
import org.jetbrains.annotations.NotNull;

public class ColorUtils {
    private static final String DEFAULT_COLOR_STRING = "0:255:255:255:255";
    private static final Color DEFAULT_COLOR = new Color(255, 255, 255, 255);

    @NotNull
    public static Color getColor(String colorString) {
        if (colorString == null || colorString.split(":").length != 5) {
            System.err.println("Invalid color string: " + colorString + ". Expected 'chromaSpeed:alpha:r:g:b'. Using default: " + DEFAULT_COLOR_STRING);
            return DEFAULT_COLOR;
        }
        try {
            int argb = ChromaColour.specialToChromaRGB(colorString);
            return new Color(argb, true);
        }
        catch (Exception e) {
            System.err.println("Error parsing color string: " + colorString + ". Error: " + e.getMessage() + ". Using default: " + DEFAULT_COLOR_STRING);
            return DEFAULT_COLOR;
        }
    }

    public static String cleanColor(String in) {
        return in.replaceAll("(?i)\\u00A7.", "");
    }

    public static String colorToHex(Color color, boolean includeAlpha) {
        if (color == null) {
            return includeAlpha ? "#FFFFFFFF" : "#FFFFFF";
        }
        if (includeAlpha) {
            return String.format("#%08X", color.getRGB());
        }
        return String.format("#%06X", color.getRGB() & 0xFFFFFF);
    }
}

