/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.Nullable;

public class ConfigHandler {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @Nullable
    public static <T> T loadConfig(Class<T> configClass, File file, Gson gson) {
        return ConfigHandler.loadConfig(configClass, file, gson, false);
    }

    @Nullable
    public static <T> T loadConfig(Class<T> configClass, File file, Gson gson, boolean useGzip) {
        return ConfigHandler.loadConfig(configClass, file, gson, useGzip, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T loadConfig(Class<T> configClass, File file, Gson gson, boolean useGzip, boolean handleError) {
        if (!file.exists()) {
            return null;
        }
        try (BufferedReader reader = useGzip ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])), StandardCharsets.UTF_8)) : new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            Object object = gson.fromJson((Reader)reader, configClass);
            return (T)object;
        }
        catch (Exception e) {
            if (!handleError) {
                return null;
            }
            new RuntimeException("Invalid config file '" + file + "'. This will reset the config to default", e).printStackTrace();
            ConfigHandler.makeBackup(file, ".corrupted");
            return null;
        }
    }

    public static void saveConfig(Object config, File file, Gson gson) {
        ConfigHandler.saveConfig(config, file, gson, false);
    }

    public static void saveConfig(Object config, File file, Gson gson, boolean useGzip) {
        File tempFile = new File(file.getParent(), file.getName() + ".temp");
        try {
            tempFile.createNewFile();
            try (BufferedWriter writer = useGzip ? new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(Files.newOutputStream(tempFile.toPath(), new OpenOption[0])), StandardCharsets.UTF_8)) : new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(tempFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                writer.write(gson.toJson(config));
            }
            if (ConfigHandler.loadConfig(config.getClass(), tempFile, gson, useGzip, false) == null) {
                System.out.println("Config verification failed for " + tempFile + ", could not save config properly.");
                ConfigHandler.makeBackup(tempFile, ".backup");
                return;
            }
            try {
                Files.move(tempFile.toPath(), file.toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                Files.move(tempFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            ConfigHandler.makeBackup(tempFile, ".backup");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeBackup(File file, String suffix) {
        File backupFile = new File(file.getParent(), file.getName() + "-" + System.currentTimeMillis() + suffix);
        System.out.println("trying to make backup: " + backupFile.getName());
        try {
            Files.move(file.toPath(), backupFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException __) {
            try {
                Files.move(file.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception ___) {
                System.out.println("nef config gone");
            }
        }
        finally {
            file.delete();
        }
    }
}

