/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.utils;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.ginafro.notenoughfakepixel.utils.StringUtils;
import org.ginafro.notenoughfakepixel.variables.Rarity;
import org.ginafro.notenoughfakepixel.variables.Skins;
import org.jetbrains.annotations.NotNull;

public class ItemUtils {
    public static String getInternalName(ItemStack item) {
        if (!item.func_77942_o()) {
            return "";
        }
        if (!item.func_77978_p().func_74764_b("ExtraAttributes")) {
            return "";
        }
        NBTTagCompound extraAttributes = item.func_77978_p().func_74775_l("ExtraAttributes");
        if (!extraAttributes.func_74764_b("id")) {
            return "";
        }
        return extraAttributes.func_74779_i("id");
    }

    @NotNull
    public static NBTTagCompound getExtraAttributes(ItemStack itemStack) {
        NBTTagCompound tag = ItemUtils.getOrCreateTag(itemStack);
        NBTTagCompound extraAttributes = tag.func_74775_l("ExtraAttributes");
        tag.func_74782_a("ExtraAttributes", (NBTBase)extraAttributes);
        return extraAttributes;
    }

    public static int getExtraAttributesIntTag(ItemStack item, String tag) {
        NBTTagCompound extraAttributes = ItemUtils.getExtraAttributes(item);
        if (!extraAttributes.func_74764_b(tag)) {
            return -1;
        }
        return extraAttributes.func_74762_e(tag);
    }

    public static String getExtraAttributesStringTag(ItemStack item, String tag) {
        NBTTagCompound extraAttributes = ItemUtils.getExtraAttributes(item);
        if (!extraAttributes.func_74764_b(tag)) {
            return "";
        }
        return extraAttributes.func_74779_i(tag);
    }

    public static List<ItemStack> getAllCustomSkulls(Map<String, String> skullIcons) {
        ArrayList<ItemStack> skulls = new ArrayList<ItemStack>();
        for (Map.Entry<String, String> entry : skullIcons.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue().replace("skull:", "").trim();
            skulls.add(ItemUtils.createSkullWithTexture(name, value));
        }
        return skulls;
    }

    public static String getSkullTexture(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            return "";
        }
        if (!itemStack.func_77978_p().func_74764_b("SkullOwner")) {
            return "";
        }
        NBTTagCompound skullOwner = itemStack.func_77978_p().func_74775_l("SkullOwner");
        if (!skullOwner.func_74764_b("Properties")) {
            return "";
        }
        NBTTagCompound properties = skullOwner.func_74775_l("Properties");
        if (!properties.func_74764_b("textures")) {
            return "";
        }
        NBTTagList textures = properties.func_150295_c("textures", 10);
        if (textures.func_74745_c() == 0) {
            return "";
        }
        NBTTagCompound texture = textures.func_150305_b(0);
        if (!texture.func_74764_b("Value")) {
            return "";
        }
        return texture.func_74779_i("Value");
    }

    public static ItemStack createSkullWithTexture(String name, String textureHash) {
        ItemStack skull = new ItemStack(Items.field_151144_bL, 1, 3);
        NBTTagCompound skullTag = new NBTTagCompound();
        NBTTagCompound skullOwner = new NBTTagCompound();
        skullOwner.func_74778_a("Id", UUID.randomUUID().toString());
        NBTTagCompound textures = new NBTTagCompound();
        NBTTagList texturesList = new NBTTagList();
        NBTTagCompound valueTag = new NBTTagCompound();
        String fullTexture = "eyJ0aW1lc3RhbXAiOjAsInByb2ZpbGVJZCI6IiIsInByb2ZpbGVOYW1lIjoiIiwidGV4dHVyZXMiOnsiU0tJTiI6eyJ1cmwiOiJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLy" + textureHash + "\"}}}";
        valueTag.func_74778_a("Value", Base64.getEncoder().encodeToString(fullTexture.getBytes()));
        texturesList.func_74742_a((NBTBase)valueTag);
        textures.func_74782_a("textures", (NBTBase)texturesList);
        skullOwner.func_74782_a("Properties", (NBTBase)textures);
        skullTag.func_74782_a("SkullOwner", (NBTBase)skullOwner);
        skull.func_77982_d(skullTag);
        skull.func_151001_c(name);
        return skull;
    }

    public static NBTTagCompound getOrCreateTag(ItemStack is) {
        if (is.func_77942_o()) {
            return is.func_77978_p();
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        is.func_77982_d(nbtTagCompound);
        return nbtTagCompound;
    }

    public static void addLoreLine(ItemStack item, String line) {
        if (!item.func_77942_o()) {
            return;
        }
        if (!item.func_77978_p().func_74764_b("display")) {
            return;
        }
        if (!item.func_77978_p().func_74775_l("display").func_74764_b("Lore")) {
            return;
        }
        NBTTagCompound displayTag = item.func_77978_p().func_74775_l("display");
        NBTTagList lore = displayTag.func_150295_c("Lore", 8);
        lore.func_74742_a((NBTBase)new NBTTagString(line));
    }

    public static String getLoreLine(ItemStack item, String matcher) {
        if (!item.func_77942_o()) {
            return null;
        }
        if (!item.func_77978_p().func_74764_b("display")) {
            return null;
        }
        if (!item.func_77978_p().func_74775_l("display").func_74764_b("Lore")) {
            return null;
        }
        NBTTagCompound displayTag = item.func_77978_p().func_74775_l("display");
        NBTTagList lore = displayTag.func_150295_c("Lore", 8);
        for (int i = 0; i < lore.func_74745_c(); ++i) {
            String line = lore.func_150307_f(i);
            if (!line.contains(matcher)) continue;
            return line;
        }
        return null;
    }

    public static Rarity getRarity(ItemStack item) {
        if (item == null || !item.func_77942_o()) {
            return Rarity.NONE;
        }
        List<String> loreLines = ItemUtils.getLoreLines(item);
        if (loreLines.isEmpty()) {
            return Rarity.NONE;
        }
        String lastLine = loreLines.get(loreLines.size() - 1);
        lastLine = StringUtils.stripFormattingFastRarity(lastLine);
        return Rarity.fromString(lastLine);
    }

    public static List<String> getLoreLines(ItemStack item) {
        if (item == null || !item.func_77942_o()) {
            return Collections.emptyList();
        }
        NBTTagCompound displayTag = item.func_77978_p().func_74775_l("display");
        if (displayTag == null || !displayTag.func_74764_b("Lore")) {
            return Collections.emptyList();
        }
        NBTTagList lore = displayTag.func_150295_c("Lore", 8);
        ArrayList<String> loreLines = new ArrayList<String>();
        for (int i = 0; i < lore.func_74745_c(); ++i) {
            loreLines.add(lore.func_150307_f(i));
        }
        return loreLines;
    }

    public static String getLoreLine(ItemStack item, Pattern matcher) {
        List<String> lore = ItemUtils.getLoreLines(item);
        if (lore.isEmpty()) {
            return null;
        }
        return lore.stream().filter(line -> matcher.matcher((CharSequence)line).matches()).findFirst().orElse(null);
    }

    public static boolean hasSkinValue(String value, ItemStack item) {
        if (item == null) {
            return false;
        }
        if (!item.func_77942_o()) {
            return false;
        }
        if (!item.func_77978_p().func_74764_b("SkullOwner")) {
            return false;
        }
        NBTTagCompound skullOwner = item.func_77978_p().func_74775_l("SkullOwner");
        if (!skullOwner.func_74764_b("Properties")) {
            return false;
        }
        NBTTagCompound properties = skullOwner.func_74775_l("Properties");
        if (!properties.func_74764_b("textures")) {
            return false;
        }
        NBTTagList textures = properties.func_150295_c("textures", 10);
        for (int i = 0; i < textures.func_74745_c(); ++i) {
            NBTTagCompound texture = textures.func_150305_b(i);
            if (!texture.func_74764_b("Value") || !texture.func_74779_i("Value").equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSkinValue(Skins skin, ItemStack item) {
        if (item == null) {
            return false;
        }
        if (!item.func_77942_o()) {
            return false;
        }
        if (!item.func_77978_p().func_74764_b("SkullOwner")) {
            return false;
        }
        NBTTagCompound skullOwner = item.func_77978_p().func_74775_l("SkullOwner");
        if (!skullOwner.func_74764_b("Properties")) {
            return false;
        }
        NBTTagCompound properties = skullOwner.func_74775_l("Properties");
        if (!properties.func_74764_b("textures")) {
            return false;
        }
        NBTTagList textures = properties.func_150295_c("textures", 10);
        for (int i = 0; i < textures.func_74745_c(); ++i) {
            NBTTagCompound texture = textures.func_150305_b(i);
            if (!texture.func_74764_b("Value") || !texture.func_74779_i("Value").equals(skin.getHttp()) && !texture.func_74779_i("Value").equals(skin.getHttps())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSkyblockItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (!item.func_77942_o()) {
            return false;
        }
        if (!item.func_77978_p().func_74764_b("ExtraAttributes")) {
            return false;
        }
        NBTTagCompound extraAttributes = item.func_77978_p().func_74775_l("ExtraAttributes");
        return extraAttributes.func_74764_b("id");
    }

    public static boolean isMenuItem(ItemStack item) {
        return item.func_82833_r().trim().isEmpty() && Item.func_150898_a((Block)Blocks.field_150397_co) == item.func_77973_b() && item.func_77952_i() == 15;
    }
}

