/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.utils;

import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.ginafro.notenoughfakepixel.config.gui.Config;

public class Logger {
    private static final java.util.logging.Logger JUL = java.util.logging.Logger.getLogger(Logger.class.getName());
    private static long lastLogTime = 0L;
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(Logger.class.getName());
    private static volatile Boolean debugOverride = null;

    private Logger() {
    }

    public static void log(String message) {
        if (!Logger.isDebugEnabled()) {
            return;
        }
        if (!Logger.isClientChatReady()) {
            return;
        }
        try {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7f[\u00a79NEF DEBUG\u00a7f] \u00a7a" + message));
        }
        catch (Throwable ignored) {
            Logger.logConsole(message);
        }
    }

    public static void logOnlyOnce(String message) {
        if (!Logger.isClientChatReady()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastLogTime > 1000L) {
            try {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7f[\u00a79NEF DEBUG\u00a7f] \u00a7a" + message));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            lastLogTime = now;
        }
    }

    public static void logError(String message) {
        if (!Logger.isDebugEnabled()) {
            return;
        }
        if (!Logger.isClientChatReady()) {
            return;
        }
        try {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7f[\u00a79NEF DEBUG\u00a7f] \u00a7c" + String.valueOf(message)));
        }
        catch (Throwable ignored) {
            Logger.logErrorConsole(message);
        }
    }

    public static void log(Object object) {
        Logger.log(object.toString());
    }

    public static void logConsole(String message) {
        if (!Logger.isDebugEnabled()) {
            return;
        }
        Logger.safeJulLog(Level.INFO, message);
    }

    public static void logErrorConsole(String error) {
        if (!Logger.isDebugEnabled()) {
            return;
        }
        Logger.safeJulLog(Level.WARNING, error);
    }

    public static void logConsole(Object object) {
        if (!Logger.isDebugEnabled()) {
            return;
        }
        try {
            Logger.logConsole(String.valueOf(object));
        }
        catch (Throwable t) {
            Logger.safeJulLog(Level.WARNING, "Failed to log object: " + (object == null ? "null" : object.getClass().getName()));
        }
    }

    private static void safeJulLog(Level level, String msg) {
        String text = String.valueOf(msg);
        try {
            JUL.log(level, text);
        }
        catch (Throwable __) {
            if (level.intValue() >= Level.WARNING.intValue()) {
                System.err.println("[NEF][ERR] " + text);
            }
            System.out.println("[NEF] " + text);
        }
    }

    private static boolean isDebugEnabled() {
        if (debugOverride != null) {
            return debugOverride;
        }
        try {
            return Config.feature.debug.debug;
        }
        catch (Throwable __) {
            return false;
        }
    }

    private static boolean isClientChatReady() {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            return mc != null && mc.field_71439_g != null && mc.func_147114_u() != null;
        }
        catch (Throwable __) {
            return false;
        }
    }

    public static void setDebugOverride(Boolean debugOverride) {
        Logger.debugOverride = debugOverride;
    }
}

