/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class MapUtils {
    @SafeVarargs
    public static <K, V> Map<K, V> mapOf(Pair<K, V> ... entries) {
        return Arrays.stream(entries).collect(Collectors.collectingAndThen(Collectors.toMap(entry -> entry.key, entry -> entry.value), Collections::unmodifiableMap));
    }

    public static <K, V> K getKeyFromValue(Map<K, V> map, V value) {
        return map.entrySet().stream().filter(entry -> entry.getValue().equals(value)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public static class Pair<K, V> {
        final K key;
        final V value;

        public static <K, V> Pair<K, V> of(K key, V value) {
            return new Pair<K, V>(key, value);
        }

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            K this$key = this.getKey();
            K other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            V this$value = this.getValue();
            V other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Pair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            K $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            V $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "MapUtils.Pair(key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }
    }
}

