/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.utils;

import java.util.Locale;

public class NumberUtils {
    public static int parseIntSafe(String s) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    public static int parseTrailingInt(String s, int start) {
        char c;
        int n = s.length();
        int val = 0;
        int digits = 0;
        for (int i = start; i < n && (c = s.charAt(i)) >= '0' && c <= '9'; ++i) {
            val = val * 10 + (c - 48);
            if (++digits <= 6) continue;
            break;
        }
        return digits == 0 ? -1 : val;
    }

    public static double parseDoubleFlexible(String s) {
        return Double.parseDouble(s.replace(',', '.'));
    }

    public static String fmt1(double d) {
        return String.format(Locale.ROOT, "%.1f", d);
    }

    public static boolean basicallyEqual(double num1, double num2, double dist) {
        return Math.abs(num1 - num2) < dist;
    }

    public static double truncateTwoDecimalPlaces(double value) {
        return Math.floor(value * 100.0) / 100.0;
    }
}

