/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.utils;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import org.ginafro.notenoughfakepixel.events.RenderEntityModelEvent;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;

public final class OutlineUtils {
    private static final Minecraft mc = Minecraft.func_71410_x();

    private OutlineUtils() {
    }

    public static void renderBlockOutline(BlockPos pos1, BlockPos pos2, float partialTicks, Color color, float lineWidth) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity camera = mc.func_175606_aa();
        double x = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * (double)partialTicks;
        double y = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * (double)partialTicks;
        double z = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * (double)partialTicks;
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2).func_72314_b(1.0, 1.0, 1.0).func_72317_d(-x, -y, -z);
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        GL11.glLineWidth((float)lineWidth);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        OutlineUtils.drawSelectionBoundingBox(bb);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    private static void drawSelectionBoundingBox(AxisAlignedBB box) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    private static void outlineEntity(ModelBase model, EntityLivingBase livingBase, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch, float scaleFactor, Color color, float thickness, boolean shouldCancelHurt) {
        boolean fancyGraphics = OutlineUtils.mc.field_71474_y.field_74347_j;
        float gamma = OutlineUtils.mc.field_71474_y.field_74333_Y;
        OutlineUtils.mc.field_71474_y.field_74347_j = false;
        OutlineUtils.mc.field_71474_y.field_74333_Y = Float.MAX_VALUE;
        if (shouldCancelHurt && livingBase != null) {
            livingBase.field_70737_aN = 0;
        }
        EntityLivingBase entity = livingBase instanceof Entity ? livingBase : null;
        GlStateManager.func_179117_G();
        OutlineUtils.setColor(color);
        OutlineUtils.renderOne(thickness);
        model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch, scaleFactor);
        OutlineUtils.setColor(color);
        OutlineUtils.renderTwo();
        model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch, scaleFactor);
        OutlineUtils.setColor(color);
        OutlineUtils.renderThree();
        model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch, scaleFactor);
        OutlineUtils.setColor(color);
        OutlineUtils.renderFour(color);
        model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch, scaleFactor);
        OutlineUtils.setColor(color);
        OutlineUtils.renderFive();
        OutlineUtils.setColor(Color.WHITE);
        OutlineUtils.mc.field_71474_y.field_74347_j = fancyGraphics;
        OutlineUtils.mc.field_71474_y.field_74333_Y = gamma;
    }

    public static void outlineEntity(RenderEntityModelEvent event, float thickness, Color color, boolean shouldCancelHurt) {
        OutlineUtils.outlineEntity(event.getModel(), event.getEntity(), event.getLimbSwing(), event.getLimbSwingAmount(), event.getAgeInTicks(), event.getHeadYaw(), event.getHeadPitch(), event.getScaleFactor(), color, thickness, shouldCancelHurt);
    }

    private static void renderOne(float lineWidth) {
        OutlineUtils.checkSetupFBO();
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glLineWidth((float)lineWidth);
        GL11.glEnable((int)2848);
        GL11.glEnable((int)2960);
        GL11.glClear((int)1024);
        GL11.glClearStencil((int)15);
        GL11.glStencilFunc((int)512, (int)1, (int)15);
        GL11.glStencilOp((int)7681, (int)7681, (int)7681);
        GL11.glPolygonMode((int)1032, (int)6913);
    }

    private static void renderTwo() {
        GL11.glStencilFunc((int)512, (int)0, (int)15);
        GL11.glStencilOp((int)7681, (int)7681, (int)7681);
        GL11.glPolygonMode((int)1032, (int)6914);
    }

    private static void renderThree() {
        GL11.glStencilFunc((int)514, (int)1, (int)15);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glPolygonMode((int)1032, (int)6913);
    }

    private static void renderFour(Color color) {
        OutlineUtils.setColor(color);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)10754);
        GL11.glPolygonOffset((float)1.0f, (float)-2000000.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    private static void renderFive() {
        GL11.glPolygonOffset((float)1.0f, (float)2000000.0f);
        GL11.glDisable((int)10754);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2960);
        GL11.glDisable((int)2848);
        GL11.glHint((int)3154, (int)4352);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glPopAttrib();
    }

    private static void setColor(Color color) {
        GL11.glColor4d((double)((double)color.getRed() / 255.0), (double)((double)color.getGreen() / 255.0), (double)((double)color.getBlue() / 255.0), (double)((double)color.getAlpha() / 255.0));
    }

    private static void checkSetupFBO() {
        Framebuffer fbo = mc.func_147110_a();
        if (fbo != null && fbo.field_147624_h > -1) {
            OutlineUtils.setupFBO(fbo);
            fbo.field_147624_h = -1;
        }
    }

    private static void setupFBO(Framebuffer fbo) {
        EXTFramebufferObject.glDeleteRenderbuffersEXT((int)fbo.field_147624_h);
        int stencilDepthBufferId = EXTFramebufferObject.glGenRenderbuffersEXT();
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)stencilDepthBufferId);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)34041, (int)OutlineUtils.mc.field_71443_c, (int)OutlineUtils.mc.field_71440_d);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36128, (int)36161, (int)stencilDepthBufferId);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)stencilDepthBufferId);
    }
}

