/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.utils;

import java.awt.Color;
import net.minecraft.block.BlockLever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.variables.MobDisplayTypes;
import org.ginafro.notenoughfakepixel.variables.Resources;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class RenderUtils {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final ResourceLocation beaconBeam = Resources.BEACON.getResource();

    public static void drawOnSlot(int size, int xSlotPos, int ySlotPos, int colour) {
        RenderUtils.drawOnSlot(size, xSlotPos, ySlotPos, colour, -1);
    }

    public static void drawOnSlot(int size, int xSlotPos, int ySlotPos, int colour, int number) {
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        int guiLeft = (scaledResolution.func_78326_a() - 176) / 2;
        int guiTop = (scaledResolution.func_78328_b() - 222) / 2;
        int x = guiLeft + xSlotPos;
        int y = guiTop + ySlotPos;
        if (size != 90) {
            y += (6 - (size - 36) / 9) * 9;
        }
        GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
        Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)colour);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
        if (number != -1) {
            String text = String.valueOf(number);
            int textWidth = RenderUtils.mc.field_71466_p.func_78256_a(text);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GL11.glDisable((int)2896);
            GlStateManager.func_179097_i();
            RenderUtils.mc.field_71466_p.func_175063_a(text, (float)(x + 8 - textWidth / 2), (float)(y + 8 - 4), 0xFFFFFF);
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GL11.glEnable((int)2896);
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    public static void renderBeaconBeam(BlockPos block, int rgb, float alphaMult, float partialTicks) {
        double z;
        double y;
        double x;
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)partialTicks;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)partialTicks;
        double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)partialTicks;
        double distSq = (x = (double)block.func_177958_n() - viewerX) * x + (y = (double)block.func_177956_o() - viewerY) * y + (z = (double)block.func_177952_p() - viewerZ) * z;
        RenderUtils.renderBeaconBeam(x, y, z, rgb, 1.0f, partialTicks, distSq > 100.0);
    }

    public static void renderBeaconBeam(double x, double y, double z, int rgb, float alphaMult, float partialTicks, Boolean disableDepth) {
        int height = 300;
        int bottomOffset = 0;
        int topOffset = bottomOffset + height;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        if (disableDepth.booleanValue()) {
            GlStateManager.func_179097_i();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(beaconBeam);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2896);
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        double time = (double)Minecraft.func_71410_x().field_71441_e.func_82737_E() + (double)partialTicks;
        double d1 = MathHelper.func_181162_h((double)(-time * 0.2 - (double)MathHelper.func_76128_c((double)(-time * 0.1))));
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        double d2 = time * 0.025 * -1.5;
        double d4 = 0.5 + Math.cos(d2 + 2.356194490192345) * 0.2;
        double d5 = 0.5 + Math.sin(d2 + 2.356194490192345) * 0.2;
        double d6 = 0.5 + Math.cos(d2 + 0.7853981633974483) * 0.2;
        double d7 = 0.5 + Math.sin(d2 + 0.7853981633974483) * 0.2;
        double d8 = 0.5 + Math.cos(d2 + 3.9269908169872414) * 0.2;
        double d9 = 0.5 + Math.sin(d2 + 3.9269908169872414) * 0.2;
        double d10 = 0.5 + Math.cos(d2 + 5.497787143782138) * 0.2;
        double d11 = 0.5 + Math.sin(d2 + 5.497787143782138) * 0.2;
        double d14 = -1.0 + d1;
        double d15 = (double)height * 2.5 + d14;
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        worldrenderer.func_181662_b(x + d4, y + (double)topOffset, z + d5).func_181673_a(1.0, d15).func_181666_a(r, g, b, alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d4, y + (double)bottomOffset, z + d5).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)bottomOffset, z + d7).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)topOffset, z + d7).func_181673_a(0.0, d15).func_181666_a(r, g, b, alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)topOffset, z + d11).func_181673_a(1.0, d15).func_181666_a(r, g, b, alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)bottomOffset, z + d11).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)bottomOffset, z + d9).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)topOffset, z + d9).func_181673_a(0.0, d15).func_181666_a(r, g, b, alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)topOffset, z + d7).func_181673_a(1.0, d15).func_181666_a(r, g, b, alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)bottomOffset, z + d7).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)bottomOffset, z + d11).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)topOffset, z + d11).func_181673_a(0.0, d15).func_181666_a(r, g, b, alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)topOffset, z + d9).func_181673_a(1.0, d15).func_181666_a(r, g, b, alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)bottomOffset, z + d9).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d4, y + (double)bottomOffset, z + d5).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d4, y + (double)topOffset, z + d5).func_181673_a(0.0, d15).func_181666_a(r, g, b, alphaMult).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179129_p();
        double d12 = -1.0 + d1;
        double d13 = (double)height + d12;
        float alphaConst = 0.25f;
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.2).func_181673_a(1.0, d13).func_181666_a(r, g, b, alphaConst * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.2).func_181673_a(1.0, d12).func_181666_a(r, g, b, alphaConst).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.2).func_181673_a(0.0, d12).func_181666_a(r, g, b, alphaConst).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.2).func_181673_a(0.0, d13).func_181666_a(r, g, b, alphaConst * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.8).func_181673_a(1.0, d13).func_181666_a(r, g, b, alphaConst * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.8).func_181673_a(1.0, d12).func_181666_a(r, g, b, alphaConst).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.8).func_181673_a(0.0, d12).func_181666_a(r, g, b, alphaConst).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.8).func_181673_a(0.0, d13).func_181666_a(r, g, b, alphaConst * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.2).func_181673_a(1.0, d13).func_181666_a(r, g, b, alphaConst * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.2).func_181673_a(1.0, d12).func_181666_a(r, g, b, alphaConst).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.8).func_181673_a(0.0, d12).func_181666_a(r, g, b, alphaConst).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.8).func_181673_a(0.0, d13).func_181666_a(r, g, b, alphaConst * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.8).func_181673_a(1.0, d13).func_181666_a(r, g, b, alphaConst * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.8).func_181673_a(1.0, d12).func_181666_a(r, g, b, alphaConst).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.2).func_181673_a(0.0, d12).func_181666_a(r, g, b, alphaConst).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.2).func_181673_a(0.0, d13).func_181666_a(r, g, b, alphaConst * alphaMult).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        if (disableDepth.booleanValue()) {
            GlStateManager.func_179126_j();
        }
        GL11.glEnable((int)2896);
    }

    public static void renderBoxAtCoords(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float partialTicks, Color color, boolean disableDepth) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity player = mc.func_175606_aa();
        double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        double x1 = minX - playerX;
        double y1 = minY - playerY;
        double z1 = minZ - playerZ;
        double x2 = maxX - playerX;
        double y2 = maxY - playerY;
        double z2 = maxZ - playerZ;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179129_p();
        GL11.glDisable((int)2896);
        GlStateManager.func_179140_f();
        if (disableDepth) {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glLineWidth((float)2.0f);
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        AxisAlignedBB box = new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
        RenderUtils.drawOutlinedBox(box);
        if (disableDepth) {
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179145_e();
        GL11.glEnable((int)2896);
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    public static void drawOutlinedBox(AxisAlignedBB box) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderEntityHitbox(Entity entity, float partialTicks, Color color, MobDisplayTypes type) {
        if (type == MobDisplayTypes.ITEMBIG) {
            RenderUtils.renderItemBigHitbox(entity, partialTicks, color);
            return;
        }
        Vector3f loc = new Vector3f((float)entity.field_70165_t - 0.5f, (float)entity.field_70163_u - 0.5f, (float)entity.field_70161_v - 0.5f);
        if (type == MobDisplayTypes.BAT || type == MobDisplayTypes.ENDERMAN_BOSS || type == MobDisplayTypes.WOLF_BOSS || type == MobDisplayTypes.SPIDER_BOSS || type == MobDisplayTypes.M7ORBS || type == MobDisplayTypes.AUTOMATON) {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179129_p();
        GL11.glDisable((int)2896);
        GlStateManager.func_179140_f();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        Entity player = mc.func_175606_aa();
        double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        double x = (double)loc.x - playerX + 0.5;
        double y = (double)loc.y - playerY - 0.5;
        if (type == MobDisplayTypes.BAT) {
            y = (double)loc.y - playerY + 1.0;
        } else if (type == MobDisplayTypes.FEL) {
            y = (double)loc.y - playerY + 2.3;
        }
        double z = (double)loc.z - playerZ + 0.5;
        double y1 = y + type.getY1();
        double y2 = y + type.getY2();
        double x1 = x + type.getX1();
        double x2 = x + type.getX2();
        double z1 = z + type.getZ1();
        double z2 = z + type.getZ2();
        RenderUtils.drawHitbox(x1, x2, y1, y2, z1, z2, color, type);
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GL11.glEnable((int)2896);
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private static void renderItemBigHitbox(Entity entity, float partialTicks, Color color) {
        AxisAlignedBB bb = entity.func_174813_aQ();
        if (bb == null) {
            return;
        }
        double scale = Config.feature.dungeons.dungeonsScaleItemDrop;
        Entity player = mc.func_175606_aa();
        double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        double x1 = bb.field_72340_a - playerX;
        double x2 = bb.field_72336_d - playerX;
        double y1 = bb.field_72338_b - playerY;
        double y2 = bb.field_72337_e - playerY;
        double z1 = bb.field_72339_c - playerZ;
        double z2 = bb.field_72334_f - playerZ;
        double centerX = (x1 + x2) / 2.0;
        double centerY = (y1 + y2) / 2.0;
        double centerZ = (z1 + z2) / 2.0;
        x1 = centerX + (x1 - centerX) * scale;
        x2 = centerX + (x2 - centerX) * scale;
        y1 = centerY + (y1 - centerY) * scale;
        y2 = centerY + (y2 - centerY) * scale;
        z1 = centerZ + (z1 - centerZ) * scale;
        z2 = centerZ + (z2 - centerZ) * scale;
        double yOffset = (Config.feature.dungeons.dungeonsScaleItemDrop - 1.0f) * (entity.field_70131_O / 2.0f);
        y1 += yOffset;
        y2 += yOffset;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179129_p();
        GL11.glDisable((int)2896);
        GlStateManager.func_179140_f();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderUtils.drawHitbox(x1, x2, y1, y2, z1, z2, color, MobDisplayTypes.ITEMBIG);
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GL11.glEnable((int)2896);
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private static void drawHitbox(double x1, double x2, double y1, double y2, double z1, double z2, Color color, MobDisplayTypes type) {
        int[][] edges;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        if (type == MobDisplayTypes.GAIA) {
            GL11.glLineWidth((float)5.0f);
        } else {
            GL11.glLineWidth((float)3.0f);
        }
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int alpha = color.getAlpha();
        double[][] vertices = new double[][]{{x1, y1, z1}, {x2, y1, z1}, {x2, y2, z1}, {x1, y2, z1}, {x1, y1, z2}, {x2, y1, z2}, {x2, y2, z2}, {x1, y2, z2}};
        for (int[] edge : edges = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {4, 5}, {5, 6}, {6, 7}, {7, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}}) {
            worldRenderer.func_181662_b(vertices[edge[0]][0], vertices[edge[0]][1], vertices[edge[0]][2]).func_181669_b(red, green, blue, alpha).func_181675_d();
            worldRenderer.func_181662_b(vertices[edge[1]][0], vertices[edge[1]][1], vertices[edge[1]][2]).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public static void drawTag(String str, double[] pos, Color color, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        EntityPlayerSP player = mc.field_71439_g;
        RenderManager renderManager = mc.func_175598_ae();
        Vec3 viewerPos = RenderUtils.getInterpolatedPos((Entity)player, partialTicks);
        Vec3 tagPos = new Vec3(pos[0] - viewerPos.field_72450_a + 0.5, pos[1] - viewerPos.field_72448_b + 0.5, pos[2] - viewerPos.field_72449_c + 0.5);
        double distance = player.func_70011_f(pos[0], pos[1], pos[2]);
        float scale = Math.max(2.0f, (float)distance / 5.0f) * 0.016666668f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179137_b((double)tagPos.field_72450_a, (double)(tagPos.field_72448_b + 2.5), (double)tagPos.field_72449_c);
        GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
        RenderUtils.setupRenderStateForText();
        RenderUtils.drawTagBackground(font, str);
        font.func_78276_b(str, -font.func_78256_a(str) / 2, 0, RenderUtils.colorToInt(color));
        RenderUtils.restoreRenderState();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    private static Vec3 getInterpolatedPos(Entity entity, float partialTicks) {
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        return new Vec3(x, y, z);
    }

    private static void setupRenderStateForText() {
        GlStateManager.func_179140_f();
        GL11.glDisable((int)2896);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
    }

    private static void restoreRenderState() {
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GL11.glEnable((int)2896);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179117_G();
    }

    private static void drawTagBackground(FontRenderer font, String str) {
        int width = font.func_78256_a(str) / 2;
        Tessellator tess = Tessellator.func_178181_a();
        WorldRenderer wr = tess.func_178180_c();
        GlStateManager.func_179090_x();
        wr.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        wr.func_181662_b((double)(-width - 1), -1.0, 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
        wr.func_181662_b((double)(-width - 1), 8.0, 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
        wr.func_181662_b((double)(width + 1), 8.0, 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
        wr.func_181662_b((double)(width + 1), -1.0, 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static void draw3DLine(Vec3 pos1, Vec3 pos2, Color color, int lineWidth, boolean depth, float partialTicks) {
        RenderUtils.draw3DLine(pos1, pos2, color, lineWidth, depth, partialTicks, false, false, null);
    }

    public static void draw3DLine(Vec3 pos1, Vec3 pos2, Color color, int lineWidth, boolean depth, float partialTicks, boolean fromHead, boolean isLever, BlockLever.EnumOrientation orientation) {
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        Vec3 interp = RenderUtils.getInterpolatedPosition(viewer, partialTicks);
        Vec3 start = isLever ? RenderUtils.getLeverCenter(pos1, orientation) : pos1;
        Vec3 end = fromHead ? RenderUtils.getPlayerLookVec() : pos2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-interp.field_72450_a), (double)(-interp.field_72448_b), (double)(-interp.field_72449_c));
        RenderUtils.setupRenderState(depth, lineWidth);
        RenderUtils.renderLine(start, end, color);
        RenderUtils.cleanupRenderState(depth);
        GlStateManager.func_179137_b((double)interp.field_72450_a, (double)interp.field_72448_b, (double)interp.field_72449_c);
        GlStateManager.func_179121_F();
    }

    private static Vec3 getInterpolatedPosition(Entity entity, float partialTicks) {
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        return new Vec3(x, y, z);
    }

    private static Vec3 getLeverCenter(Vec3 pos, BlockLever.EnumOrientation orientation) {
        double x = pos.field_72450_a;
        double y = pos.field_72448_b;
        double z = pos.field_72449_c;
        switch (orientation) {
            case UP_X: 
            case UP_Z: {
                return new Vec3(x + 0.5, y + 0.1, z + 0.5);
            }
            case NORTH: {
                return new Vec3(x + 0.5, y + 0.5, z + 0.875);
            }
            case SOUTH: {
                return new Vec3(x + 0.5, y + 0.5, z + 0.125);
            }
            case WEST: {
                return new Vec3(x + 0.875, y + 0.5, z + 0.5);
            }
            case EAST: {
                return new Vec3(x + 0.125, y + 0.5, z + 0.5);
            }
        }
        return new Vec3(x + 0.5, y + 0.5, z - 1.125);
    }

    private static Vec3 getPlayerLookVec() {
        Minecraft mc = Minecraft.func_71410_x();
        float yaw = -mc.field_71439_g.field_70177_z;
        float pitch = -mc.field_71439_g.field_70125_A;
        return new Vec3(0.0, 0.0, 1.0).func_178789_a((float)Math.toRadians(pitch)).func_178785_b((float)Math.toRadians(yaw));
    }

    private static void setupRenderState(boolean depth, int lineWidth) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GL11.glDisable((int)2896);
        GlStateManager.func_179140_f();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glLineWidth((float)lineWidth);
        if (!depth) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
        }
    }

    private static void cleanupRenderState(boolean depth) {
        if (!depth) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
        }
        GlStateManager.func_179084_k();
        GL11.glEnable((int)2896);
        GlStateManager.func_179145_e();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderLine(Vec3 start, Vec3 end, Color color) {
        WorldRenderer wr = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        wr.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        wr.func_181662_b(start.field_72450_a, start.field_72448_b, start.field_72449_c).func_181675_d();
        wr.func_181662_b(end.field_72450_a, end.field_72448_b, end.field_72449_c).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void highlightBlock(BlockPos pos, Color color, boolean disableDepth, float partialTicks) {
        RenderUtils.highlightBlock(pos, color, disableDepth, false, partialTicks);
    }

    public static void highlightBlock(BlockPos pos, Color color, boolean disableDepth, boolean isButton, float partialTicks) {
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)partialTicks;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)partialTicks;
        double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)partialTicks;
        double x = (double)pos.func_177958_n() - viewerX;
        double y = (double)pos.func_177956_o() - viewerY;
        double z = (double)pos.func_177952_p() - viewerZ;
        if (disableDepth) {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GL11.glDisable((int)2896);
        double initialToAddX = 0.0;
        if (!disableDepth) {
            initialToAddX = 0.05;
        }
        if (!isButton) {
            if (disableDepth) {
                RenderUtils.drawFilledBoundingBox(new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0), 1.0f, color);
            } else {
                RenderUtils.drawFilledBoundingBox(new AxisAlignedBB(x - initialToAddX, y, z, x + 1.0 + initialToAddX, y + 1.0, z + 1.0), 1.0f, color);
            }
        } else {
            RenderUtils.drawFilledBoundingBox(new AxisAlignedBB(x, y + 0.5 - 0.13, z + 0.5 - 0.191, x - 0.13, y + 0.5 + 0.13, z + 0.5 + 0.191), 1.0f, color);
        }
        GL11.glEnable((int)2896);
        GlStateManager.func_179145_e();
        if (disableDepth) {
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179089_o();
    }

    public static void drawLeverBoundingBox(BlockPos pos, EnumFacing facing, Color color, float partialTicks) {
        AxisAlignedBB boundingBox;
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)partialTicks;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)partialTicks;
        double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)partialTicks;
        double x = (double)pos.func_177958_n() - viewerX;
        double y = (double)pos.func_177956_o() - viewerY;
        double z = (double)pos.func_177952_p() - viewerZ;
        switch (facing) {
            case NORTH: {
                boundingBox = new AxisAlignedBB(x + 0.25, y + 0.1875, z + 0.75, x + 0.75, y + 0.8125, z + 1.0);
                break;
            }
            case SOUTH: {
                boundingBox = new AxisAlignedBB(x + 0.25, y + 0.1875, z, x + 0.75, y + 0.8125, z + 0.25);
                break;
            }
            case WEST: {
                boundingBox = new AxisAlignedBB(x + 0.75, y + 0.1875, z + 0.25, x + 1.0, y + 0.8125, z + 0.75);
                break;
            }
            case EAST: {
                boundingBox = new AxisAlignedBB(x, y + 0.1875, z + 0.25, x + 0.25, y + 0.8125, z + 0.75);
                break;
            }
            default: {
                boundingBox = new AxisAlignedBB(x + 0.25, y + 0.1875, z - 1.25, x + 0.75, y + 0.8125, z - 1.0);
            }
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GL11.glDisable((int)2896);
        RenderUtils.drawFilledBoundingBox(boundingBox, 1.0f, color);
        GL11.glEnable((int)2896);
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
    }

    public static void drawFilledBoundingBox(AxisAlignedBB box, float alpha, Color color) {
        RenderUtils.setupGlStateForBox();
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = MathHelper.func_76131_a((float)((float)color.getAlpha() / 255.0f * alpha), (float)0.0f, (float)1.0f);
        Tessellator tess = Tessellator.func_178181_a();
        WorldRenderer wr = tess.func_178180_c();
        RenderUtils.drawFace(wr, tess, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72338_b, box.field_72334_f, r, g, b, a);
        RenderUtils.drawFace(wr, tess, box.field_72340_a, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f, r, g, b, a);
        RenderUtils.drawFace(wr, tess, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72339_c, r, g, b, a);
        RenderUtils.drawFace(wr, tess, box.field_72340_a, box.field_72338_b, box.field_72334_f, box.field_72336_d, box.field_72337_e, box.field_72334_f, r, g, b, a);
        RenderUtils.drawFace(wr, tess, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72340_a, box.field_72337_e, box.field_72334_f, r, g, b, a);
        RenderUtils.drawFace(wr, tess, box.field_72336_d, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f, r, g, b, a);
        RenderUtils.restoreGlState();
    }

    private static void setupGlStateForBox() {
        GlStateManager.func_179123_a();
        GlStateManager.func_179090_x();
        GL11.glDisable((int)2896);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
    }

    private static void restoreGlState() {
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GL11.glEnable((int)2896);
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179099_b();
    }

    private static void drawFace(WorldRenderer wr, Tessellator tess, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        wr.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        double minX = Math.min(x1, x2);
        double maxX = Math.max(x1, x2);
        double minY = Math.min(y1, y2);
        double maxY = Math.max(y1, y2);
        double minZ = Math.min(z1, z2);
        double maxZ = Math.max(z1, z2);
        if (minX == maxX) {
            wr.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
            wr.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
            wr.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
            wr.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        } else if (minY == maxY) {
            wr.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
            wr.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
            wr.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
            wr.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        } else if (minZ == maxZ) {
            wr.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
            wr.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
            wr.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
            wr.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        }
        tess.func_78381_a();
    }

    public static int colorToInt(Color color) {
        return color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
    }

    public static void drawFilledBoundingBoxEntity(AxisAlignedBB aabb, float alpha, Color color, float partialTicks) {
        Entity render = Minecraft.func_71410_x().func_175606_aa();
        double coordX = render.field_70142_S + (render.field_70165_t - render.field_70142_S) * (double)partialTicks;
        double coordY = render.field_70137_T + (render.field_70163_u - render.field_70137_T) * (double)partialTicks;
        double coordZ = render.field_70136_U + (render.field_70161_v - render.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-coordX), (double)(-coordY), (double)(-coordZ));
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GL11.glDisable((int)2896);
        GlStateManager.func_179140_f();
        GlStateManager.func_179118_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f * alpha));
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GL11.glEnable((int)2896);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public static void renderWaypointText(String str, BlockPos loc, float partialTicks) {
        RenderUtils.renderWaypointText(str, loc, partialTicks, true);
    }

    public static void renderWaypointText(String str, BlockPos loc, float partialTicks, boolean showDistance) {
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GL11.glDisable((int)2896);
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)partialTicks;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)partialTicks;
        double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)partialTicks;
        double x = (double)loc.func_177958_n() + 0.5 - viewerX;
        double y = (double)loc.func_177956_o() + 0.5 - viewerY - (double)viewer.func_70047_e();
        double z = (double)loc.func_177952_p() + 0.5 - viewerZ;
        double distSq = x * x + y * y + z * z;
        double dist = Math.sqrt(distSq);
        if (distSq > 144.0) {
            x *= 12.0 / dist;
            y *= 12.0 / dist;
            z *= 12.0 / dist;
        }
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179109_b((float)0.0f, (float)viewer.func_70047_e(), (float)0.0f);
        float scale = 2.0f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        RenderUtils.drawNametag(str);
        GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78735_i, (float)0.0f, (float)1.0f, (float)0.0f);
        if (showDistance) {
            RenderUtils.drawNametag(EnumChatFormatting.YELLOW.toString() + Math.round(dist) + "m");
        }
        GL11.glEnable((int)2896);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public static void drawNametag(String str) {
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GlStateManager.func_179094_E();
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179140_f();
        GL11.glDisable((int)2896);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        int i = 0;
        int j = fontrenderer.func_78256_a(str) / 2;
        GlStateManager.func_179090_x();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b((double)(-j - 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b((double)(-j - 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b((double)(j + 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b((double)(j + 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        fontrenderer.func_78276_b(str, -fontrenderer.func_78256_a(str) / 2, i, 0x20FFFFFF);
        GlStateManager.func_179132_a((boolean)true);
        fontrenderer.func_78276_b(str, -fontrenderer.func_78256_a(str) / 2, i, -1);
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GL11.glEnable((int)2896);
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void drawOutlinedBoundingBox(AxisAlignedBB aabb, Color color, float width, float partialTicks) {
        Entity render = Minecraft.func_71410_x().func_175606_aa();
        double realX = render.field_70142_S + (render.field_70165_t - render.field_70142_S) * (double)partialTicks;
        double realY = render.field_70137_T + (render.field_70163_u - render.field_70137_T) * (double)partialTicks;
        double realZ = render.field_70136_U + (render.field_70161_v - render.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-realX), (double)(-realY), (double)(-realZ));
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GL11.glDisable((int)2896);
        GlStateManager.func_179140_f();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glLineWidth((float)width);
        RenderGlobal.func_181563_a((AxisAlignedBB)aabb, (int)color.getRed(), (int)color.getGreen(), (int)color.getBlue(), (int)color.getAlpha());
        GlStateManager.func_179137_b((double)realX, (double)realY, (double)realZ);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GL11.glEnable((int)2896);
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static Vector3f getInterpolatedPlayerPosition(float partialTicks) {
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        Vector3f lastPos = new Vector3f((float)viewer.field_70142_S, (float)viewer.field_70137_T, (float)viewer.field_70136_U);
        Vector3f currentPos = new Vector3f((float)viewer.field_70165_t, (float)viewer.field_70163_u, (float)viewer.field_70161_v);
        Vector3f movement = Vector3f.sub((Vector3f)currentPos, (Vector3f)lastPos, (Vector3f)currentPos);
        movement.scale(partialTicks);
        return Vector3f.add((Vector3f)lastPos, (Vector3f)movement, (Vector3f)lastPos);
    }

    public static void renderBlockBox(BlockPos pos, Color c, float partialTicks) {
        RenderUtils.renderBlockBox(pos, c, partialTicks, false);
    }

    public static void renderBlockBox(BlockPos pos, Color c, float partialTicks, boolean disableDepth) {
        Vector3f interpolatedPlayerPosition = RenderUtils.getInterpolatedPlayerPosition(partialTicks);
        RenderUtils.renderBoundingBoxInViewSpace((float)pos.func_177958_n() - interpolatedPlayerPosition.x, (float)pos.func_177956_o() - interpolatedPlayerPosition.y, (float)pos.func_177952_p() - interpolatedPlayerPosition.z, c, disableDepth);
    }

    private static void renderBoundingBoxInViewSpace(double x, double y, double z, Color c, boolean disableDepth) {
        AxisAlignedBB bb = new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0);
        if (disableDepth) {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        RenderUtils.drawFilledBoundingBox(bb, c, 1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        if (disableDepth) {
            GlStateManager.func_179126_j();
        }
    }

    public static void drawFilledBoundingBox(AxisAlignedBB p_181561_0_, Color c, float alpha) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)((float)c.getAlpha() / 255.0f * alpha));
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f * 0.8f), (float)((float)c.getGreen() / 255.0f * 0.8f), (float)((float)c.getBlue() / 255.0f * 0.8f), (float)((float)c.getAlpha() / 255.0f * alpha));
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f * 0.9f), (float)((float)c.getGreen() / 255.0f * 0.9f), (float)((float)c.getBlue() / 255.0f * 0.9f), (float)((float)c.getAlpha() / 255.0f * alpha));
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderBoundingBox(BlockPos pos, int rgb, float partialTicks) {
        RenderUtils.renderBoundingBox(pos, rgb, partialTicks, true);
    }

    public static void renderBoundingBox(BlockPos pos, int rgb, float partialTicks, boolean ignoreDepth) {
        double playerX = Minecraft.func_71410_x().field_71439_g.field_70169_q + (Minecraft.func_71410_x().field_71439_g.field_70165_t - Minecraft.func_71410_x().field_71439_g.field_70169_q) * (double)partialTicks;
        double playerY = Minecraft.func_71410_x().field_71439_g.field_70167_r + (Minecraft.func_71410_x().field_71439_g.field_70163_u - Minecraft.func_71410_x().field_71439_g.field_70167_r) * (double)partialTicks;
        double playerZ = Minecraft.func_71410_x().field_71439_g.field_70166_s + (Minecraft.func_71410_x().field_71439_g.field_70161_v - Minecraft.func_71410_x().field_71439_g.field_70166_s) * (double)partialTicks;
        double x = (double)pos.func_177958_n() - playerX;
        double y = (double)pos.func_177956_o() - playerY;
        double z = (double)pos.func_177952_p() - playerZ;
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        if (ignoreDepth) {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179147_l();
        GL11.glDisable((int)2896);
        GlStateManager.func_179140_f();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glLineWidth((float)2.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        double minX = x;
        double maxX = x + 1.0;
        double minY = y;
        double maxY = y + 1.0;
        double minZ = z;
        double maxZ = z + 1.0;
        worldRenderer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        if (ignoreDepth) {
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GL11.glEnable((int)2896);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }
}

