/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jline.internal.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.DragonCloseAlert;
import org.ginafro.notenoughfakepixel.features.skyblock.overlays.stats.StatBars;
import org.ginafro.notenoughfakepixel.serverdata.SkyblockData;
import org.ginafro.notenoughfakepixel.utils.Logger;
import org.ginafro.notenoughfakepixel.utils.NumberUtils;
import org.ginafro.notenoughfakepixel.utils.StringUtils;
import org.ginafro.notenoughfakepixel.variables.Area;
import org.ginafro.notenoughfakepixel.variables.DungeonFloor;
import org.ginafro.notenoughfakepixel.variables.Gamemode;
import org.ginafro.notenoughfakepixel.variables.Slayer;

@RegisterEvents
public class ScoreboardUtils {
    public static Area currentArea = Area.NONE;
    public static Gamemode currentGamemode = Gamemode.LOBBY;
    public static DungeonFloor currentFloor = DungeonFloor.NONE;
    public static int clearedPercentage = -1;
    private int lastBoardHash = 0;
    public static Slayer currentSlayer = Slayer.NONE;
    public static boolean isSlayerActive = false;
    public static int heat = 0;
    private static Pattern floorPattern = Pattern.compile(" \u00a77\u23e3 \u00a7cThe Catacombs \u00a77\\(<?floor>.{2}\\)");
    private static final int TICK_INTERVAL = 20;
    private int tickCounter = 0;
    private static int HUB_CACHE_VAL = Integer.MIN_VALUE;
    private static long HUB_CACHE_TIME = 0L;

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        String serverIP;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.tickCounter = (this.tickCounter + 1) % 20;
        if (this.tickCounter != 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.func_71356_B()) {
            return;
        }
        ServerData sd = mc.func_147104_D();
        if (sd == null) {
            return;
        }
        String string = serverIP = sd.field_78845_b == null ? "" : sd.field_78845_b;
        if (!Config.feature.debug.enableOutOfFakepixel && !serverIP.contains("fakepixel")) {
            return;
        }
        if (mc.field_71441_e == null) {
            return;
        }
        Scoreboard scoreboard = mc.field_71441_e.func_96441_U();
        if (scoreboard == null) {
            return;
        }
        ScoreObjective objective = scoreboard.func_96539_a(1);
        if (objective != null) {
            String objNameClear = net.minecraft.util.StringUtils.func_76338_a((String)objective.func_96678_d());
            currentGamemode = Gamemode.getGamemode(ScoreboardUtils.cleanSB(objective.func_96678_d()));
            ArrayList<Score> scores = new ArrayList<Score>(scoreboard.func_96534_i(objective));
            for (int i = scores.size() - 1; i >= 0; --i) {
                Score sc = (Score)scores.get(i);
                if (sc == null) {
                    scores.remove(i);
                    continue;
                }
                String pn = sc.func_96653_e();
                if (pn != null && !pn.startsWith("#")) continue;
                scores.remove(i);
            }
            int boardHash = StringUtils.hashBoard(objNameClear, scores);
            if (boardHash != this.lastBoardHash) {
                this.lastBoardHash = boardHash;
                int n = scores.size();
                for (int i = 0; i < n; ++i) {
                    String num;
                    String clean;
                    String raw = ((Score)scores.get(i)).func_96653_e();
                    if (raw == null || raw.isEmpty() || (clean = net.minecraft.util.StringUtils.func_76338_a((String)raw).trim()).isEmpty()) continue;
                    if (raw.startsWith(" \u00a77\u23e3 \u00a7cThe Catacombs \u00a77")) {
                        int open = raw.indexOf(40);
                        int close = raw.indexOf(41, open + 1);
                        if (open >= 0 && close > open) {
                            String string2 = raw.substring(open + 1, close);
                            currentFloor = DungeonFloor.getFloor(string2);
                        }
                    }
                    if (StringUtils.startsWithFast(clean, "Dungeon Cleared: ") && (clearedPercentage = NumberUtils.parseIntSafe(StringUtils.removeChars(num = StringUtils.sliceAfter(clean, "Dungeon Cleared: "), "%"))) < 0) {
                        clearedPercentage = -1;
                        Logger.log("Failed to parse cleared percentage from scoreboard: " + clean);
                    }
                    if (StringUtils.startsWithFast(clean, "Heat:") && (heat = NumberUtils.parseIntSafe(StringUtils.removeChars(num = StringUtils.sliceAfter(clean, "Heat:"), "\u2668 "))) < 0) {
                        heat = 0;
                        Log.warn((Object[])new Object[]{"Failed to parse heat from scoreboard: " + clean});
                    }
                    List<String> seasons = Arrays.asList("Spring", "Summer", "Autumn", "Winter");
                    for (String string3 : seasons) {
                        if (!clean.contains(string3)) continue;
                        SkyblockData.setSeason(SkyblockData.Season.valueOf(string3.toUpperCase()));
                        break;
                    }
                    if (clean.contains("\u2600") || clean.contains("\u263d")) {
                        String timeStr = clean.split(" ")[0];
                        String[] stringArray = timeStr.split(":");
                        boolean am = clean.contains("am");
                        if (stringArray.length == 2) {
                            try {
                                SkyblockData.setSbHour(Integer.parseInt(stringArray[0]));
                                SkyblockData.setSbMinute(Integer.parseInt(stringArray[1].replaceAll("am|pm", "")));
                                SkyblockData.setAm(am);
                            }
                            catch (NumberFormatException ex) {
                                SkyblockData.setSbHour(0);
                                SkyblockData.setSbMinute(0);
                                SkyblockData.setAm(true);
                                Logger.log("Failed to parse time from scoreboard: " + clean);
                            }
                        }
                    }
                    if (StringUtils.startsWithFast(clean, "Voidgloom Seraph")) {
                        currentSlayer = Slayer.VOIDGLOOM;
                    } else if (StringUtils.startsWithFast(clean, "Inferno Demonlord")) {
                        currentSlayer = Slayer.INFERNO;
                    } else if (StringUtils.startsWithFast(clean, "Sven Packmaster")) {
                        currentSlayer = Slayer.SVEN;
                    } else if (StringUtils.startsWithFast(clean, "Revenant Horror")) {
                        currentSlayer = Slayer.REVENANT;
                    } else if (StringUtils.startsWithFast(clean, "Tarantula Broodfather")) {
                        currentSlayer = Slayer.TARANTULA;
                    }
                    if (clean.indexOf("Slay the boss!") >= 0) {
                        isSlayerActive = true;
                    }
                    if (clean.indexOf(") Kills") >= 0 || clean.indexOf("Quest Failed") >= 0 || clean.indexOf("Boss slain!") >= 0) {
                        isSlayerActive = false;
                    }
                    for (Map.Entry entry : DragonCloseAlert.DRAGON_COLORS.entrySet()) {
                        Color color;
                        List<EntityDragon> group;
                        String dragonName = (String)entry.getKey();
                        if (dragonName == null || dragonName.isEmpty() || !raw.contains(dragonName) || (group = DragonCloseAlert.INSTANCE.getDragonsByColor(color = (Color)entry.getValue())) == null) continue;
                        for (EntityDragon dragon : group) {
                            DragonCloseAlert.INSTANCE.registerDragon(dragon, raw);
                        }
                    }
                }
            }
        }
        if (currentGamemode == Gamemode.SKYBLOCK && mc.func_147114_u() != null) {
            Collection infos = mc.func_147114_u().func_175106_d();
            boolean gotSpeed = false;
            for (NetworkPlayerInfo npi : infos) {
                String name;
                IChatComponent disp;
                if (npi == null || (disp = npi.func_178854_k()) == null || (name = disp.func_150260_c()) == null || name.isEmpty()) continue;
                String unformattedName = net.minecraft.util.StringUtils.func_76338_a((String)name).trim();
                if (!gotSpeed) {
                    int star = unformattedName.indexOf(10022);
                    if (star >= 0) {
                        int val = NumberUtils.parseTrailingInt(unformattedName, star + 1);
                        if (val >= 0) {
                            StatBars.setSpeed(val);
                            gotSpeed = true;
                        }
                    } else {
                        int n;
                        int idx = unformattedName.indexOf("Speed: ");
                        if (idx >= 0 && (n = NumberUtils.parseTrailingInt(unformattedName, idx + 7)) >= 0) {
                            StatBars.setSpeed(n);
                            gotSpeed = true;
                        }
                    }
                }
                if (!gotSpeed) continue;
                break;
            }
        }
    }

    public static int getHubNumber() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.func_147114_u() == null) {
            return -1;
        }
        long now = Minecraft.func_71386_F();
        if (HUB_CACHE_VAL != Integer.MIN_VALUE && now - HUB_CACHE_TIME < 1000L) {
            return HUB_CACHE_VAL;
        }
        int result = -1;
        Collection map = mc.func_147114_u().func_175106_d();
        if (map == null || map.isEmpty()) {
            return -1;
        }
        for (NetworkPlayerInfo npi : map) {
            int num;
            int num2;
            int pos;
            int sv;
            String text;
            IChatComponent disp;
            if (npi == null || (disp = npi.func_178854_k()) == null || (text = disp.func_150260_c()) == null || text.isEmpty() || (sv = text.indexOf("Server: ")) < 0) continue;
            for (pos = sv + 8; pos < text.length() && text.charAt(pos) == ' '; ++pos) {
            }
            if (ScoreboardUtils.regionMatchesIgnoreCase(text, pos, "skyblock-") && (num2 = NumberUtils.parseTrailingInt(text, pos + "skyblock-".length())) >= 0) {
                result = num2;
                break;
            }
            int dash = text.indexOf(45, pos);
            if (dash < 0 || dash + 1 >= text.length() || (num = NumberUtils.parseTrailingInt(text, dash + 1)) < 0) continue;
            result = num;
            break;
        }
        HUB_CACHE_VAL = result;
        HUB_CACHE_TIME = now;
        return result;
    }

    private static boolean regionMatchesIgnoreCase(String s, int offset, String pat) {
        int n = pat.length();
        if (offset < 0 || offset + n > s.length()) {
            return false;
        }
        return s.regionMatches(true, offset, pat, 0, n);
    }

    public static String cleanSB(String scoreboard) {
        return net.minecraft.util.StringUtils.func_76338_a((String)scoreboard).chars().filter(c -> c > 20 && c < 127).mapToObj(c -> String.valueOf((char)c)).collect(Collectors.joining());
    }

    public static List<String> getScoreboardLines() {
        List filteredScores;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return Collections.emptyList();
        }
        Scoreboard scoreboard = mc.field_71441_e.func_96441_U();
        if (scoreboard == null) {
            return Collections.emptyList();
        }
        ScoreObjective objective = scoreboard.func_96539_a(1);
        if (objective == null) {
            return Collections.emptyList();
        }
        try {
            filteredScores = scoreboard.func_96534_i(objective).stream().filter(score -> score != null && score.func_96653_e() != null && !score.func_96653_e().startsWith("#")).collect(Collectors.toList());
        }
        catch (ConcurrentModificationException ex) {
            ex.printStackTrace();
            return Collections.emptyList();
        }
        int size = filteredScores.size();
        return IntStream.range(Math.max(0, size - 15), size).mapToObj(i -> {
            Score score = (Score)filteredScores.get(i);
            String playerName = score.func_96653_e();
            ScorePlayerTeam team = scoreboard.func_96509_i(playerName);
            return ScorePlayerTeam.func_96667_a((Team)team, (String)playerName);
        }).collect(Collectors.toList());
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        currentGamemode = Gamemode.LOBBY;
        currentArea = Area.NONE;
        currentFloor = DungeonFloor.NONE;
        clearedPercentage = -1;
    }

    public static Pattern getFloorPattern() {
        return floorPattern;
    }

    public static void setFloorPattern(Pattern floorPattern) {
        ScoreboardUtils.floorPattern = floorPattern;
    }
}

