/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import net.minecraft.scoreboard.Score;

public class StringUtils {
    public static boolean isNumeric(String string) {
        return string != null && !string.isEmpty() && string.chars().allMatch(Character::isDigit);
    }

    public static <T> Map<String, T> subMapWithKeysThatAreSuffixes(String prefix, NavigableMap<String, T> map) {
        return "".equals(prefix) ? map : map.subMap(prefix, true, StringUtils.createLexicographicallyNextStringOfTheSameLength(prefix), false);
    }

    public static String createLexicographicallyNextStringOfTheSameLength(String input) {
        return input.substring(0, input.length() - 1) + (char)(input.charAt(input.length() - 1) + '\u0001');
    }

    public static boolean containsSubstring(String[] keywords, String itemName) {
        return Arrays.stream(keywords).anyMatch(itemName::contains);
    }

    public static boolean startsWithFast(String s, String prefix) {
        return s.length() >= prefix.length() && s.startsWith(prefix);
    }

    public static String sliceAfter(String s, String prefix) {
        return s.length() > prefix.length() ? s.substring(prefix.length()) : "";
    }

    public static String removeChars(String s, String chars) {
        if (s.isEmpty() || chars.isEmpty()) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        block0: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            for (int j = 0; j < chars.length(); ++j) {
                if (c == chars.charAt(j)) continue block0;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static int indexOfDashDigits(String s) {
        char c;
        int idx = s.indexOf(45);
        if (idx < 0 || idx + 1 >= s.length()) {
            return -1;
        }
        boolean hasDigit = false;
        for (int i = idx + 1; i < s.length() && (c = s.charAt(i)) >= '0' && c <= '9'; ++i) {
            hasDigit = true;
        }
        return hasDigit ? idx : -1;
    }

    public static int hashBoard(String display, List<Score> scores) {
        int h = 17;
        h = 31 * h + (display == null ? 0 : display.hashCode());
        int limit = Math.min(20, scores.size());
        for (int i = 0; i < limit; ++i) {
            String pn = scores.get(i).func_96653_e();
            h = 31 * h + (pn == null ? 0 : pn.hashCode());
        }
        h = 31 * h + scores.size();
        return h;
    }

    public static String stripFormattingFastRarity(String in) {
        if (in == null) {
            return "";
        }
        int n = in.length();
        StringBuilder sb = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = in.charAt(i);
            if (c == '\u00a7' || c == '&') {
                char next;
                if (i + 1 >= n) continue;
                char code = in.charAt(++i);
                while (i + 1 < n && ((next = in.charAt(i + 1)) == 'k' || next == 'K')) {
                    ++i;
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString().toLowerCase(Locale.ROOT);
    }

    public static String stripFormattingFast(String in) {
        if (in == null) {
            return "";
        }
        int n = in.length();
        StringBuilder sb = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = in.charAt(i);
            if (c == '\u00a7' || c == '&') {
                if (i + 1 >= n) continue;
                char c2 = in.charAt(++i);
                continue;
            }
            sb.append(c);
        }
        return sb.toString().toLowerCase(Locale.ROOT);
    }

    public static String capitalizeName(String lower) {
        if (lower == null || lower.isEmpty()) {
            return lower;
        }
        char[] ch = lower.toCharArray();
        ch[0] = Character.toUpperCase(ch[0]);
        return new String(ch);
    }
}

