/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.utils;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPlayerTabOverlay;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.overlays.stats.StatBars;
import org.ginafro.notenoughfakepixel.utils.NumberUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.StringUtils;
import org.ginafro.notenoughfakepixel.variables.Area;
import org.ginafro.notenoughfakepixel.variables.Gamemode;
import org.ginafro.notenoughfakepixel.variables.Location;

@RegisterEvents
public class TablistParser {
    private static final Ordering<NetworkPlayerInfo> playerOrdering = Ordering.from((Comparator)new PlayerComparator());
    public static int mithrilPowder = 0;
    public static int gemstonePowder = 0;
    public static int secretPercentage = 0;
    public static int deaths = 0;
    public static String time = "";
    public static int crypts = 0;
    public static String currentOpenChestName = "";
    public static String lastOpenChestName = "";
    private final List<String> accountInfo = new ArrayList<String>();
    private final List<String> serverInfo = new ArrayList<String>();
    public static List<String> commissions = new ArrayList<String>();
    public static Location currentLocation = Location.NONE;
    private static final int TICK_INTERVAL = 20;
    private int tickCounter = 0;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGuiOpen(GuiOpenEvent event) {
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (event.gui == null) {
            return;
        }
        if (event.gui instanceof GuiChest) {
            GuiChest chest = (GuiChest)event.gui;
            ContainerChest container = (ContainerChest)chest.field_147002_h;
            lastOpenChestName = currentOpenChestName = container.func_85151_d().func_145748_c_().func_150260_c();
        } else {
            currentOpenChestName = "";
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        this.tickCounter = (this.tickCounter + 1) % 20;
        if (this.tickCounter != 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            return;
        }
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        this.accountInfo.clear();
        this.serverInfo.clear();
        commissions.clear();
        GuiPlayerTabOverlay tab = mc.field_71456_v.func_175181_h();
        List infos = playerOrdering.sortedCopy((Iterable)mc.field_71439_g.field_71174_a.func_175106_d());
        Section section = Section.NONE;
        boolean readingCommissions = false;
        for (NetworkPlayerInfo info : infos) {
            String raw = tab.func_175243_a(info);
            if (raw == null || raw.isEmpty()) continue;
            if (raw.contains("\u00a73\u00a7l Server Info\u00a7r")) {
                section = Section.SERVER;
                readingCommissions = false;
                continue;
            }
            if (raw.contains("\u00a76\u00a7lAccount Info\u00a7r")) {
                section = Section.ACCOUNT;
                readingCommissions = false;
                continue;
            }
            if (raw.contains("\u00a72\u00a7lPlayer Stats\u00a7r")) {
                section = Section.PLAYER;
                readingCommissions = false;
                continue;
            }
            String line = net.minecraft.util.StringUtils.func_76338_a((String)raw).trim();
            if (line.isEmpty()) {
                if (section != Section.SERVER || !readingCommissions) continue;
                readingCommissions = false;
                continue;
            }
            switch (section) {
                case SERVER: {
                    String num;
                    if (StringUtils.startsWithFast(line, "Time: ")) {
                        time = line.substring(6);
                    }
                    if (StringUtils.startsWithFast(line, "Server:")) {
                        String s = line.substring(line.indexOf("Server: ") + 8).trim();
                        int dashDigits = StringUtils.indexOfDashDigits(s);
                        if (dashDigits >= 0) {
                            s = s.substring(0, dashDigits + 1);
                        }
                        currentLocation = Location.getLocation(s);
                    }
                    if (StringUtils.startsWithFast(line, "Mithril Powder: ")) {
                        num = StringUtils.sliceAfter(line, "Mithril Powder: ");
                        mithrilPowder = NumberUtils.parseIntSafe(StringUtils.removeChars(num, ","));
                    }
                    if (StringUtils.startsWithFast(line, "Gemstone Powder: ")) {
                        num = StringUtils.sliceAfter(line, "Gemstone Powder: ");
                        gemstonePowder = NumberUtils.parseIntSafe(StringUtils.removeChars(num, ","));
                    }
                    if (StringUtils.startsWithFast(line, "Secrets Found: ")) {
                        num = StringUtils.sliceAfter(line, "Secrets Found: ");
                        secretPercentage = NumberUtils.parseIntSafe(StringUtils.removeChars(num, "%"));
                    }
                    if (readingCommissions) {
                        if (raw.contains("\u00a79\u00a7l")) {
                            readingCommissions = false;
                        } else {
                            commissions.add(line);
                        }
                    } else if (raw.contains("Commissions")) {
                        readingCommissions = true;
                    }
                    if (StringUtils.startsWithFast(line, "Dungeon: ")) {
                        ScoreboardUtils.currentGamemode = Gamemode.SKYBLOCK;
                        currentLocation = Location.DUNGEON;
                    }
                    if (StringUtils.startsWithFast(line, "Area: ")) {
                        ScoreboardUtils.currentGamemode = Gamemode.SKYBLOCK;
                        String areaName = line.replace("Area: ", "");
                        ScoreboardUtils.currentArea = Area.getArea(areaName);
                    }
                    this.serverInfo.add(line);
                    break;
                }
                case PLAYER: {
                    if (StringUtils.startsWithFast(line, "Deaths: ")) {
                        int open = line.indexOf(40);
                        int close = line.indexOf(41, open + 1);
                        if (open > 0 && close > open) {
                            deaths = NumberUtils.parseIntSafe(line.substring(open + 1, close).trim());
                        }
                    }
                    if (!StringUtils.startsWithFast(line, "Crypts: ")) break;
                    String rest = line.substring(8).trim();
                    crypts = rest.indexOf(47) >= 0 ? 0 : NumberUtils.parseIntSafe(rest);
                    break;
                }
                case ACCOUNT: {
                    if (StringUtils.startsWithFast(line, "Speed: ")) {
                        String speedString = line.substring(7).replace("\u2726", "").trim();
                        int speed = NumberUtils.parseIntSafe(speedString);
                        StatBars.setSpeed(speed);
                    }
                    this.accountInfo.add(line);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        currentLocation = Location.NONE;
    }

    private static enum Section {
        NONE,
        SERVER,
        ACCOUNT,
        PLAYER;

    }

    @SideOnly(value=Side.CLIENT)
    static class PlayerComparator
    implements Comparator<NetworkPlayerInfo> {
        private PlayerComparator() {
        }

        @Override
        public int compare(NetworkPlayerInfo o1, NetworkPlayerInfo o2) {
            ScorePlayerTeam team1 = o1.func_178850_i();
            ScorePlayerTeam team2 = o2.func_178850_i();
            return ComparisonChain.start().compareTrueFirst(o1.func_178848_b() != WorldSettings.GameType.SPECTATOR, o2.func_178848_b() != WorldSettings.GameType.SPECTATOR).compare((Comparable)((Object)(team1 != null ? team1.func_96661_b() : "")), (Comparable)((Object)(team2 != null ? team2.func_96661_b() : ""))).compare((Comparable)((Object)o1.func_178845_a().getName()), (Comparable)((Object)o2.func_178845_a().getName())).result();
        }
    }
}

