/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;

@RegisterEvents
public class TitleUtils {
    private static final List<Title> titles = new ArrayList<Title>();

    public static void showTitle(String text, Color color, int durationMillis) {
        TitleUtils.showTitleInternal(text, color, durationMillis);
    }

    public static void showTitle(String text, Color color) {
        TitleUtils.showTitleInternal(text, color, 1000);
    }

    public static void showTitle(String text) {
        TitleUtils.showTitleInternal(text, null, 1000);
    }

    public static void showTitle(String text, int durationMillis) {
        TitleUtils.showTitleInternal(text, null, durationMillis);
    }

    private static void showTitleInternal(String text, Color color, int durationMillis) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            long endTime = System.currentTimeMillis() + (long)durationMillis;
            titles.add(new Title(text, color, endTime));
        });
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Iterator<Title> iterator = titles.iterator();
        while (iterator.hasNext()) {
            Title title = iterator.next();
            if (currentTime > title.endTime) {
                iterator.remove();
                continue;
            }
            this.renderTitle(title, event);
        }
    }

    private void renderTitle(Title title, RenderGameOverlayEvent.Post event) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        String displayText = title.color == null ? title.text : StringUtils.func_76338_a((String)title.text);
        int renderColor = title.color == null ? 0xFFFFFF : title.color.getRGB() & 0xFFFFFF;
        int screenWidth = event.resolution.func_78326_a();
        int screenHeight = event.resolution.func_78328_b();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)4.0f);
        int textWidth = fr.func_78256_a(displayText);
        int x = screenWidth / 8 - textWidth / 2;
        int y = screenHeight / 8 - 10;
        fr.func_175063_a(displayText, (float)x, (float)y, renderColor);
        GlStateManager.func_179121_F();
    }

    private static class Title {
        String text;
        Color color;
        long endTime;

        Title(String text, Color color, long endTime) {
            this.text = text;
            this.color = color;
            this.endTime = endTime;
        }
    }
}

