/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.utils;

import java.util.List;
import net.minecraft.util.BlockPos;

public class Waypoint {
    private final String type;
    private final int[] coordinates;
    private boolean hidden = false;

    public Waypoint(String type, int[] coordinates) {
        this.type = type;
        this.coordinates = coordinates;
    }

    public static Waypoint getClosestWaypoint(List<Waypoint> waypoints, int[] coords) {
        if (waypoints.isEmpty()) {
            return null;
        }
        Waypoint closestWaypoint = null;
        double shortestDistance = Double.MAX_VALUE;
        for (Waypoint waypoint : waypoints) {
            double distance = Waypoint.distance(coords, waypoint.getCoordinates());
            if (!(distance < shortestDistance)) continue;
            shortestDistance = distance;
            closestWaypoint = waypoint;
        }
        return closestWaypoint;
    }

    public static double distance(int[] coords1, int[] coords2) {
        return Math.sqrt(Math.pow(coords1[0] - coords2[0], 2.0) + Math.pow(coords1[1] - coords2[1], 2.0) + Math.pow(coords1[2] - coords2[2], 2.0));
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.coordinates[0], this.coordinates[1], this.coordinates[2]);
    }

    public String toString() {
        return String.format("Waypoint{type='%s', coordinates=(%d, %d, %d)}", this.type, this.coordinates[0], this.coordinates[1], this.coordinates[2]);
    }

    public String getType() {
        return this.type;
    }

    public int[] getCoordinates() {
        return this.coordinates;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

