/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.variables;

import java.util.Arrays;
import net.minecraft.util.StringUtils;

public enum Location {
    DWARVEN("sbm-", "sbm_sandbox-", "sbm_test-"),
    HUB("skyblock-", "skyblock_sandbox-", "skyblocktest-"),
    PRIVATE_HUB("skyblock_private-", "none", "none"),
    ADMIN_HUB("skyblock_admin-", "skyblock_admin_sandbox-", "skyblock_admin_test-"),
    DUNGEON_HUB("sbdh-", "sbdh_sandbox-", "sbdh_test-"),
    BARN("sbfarms-", "sbfarms_sandbox-", "sbfarms_test"),
    PARK("sbpark-", "sbpark_sandbox-", "sbpark_test-"),
    GOLD_MINE("sbmines-", "sbmines_sandbox-", "sbmines_test-"),
    PRIVATE_ISLAND("sbi-", "sbi_sandbox-", "sbi_test-"),
    JERRY("sbj-", "sbj_sandbox-", "sbj_test-"),
    SPIDERS_DEN("sbspiders-", "sbspiders_sandbox-", "sbspiders_test-"),
    THE_END("sbend-", "sbend_sandbox-", "sbend_test-"),
    CRIMSON_ISLE("sbcris-", "sbcris_sandbox-", "sbcris_test-"),
    DUNGEON("sbdungeon-", "sbdungeon_sandbox-", "sbdungeon_test-"),
    CRYSTAL_HOLLOWS("sbch-", "sbch_sandbox-", "sbtest_alpha-"),
    NONE("", "", "");

    private final String main;
    private final String sandbox;
    private final String alpha;

    public static Location getLocation(String s) {
        String unformatted = StringUtils.func_76338_a((String)s);
        return Arrays.stream(Location.values()).filter(l -> l.getMain().equals(unformatted) || l.getSandbox().equals(unformatted) || l.getAlpha().equals(unformatted)).findFirst().orElse(NONE);
    }

    public boolean isDungeon() {
        return this == DUNGEON;
    }

    public boolean isHub() {
        return this == HUB || this == PRIVATE_HUB || this == ADMIN_HUB;
    }

    public boolean isCrimson() {
        return this == CRIMSON_ISLE;
    }

    public boolean isEnd() {
        return this == THE_END;
    }

    public String getMain() {
        return this.main;
    }

    public String getSandbox() {
        return this.sandbox;
    }

    public String getAlpha() {
        return this.alpha;
    }

    private Location(String main, String sandbox, String alpha) {
        this.main = main;
        this.sandbox = sandbox;
        this.alpha = alpha;
    }
}

