/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.variables;

import java.util.Locale;

public enum Rarity {
    NONE("None"),
    COMMON("Common"),
    UNCOMMON("Uncommon"),
    RARE("Rare"),
    EPIC("Epic"),
    LEGENDARY("Legendary"),
    MYTHIC("Mythic"),
    DIVINE("Divine");

    public final String rarity;

    private Rarity(String rarity) {
        this.rarity = rarity;
    }

    public static Rarity fromString(String text) {
        if (text == null) {
            return NONE;
        }
        String clean = text.trim().toUpperCase(Locale.ROOT);
        for (Rarity r : Rarity.values()) {
            if (!clean.startsWith(r.rarity.toUpperCase(Locale.ROOT))) continue;
            return r;
        }
        return NONE;
    }

    public static String getColor(Rarity rarity) {
        String color = "\u00a77";
        switch (rarity) {
            case COMMON: {
                color = "\u00a7f";
                break;
            }
            case UNCOMMON: {
                color = "\u00a7a";
                break;
            }
            case RARE: {
                color = "\u00a79";
                break;
            }
            case EPIC: {
                color = "\u00a75";
                break;
            }
            case LEGENDARY: {
                color = "\u00a76";
                break;
            }
            case MYTHIC: {
                color = "\u00a7d";
                break;
            }
            case DIVINE: {
                color = "\u00a7b";
                break;
            }
            default: {
                color = "\u00a77";
            }
        }
        return color;
    }
}

