/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.pushdozer.PushdozerMod;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class PushdozerConfig {
    private static final String CONFIG_FILE_NAME = "pushdozer_config.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
    public static final int MAX_OPERATION_DISTANCE = 99;
    @Expose
    private WorkMode workMode = WorkMode.EXCAVATE;
    @Expose
    private DisplayMode displayMode = DisplayMode.WIREFRAME;
    @Expose
    private int maxOperationDistance = 20;
    @Expose
    private Set<String> breakableBlockIds = new HashSet<String>();
    @Expose
    private List<String> ignoredBlockIds = new ArrayList<String>(List.of());
    @Expose(serialize=false, deserialize=false)
    private Set<class_2248> ignoredBlocks = new HashSet<class_2248>();
    @Expose(serialize=false, deserialize=false)
    private boolean ignoredBlocksCacheDirty = true;
    @Expose
    private String shape = "Box";
    @Expose
    private GeometryType geometryType = GeometryType.BOX;
    @Expose
    private int radius = 5;
    @Expose
    private int length = 5;
    @Expose
    private int width = 5;
    @Expose
    private int height = 5;
    @Expose
    private int sphereRadius = 5;
    @Expose
    private int cylinderRadius = 5;
    @Expose
    private int coneRadius = 5;
    @Expose
    private int octahedronRadius = 5;
    @Expose
    private int tetrahedronEdgeLength = 5;
    @Expose
    private int triangularPrismSideLength = 5;
    @Expose
    private int boxHeight = 5;
    @Expose
    private int cylinderHeight = 5;
    @Expose
    private int coneHeight = 5;
    @Expose
    private int sphereHeight = 5;
    @Expose
    private int octahedronHeight = 5;
    @Expose
    private int tetrahedronHeight = 5;
    @Expose
    private int triangularPrismHeight = 5;
    @Expose
    private int ellipsoidHeight = 5;
    @Expose
    private int lockedHeight = 0;
    @Expose
    private HeightMode heightMode = HeightMode.NO_LIMIT;
    @Expose
    private boolean isLockedOnceMode = false;
    @Expose
    private PlaceMode placeMode = PlaceMode.ADAPTIVE_BIOME;
    @Expose
    private String selectedNaturalBlockId = "minecraft:stone";
    @Expose
    private float smoothStrength = 0.5f;
    @Expose
    private SmoothVariant smoothVariant = SmoothVariant.ADAPTIVE;
    @Expose
    private float roughnessStrength = 0.5f;
    @Expose
    private float smoothingIntensity = 0.5f;
    @Expose
    private long noiseSeed = System.currentTimeMillis();
    @Expose
    private boolean noiseAutoScale = true;
    @Expose
    private float noiseFrequency = 0.02f;
    @Expose
    private float noisePersistence = 0.5f;
    @Expose
    private int noiseOctaves = 4;
    @Expose
    private List<SurfaceConvertBlock> surfaceConvertBlocks = new ArrayList<SurfaceConvertBlock>(Arrays.asList(new SurfaceConvertBlock("minecraft:grass_block", 100.0f)));
    @Expose
    private PlantType plantType = PlantType.TREES;
    @Expose
    private Set<String> customPlantBlockIds = new HashSet<String>();
    @Expose
    private float plantDensity = 0.3f;
    @Expose
    private ShorelineType shorelineType = ShorelineType.ADAPTIVE;
    @Expose
    private int shorelineWidth = 3;
    @Expose
    private boolean plantVegetationEnabled = true;
    @Expose
    private float vegetationDensity = 0.1f;
    @Expose
    private Set<String> customShorelineBlocks = new HashSet<String>();
    @Expose
    private Set<String> customShorelinePlants = new HashSet<String>();
    @Expose
    private boolean shorelineHeightAboveEnabled = false;
    @Expose
    private boolean shorelineHeightBelowEnabled = false;
    @Expose
    private TreeSpecies selectedTree = TreeSpecies.BIOME_ADAPTIVE;
    @Expose
    private FlowerGroup selectedFlowerGroup = FlowerGroup.BIOME_ADAPTIVE;
    @Expose
    private boolean respectBiomes = true;
    @Expose
    private float clusterScale = 0.05f;
    private static PushdozerConfig instance = null;

    public PushdozerConfig() {
        HashSet<String> placeableBlockIds = new HashSet<String>();
        placeableBlockIds.add("minecraft:stone");
        placeableBlockIds.add("minecraft:dirt");
    }

    public WorkMode getWorkMode() {
        return this.workMode;
    }

    public void setWorkMode(WorkMode workMode) {
        this.workMode = workMode;
        this.notifyListeners();
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
        this.save();
        this.notifyListeners();
    }

    public int getMaxOperationDistance() {
        return this.maxOperationDistance;
    }

    public void setMaxOperationDistance(int distance) {
        this.maxOperationDistance = distance;
        this.notifyListeners();
    }

    public boolean isBlockBreakable(class_2248 block) {
        String blockId = class_7923.field_41175.method_10221((Object)block).toString();
        return this.breakableBlockIds.contains(blockId);
    }

    public String getShape() {
        return this.shape;
    }

    public void setShape(String shape) {
        this.shape = shape;
        this.geometryType = GeometryType.fromString(shape);
        this.notifyListeners();
    }

    public GeometryType getGeometryType() {
        return this.geometryType;
    }

    public void setGeometryType(GeometryType geometryType) {
        this.geometryType = geometryType;
        this.shape = geometryType.getShapeString();
        this.notifyListeners();
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.notifyListeners();
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
        this.notifyListeners();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.notifyListeners();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
        this.notifyListeners();
    }

    public int getBoxHeight() {
        return this.boxHeight;
    }

    public void setBoxHeight(int boxHeight) {
        this.boxHeight = boxHeight;
        this.notifyListeners();
    }

    public int getCylinderHeight() {
        return this.cylinderHeight;
    }

    public void setCylinderHeight(int cylinderHeight) {
        this.cylinderHeight = cylinderHeight;
        this.notifyListeners();
    }

    public int getConeHeight() {
        return this.coneHeight;
    }

    public void setConeHeight(int coneHeight) {
        this.coneHeight = coneHeight;
        this.notifyListeners();
    }

    public int getEllipsoidHeight() {
        return this.ellipsoidHeight;
    }

    public void setEllipsoidHeight(int ellipsoidHeight) {
        this.ellipsoidHeight = ellipsoidHeight;
        this.notifyListeners();
    }

    public int getSphereRadius() {
        return this.sphereRadius;
    }

    public void setSphereRadius(int sphereRadius) {
        this.sphereRadius = sphereRadius;
        this.notifyListeners();
    }

    public int getCylinderRadius() {
        return this.cylinderRadius;
    }

    public void setCylinderRadius(int cylinderRadius) {
        this.cylinderRadius = cylinderRadius;
        this.notifyListeners();
    }

    public int getConeRadius() {
        return this.coneRadius;
    }

    public void setConeRadius(int coneRadius) {
        this.coneRadius = coneRadius;
        this.notifyListeners();
    }

    public int getOctahedronRadius() {
        return this.octahedronRadius;
    }

    public void setOctahedronRadius(int octahedronRadius) {
        this.octahedronRadius = octahedronRadius;
        this.notifyListeners();
    }

    public int getTetrahedronEdgeLength() {
        return this.tetrahedronEdgeLength;
    }

    public void setTetrahedronEdgeLength(int tetrahedronEdgeLength) {
        this.tetrahedronEdgeLength = tetrahedronEdgeLength;
        this.notifyListeners();
    }

    public int getTriangularPrismSideLength() {
        return this.triangularPrismSideLength;
    }

    public void setTriangularPrismSideLength(int triangularPrismSideLength) {
        this.triangularPrismSideLength = triangularPrismSideLength;
        this.notifyListeners();
    }

    public int getTetrahedronHeight() {
        return this.tetrahedronHeight;
    }

    public void setTetrahedronHeight(int tetrahedronHeight) {
        this.tetrahedronHeight = tetrahedronHeight;
        this.notifyListeners();
    }

    public int getTriangularPrismHeight() {
        return this.triangularPrismHeight;
    }

    public void setTriangularPrismHeight(int triangularPrismHeight) {
        this.triangularPrismHeight = triangularPrismHeight;
        this.notifyListeners();
    }

    public int getLockedHeight() {
        return this.lockedHeight;
    }

    public void setLockedHeight(int height) {
        this.lockedHeight = height;
    }

    public HeightMode getHeightMode() {
        return this.heightMode;
    }

    public void setHeightMode(HeightMode heightMode) {
        this.heightMode = heightMode;
    }

    public boolean isLockedOnceMode() {
        return this.isLockedOnceMode;
    }

    public void setLockedOnceMode(boolean lockedOnceMode) {
        this.isLockedOnceMode = lockedOnceMode;
    }

    public PlaceMode getPlaceMode() {
        return this.placeMode;
    }

    public void setPlaceMode(PlaceMode placeMode) {
        this.placeMode = placeMode;
        this.notifyListeners();
    }

    public void setSelectedNaturalBlockId(String blockId) {
        this.selectedNaturalBlockId = blockId;
        this.notifyListeners();
    }

    public String getSelectedNaturalBlockId() {
        return this.selectedNaturalBlockId;
    }

    public class_2248 getSelectedNaturalBlock() {
        try {
            return (class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)this.selectedNaturalBlockId));
        }
        catch (Exception e) {
            return class_2246.field_10340;
        }
    }

    public float getSmoothStrength() {
        return this.smoothStrength;
    }

    public void setSmoothStrength(float smoothStrength) {
        this.smoothStrength = Math.max(0.1f, Math.min(1.0f, smoothStrength));
        this.notifyListeners();
    }

    public SmoothVariant getSmoothVariant() {
        return this.smoothVariant == null ? SmoothVariant.ADAPTIVE : this.smoothVariant;
    }

    public void setSmoothVariant(SmoothVariant variant) {
        this.smoothVariant = variant == null ? SmoothVariant.ADAPTIVE : variant;
        this.notifyListeners();
    }

    public float getRoughnessStrength() {
        return this.roughnessStrength;
    }

    public void setRoughnessStrength(float roughnessStrength) {
        this.roughnessStrength = Math.max(0.1f, Math.min(2.0f, roughnessStrength));
        this.notifyListeners();
    }

    public float getSmoothingIntensity() {
        return this.smoothingIntensity;
    }

    public void setSmoothingIntensity(float smoothingIntensity) {
        this.smoothingIntensity = Math.max(0.0f, Math.min(1.0f, smoothingIntensity));
        this.notifyListeners();
    }

    public long getNoiseSeed() {
        return this.noiseSeed;
    }

    public boolean isNoiseAutoScale() {
        return this.noiseAutoScale;
    }

    public void setNoiseAutoScale(boolean auto) {
        this.noiseAutoScale = auto;
        this.notifyListeners();
    }

    public float getNoiseFrequency() {
        return this.noiseFrequency;
    }

    public void setNoiseFrequency(float value) {
        this.noiseFrequency = Math.max(0.005f, Math.min(0.2f, value));
        this.notifyListeners();
    }

    public float getNoisePersistence() {
        return this.noisePersistence;
    }

    public void setNoisePersistence(float value) {
        this.noisePersistence = Math.max(0.05f, Math.min(0.95f, value));
        this.notifyListeners();
    }

    public int getNoiseOctaves() {
        return this.noiseOctaves;
    }

    public void setNoiseOctaves(int value) {
        this.noiseOctaves = Math.max(1, Math.min(6, value));
        this.notifyListeners();
    }

    public List<SurfaceConvertBlock> getSurfaceConvertBlocks() {
        return this.surfaceConvertBlocks;
    }

    public PlantType getPlantType() {
        return this.plantType;
    }

    public void setPlantType(PlantType plantType) {
        this.plantType = plantType;
        this.notifyListeners();
    }

    public float getPlantDensity() {
        return this.plantDensity;
    }

    public void setPlantDensity(float plantDensity) {
        this.plantDensity = Math.max(0.1f, Math.min(1.0f, plantDensity));
        this.notifyListeners();
    }

    public ShorelineType getShorelineType() {
        return this.shorelineType;
    }

    public void setShorelineType(ShorelineType shorelineType) {
        this.shorelineType = shorelineType;
        this.notifyListeners();
    }

    public int getShorelineWidth() {
        return this.shorelineWidth;
    }

    public void setShorelineWidth(int shorelineWidth) {
        this.shorelineWidth = Math.max(1, Math.min(10, shorelineWidth));
        this.notifyListeners();
    }

    public boolean isPlantVegetationEnabled() {
        return this.plantVegetationEnabled;
    }

    public void setPlantVegetationEnabled(boolean enabled) {
        this.plantVegetationEnabled = enabled;
        this.notifyListeners();
    }

    public float getVegetationDensity() {
        return this.vegetationDensity;
    }

    public void setVegetationDensity(float density) {
        this.vegetationDensity = Math.max(0.0f, Math.min(1.0f, density));
        this.notifyListeners();
    }

    public Set<String> getCustomShorelineBlocks() {
        return this.customShorelineBlocks;
    }

    public void setCustomShorelineBlocks(Set<String> blockIds) {
        this.customShorelineBlocks = blockIds;
        this.notifyListeners();
    }

    public Set<String> getCustomShorelinePlants() {
        return this.customShorelinePlants;
    }

    public void setCustomShorelinePlants(Set<String> plantIds) {
        this.customShorelinePlants = plantIds;
        this.notifyListeners();
    }

    public List<class_2248> getCustomShorelineBlockList() {
        return this.customShorelineBlocks.stream().map(class_2960::method_12829).filter(Objects::nonNull).map(arg_0 -> ((class_7922)class_7923.field_41175).method_10223(arg_0)).collect(Collectors.toList());
    }

    public List<class_2248> getCustomShorelinePlantList() {
        return this.customShorelinePlants.stream().map(class_2960::method_12829).filter(Objects::nonNull).map(arg_0 -> ((class_7922)class_7923.field_41175).method_10223(arg_0)).collect(Collectors.toList());
    }

    public boolean isShorelineHeightAboveEnabled() {
        return this.shorelineHeightAboveEnabled;
    }

    public void setShorelineHeightAboveEnabled(boolean enabled) {
        this.shorelineHeightAboveEnabled = enabled;
        if (enabled) {
            this.shorelineHeightBelowEnabled = false;
        }
        this.notifyListeners();
    }

    public boolean isShorelineHeightBelowEnabled() {
        return this.shorelineHeightBelowEnabled;
    }

    public void setShorelineHeightBelowEnabled(boolean enabled) {
        this.shorelineHeightBelowEnabled = enabled;
        if (enabled) {
            this.shorelineHeightAboveEnabled = false;
        }
        this.notifyListeners();
    }

    public TreeSpecies getSelectedTree() {
        return this.selectedTree;
    }

    public void setSelectedTree(TreeSpecies selectedTree) {
        this.selectedTree = selectedTree;
    }

    public FlowerGroup getSelectedFlowerGroup() {
        return this.selectedFlowerGroup;
    }

    public void setSelectedFlowerGroup(FlowerGroup selectedFlowerGroup) {
        this.selectedFlowerGroup = selectedFlowerGroup;
    }

    public boolean shouldRespectBiomes() {
        return this.respectBiomes;
    }

    public void setRespectBiomes(boolean respectBiomes) {
        this.respectBiomes = respectBiomes;
    }

    public float getClusterScale() {
        return this.clusterScale;
    }

    public void setClusterScale(float clusterScale) {
        this.clusterScale = clusterScale;
    }

    public List<class_2248> getCustomPlantBlocks() {
        return this.customPlantBlockIds.stream().map(class_2960::method_12829).filter(Objects::nonNull).map(arg_0 -> ((class_7922)class_7923.field_41175).method_10223(arg_0)).collect(Collectors.toList());
    }

    public void setCustomPlantBlocks(List<class_2248> blocks) {
        this.customPlantBlockIds = blocks.stream().map(block -> class_7923.field_41175.method_10221(block).toString()).collect(Collectors.toSet());
        this.notifyListeners();
    }

    private void notifyListeners() {
    }

    public void save() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        File configFile = configDir.resolve(CONFIG_FILE_NAME).toFile();
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)this, (Appendable)writer);
            PushdozerMod.LOGGER.info("Pushdozer configuration is saved");
        }
        catch (IOException e) {
            PushdozerMod.LOGGER.error("An error occurred while saving the Pushdozer configuration", (Throwable)e);
        }
    }

    public static PushdozerConfig load() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        File configFile = configDir.resolve(CONFIG_FILE_NAME).toFile();
        PushdozerConfig config = null;
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (PushdozerConfig)GSON.fromJson((Reader)reader, PushdozerConfig.class);
                PushdozerMod.LOGGER.info("Configuration has been loaded");
            }
            catch (IOException e) {
                PushdozerMod.LOGGER.error("An error occurred while loading the Pushdozer configuration", (Throwable)e);
            }
        }
        if (config == null) {
            config = new PushdozerConfig();
            PushdozerMod.LOGGER.info("Creating new default configuration");
        }
        if (config.getWorkMode() == null) {
            config.setWorkMode(WorkMode.EXCAVATE);
        }
        if (config.getDisplayMode() == null) {
            config.setDisplayMode(DisplayMode.WIREFRAME);
            PushdozerMod.LOGGER.warn("DisplayMode was null, setting default to WIREFRAME");
        }
        if (config.getHeightMode() == null) {
            if (config.getLockedHeight() != 0) {
                config.setHeightMode(HeightMode.CUSTOM);
            } else {
                config.setHeightMode(HeightMode.NO_LIMIT);
            }
        }
        if (config.getPlantType() == null) {
            config.setPlantType(PlantType.TREES);
            PushdozerMod.LOGGER.warn("PlantType was null, setting default to TREES");
        }
        try {
            WorkMode wm = config.getWorkMode();
            if (wm == WorkMode.SMOOTH_RAISE) {
                config.setSmoothVariant(SmoothVariant.RAISE);
                config.setWorkMode(WorkMode.SMOOTH);
            } else if (wm == WorkMode.SMOOTH_LOWER) {
                config.setSmoothVariant(SmoothVariant.LOWER);
                config.setWorkMode(WorkMode.SMOOTH);
            } else if (wm == WorkMode.ADAPTIVE_SMOOTH) {
                config.setSmoothVariant(SmoothVariant.ADAPTIVE);
                config.setWorkMode(WorkMode.SMOOTH);
            }
        }
        catch (Exception e) {
            PushdozerMod.LOGGER.warn("Failed to migrate old smooth work modes", (Throwable)e);
        }
        config.ignoredBlocksCacheDirty = true;
        config.rebuildIgnoredBlocksCache();
        try {
            if (!configFile.exists()) {
                configFile.getParentFile().mkdirs();
                configFile.createNewFile();
            }
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            PushdozerMod.LOGGER.error("Failed to save default configuration", (Throwable)e);
        }
        return config;
    }

    public List<String> getIgnoredBlockIds() {
        return this.ignoredBlockIds;
    }

    public Set<class_2248> getIgnoredBlocks() {
        if (this.ignoredBlocksCacheDirty) {
            this.rebuildIgnoredBlocksCache();
        }
        return this.ignoredBlocks;
    }

    public boolean isBlockIgnored(class_2248 block) {
        if (this.ignoredBlocksCacheDirty) {
            this.rebuildIgnoredBlocksCache();
        }
        return this.ignoredBlocks.contains(block);
    }

    public void rebuildIgnoredBlocksCache() {
        this.ignoredBlocks.clear();
        for (String blockId : this.ignoredBlockIds) {
            try {
                class_2248 block;
                class_2960 identifier = class_2960.method_12829((String)blockId);
                if (identifier == null || (block = (class_2248)class_7923.field_41175.method_10223(identifier)) == class_2246.field_10124) continue;
                this.ignoredBlocks.add(block);
            }
            catch (Exception e) {
                PushdozerMod.LOGGER.warn("\u65e0\u6cd5\u89e3\u6790\u5ffd\u7565\u65b9\u5757ID: {}", (Object)blockId);
            }
        }
        this.ignoredBlocksCacheDirty = false;
    }

    public List<class_2248> getBreakableBlocks() {
        return this.breakableBlockIds.stream().map(class_2960::method_12829).filter(Objects::nonNull).map(arg_0 -> ((class_7922)class_7923.field_41175).method_10223(arg_0)).collect(Collectors.toList());
    }

    public void setBreakableBlocks(List<class_2248> blocks) {
        this.breakableBlockIds = blocks.stream().map(block -> class_7923.field_41175.method_10221(block).toString()).collect(Collectors.toSet());
        this.notifyListeners();
    }

    public static PushdozerConfig getInstance() {
        if (instance == null) {
            instance = PushdozerConfig.load();
        }
        return instance;
    }

    public static enum WorkMode {
        EXCAVATE("pushdozer.mode.excavate"),
        PLACE("pushdozer.mode.place"),
        SMOOTH("pushdozer.mode.smooth"),
        SMOOTH_RAISE("pushdozer.mode.smooth_raise"),
        SMOOTH_LOWER("pushdozer.mode.smooth_lower"),
        SURFACE_ROUGHEN("pushdozer.mode.surface_roughen"),
        ADAPTIVE_SMOOTH("pushdozer.mode.adaptive_smooth"),
        SURFACE_CONVERT("pushdozer.mode.surface_convert"),
        BONE_MEAL("pushdozer.mode.bone_meal"),
        BATCH_PLANT("pushdozer.mode.batch_plant"),
        SHORELINE_PROCESS("pushdozer.mode.shoreline_process");

        private final String translationKey;

        private WorkMode(String translationKey) {
            this.translationKey = translationKey;
        }

        public class_2561 getDisplayText() {
            return class_2561.method_43471((String)this.translationKey);
        }
    }

    public static enum DisplayMode {
        NONE("pushdozer.display_mode.none"),
        WIREFRAME("pushdozer.display_mode.wireframe"),
        POINT_CLOUD("pushdozer.display_mode.point_cloud");

        private final String translationKey;

        private DisplayMode(String translationKey) {
            this.translationKey = translationKey;
        }

        public class_2561 getDisplayText() {
            return class_2561.method_43471((String)this.translationKey);
        }
    }

    public static enum GeometryType {
        SPHERE("pushdozer.geometry.sphere"),
        BOX("pushdozer.geometry.box"),
        OCTAHEDRON("pushdozer.geometry.octahedron"),
        CYLINDER("pushdozer.geometry.cylinder"),
        CONE("pushdozer.geometry.cone"),
        ELLIPSOID("pushdozer.geometry.ellipsoid"),
        TETRAHEDRON("pushdozer.geometry.tetrahedron"),
        TRIANGULAR_PRISM("pushdozer.geometry.triangular_prism");

        private final String translationKey;

        private GeometryType(String translationKey) {
            this.translationKey = translationKey;
        }

        public class_2561 getDisplayText() {
            return class_2561.method_43471((String)this.translationKey);
        }

        public String getShapeString() {
            return this.name().toLowerCase();
        }

        public static GeometryType fromString(String shapeString) {
            for (GeometryType type : GeometryType.values()) {
                if (!type.name().equalsIgnoreCase(shapeString) && !type.getShapeString().equalsIgnoreCase(shapeString)) continue;
                return type;
            }
            if ("sphere".equalsIgnoreCase(shapeString)) {
                return SPHERE;
            }
            if ("box".equalsIgnoreCase(shapeString)) {
                return BOX;
            }
            return BOX;
        }
    }

    public static enum HeightMode {
        FOLLOW_PLAYER,
        LOCKED_ONCE,
        NO_LIMIT,
        CUSTOM;

    }

    public static enum PlaceMode {
        ADAPTIVE_BIOME("pushdozer.place_mode.adaptive_biome"),
        NATURAL_BLOCK("pushdozer.place_mode.natural_block");

        private final String translationKey;

        private PlaceMode(String translationKey) {
            this.translationKey = translationKey;
        }

        public class_2561 getDisplayText() {
            return class_2561.method_43471((String)this.translationKey);
        }
    }

    public static enum SmoothVariant {
        ADAPTIVE,
        RAISE,
        LOWER;


        public class_2561 getDisplayText() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> class_2561.method_43471((String)"pushdozer.mode.adaptive_smooth");
                case 1 -> class_2561.method_43471((String)"pushdozer.mode.smooth_raise");
                case 2 -> class_2561.method_43471((String)"pushdozer.mode.smooth_lower");
            };
        }
    }

    public static class SurfaceConvertBlock {
        @Expose
        private String blockId;
        @Expose
        private float percentage;

        public SurfaceConvertBlock(String blockId, float percentage) {
            this.blockId = blockId;
            this.percentage = percentage;
        }

        public String getBlockId() {
            return this.blockId;
        }

        public float getPercentage() {
            return this.percentage;
        }

        public void setPercentage(float percentage) {
            this.percentage = Math.max(0.0f, Math.min(100.0f, percentage));
        }
    }

    public static enum PlantType {
        TREES("pushdozer.plant_type.trees"),
        FLOWERS("pushdozer.plant_type.flowers"),
        GRASS("pushdozer.plant_type.grass"),
        CUSTOM("pushdozer.plant_type.custom");

        private final String translationKey;

        private PlantType(String translationKey) {
            this.translationKey = translationKey;
        }

        public class_2561 getDisplayText() {
            return class_2561.method_43471((String)this.translationKey);
        }
    }

    public static enum ShorelineType {
        BEACH("pushdozer.shoreline_type.beach"),
        EMBANKMENT("pushdozer.shoreline_type.embankment"),
        ADAPTIVE("pushdozer.shoreline_type.adaptive"),
        MUDDY("pushdozer.shoreline_type.muddy"),
        ROCKY("pushdozer.shoreline_type.rocky"),
        CUSTOM("pushdozer.shoreline_type.custom");

        private final String translationKey;

        private ShorelineType(String translationKey) {
            this.translationKey = translationKey;
        }

        public class_2561 getDisplayText() {
            return class_2561.method_43471((String)this.translationKey);
        }
    }

    public static enum TreeSpecies {
        OAK,
        SPRUCE,
        BIRCH,
        JUNGLE,
        ACACIA,
        DARK_OAK,
        BIOME_ADAPTIVE;


        public class_2561 getDisplayText() {
            return class_2561.method_43471((String)("pushdozer.tree_species." + this.name().toLowerCase()));
        }
    }

    public static enum FlowerGroup {
        PLAINS_FLOWERS,
        FOREST_FLOWERS,
        ALL_FLOWERS,
        BIOME_ADAPTIVE;


        public class_2561 getDisplayText() {
            return class_2561.method_43471((String)("pushdozer.flower_group." + this.name().toLowerCase()));
        }
    }
}

