/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.items;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.pushdozer.PushdozerMod;
import com.pushdozer.component.PushdozerComponents;
import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.operations.UndoAction;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public class PushdozerItem
extends class_1792 {
    private static final Map<PushdozerConfig.WorkMode, IOperationHandler> OPERATION_HANDLERS = ImmutableMap.builder().put((Object)PushdozerConfig.WorkMode.EXCAVATE, (p, w, c) -> PushdozerMod.excavationHandler.handleExcavation(p, w)).put((Object)PushdozerConfig.WorkMode.PLACE, (p, w, c) -> PushdozerMod.placementHandler.handlePlacement(p, w)).put((Object)PushdozerConfig.WorkMode.SMOOTH, (p, w, c) -> {
        PushdozerConfig.SmoothVariant variant = c.getSmoothVariant();
        switch (variant) {
            case RAISE: {
                PushdozerMod.smoothRaiseHandler.handleSmoothRaise(p, w);
                break;
            }
            case LOWER: {
                PushdozerMod.smoothLowerHandler.handleSmoothLower(p, w);
                break;
            }
            default: {
                PushdozerMod.adaptiveSmoothHandler.handleOperation(p, w, UndoAction.ActionType.SMOOTH);
            }
        }
    }).put((Object)PushdozerConfig.WorkMode.SMOOTH_RAISE, (p, w, c) -> PushdozerMod.smoothRaiseHandler.handleSmoothRaise(p, w)).put((Object)PushdozerConfig.WorkMode.SMOOTH_LOWER, (p, w, c) -> PushdozerMod.smoothLowerHandler.handleSmoothLower(p, w)).put((Object)PushdozerConfig.WorkMode.SURFACE_ROUGHEN, (p, w, c) -> PushdozerMod.surfaceRoughenHandler.handleSurfaceRoughen(p, w)).put((Object)PushdozerConfig.WorkMode.ADAPTIVE_SMOOTH, (p, w, c) -> PushdozerMod.adaptiveSmoothHandler.handleOperation(p, w, UndoAction.ActionType.SMOOTH)).put((Object)PushdozerConfig.WorkMode.SURFACE_CONVERT, (p, w, c) -> PushdozerMod.surfaceConvertHandler.handleSurfaceConvert(p, w)).put((Object)PushdozerConfig.WorkMode.BONE_MEAL, (p, w, c) -> PushdozerMod.boneMealHandler.handleBoneMeal(p, w)).put((Object)PushdozerConfig.WorkMode.BATCH_PLANT, (p, w, c) -> PushdozerMod.batchPlantHandler.handleBatchPlant(p, w)).put((Object)PushdozerConfig.WorkMode.SHORELINE_PROCESS, (p, w, c) -> PushdozerMod.shorelineProcessHandler.handleShorelineProcess(p, w)).build();

    public PushdozerItem(class_1792.class_1793 settings) {
        super(settings.method_57349(PushdozerComponents.DISPLAY_MODE, (Object)DisplayMode.NONE));
    }

    public DisplayMode getDisplayMode(class_1799 stack) {
        return (DisplayMode)((Object)stack.method_57825(PushdozerComponents.DISPLAY_MODE, (Object)DisplayMode.NONE));
    }

    public void setDisplayMode(class_1799 stack, DisplayMode mode) {
        stack.method_57379(PushdozerComponents.DISPLAY_MODE, (Object)mode);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        PushdozerConfig config;
        PushdozerConfig.WorkMode currentMode;
        IOperationHandler handler;
        if (!world.field_9236 && (handler = OPERATION_HANDLERS.get((Object)(currentMode = (config = PushdozerMod.getConfig()).getWorkMode()))) != null) {
            handler.handle(player, world, config);
        }
        return class_1271.method_22427((Object)player.method_5998(hand));
    }

    public static enum DisplayMode {
        NONE("pushdozer.display_mode.none"),
        WIREFRAME("pushdozer.display_mode.wireframe"),
        POINT_CLOUD("pushdozer.display_mode.point_cloud");

        public static final Codec<DisplayMode> CODEC;

        private DisplayMode(String translationKey) {
        }

        static {
            CODEC = Codec.stringResolver(Enum::name, str -> {
                try {
                    return DisplayMode.valueOf(str);
                }
                catch (IllegalArgumentException e) {
                    PushdozerMod.LOGGER.warn("Unknown display mode '{}', using NONE as fallback", str);
                    return NONE;
                }
            });
        }
    }

    @FunctionalInterface
    public static interface IOperationHandler {
        public void handle(class_1657 var1, class_1937 var2, PushdozerConfig var3);
    }
}

