/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.items.handlers;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.items.handlers.AbstractTerrainToolHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;

public class AdaptiveSmoothHandler
extends AbstractTerrainToolHandler {
    private static final float BILATERAL_KERNEL_RADIUS_FACTOR = 2.0f;
    private static final float[] SCALE_FACTORS = new float[]{0.5f, 1.0f, 1.5f};
    private static final float[] SCALE_WEIGHTS = new float[]{0.5f, 0.4f, 0.1f};
    private static final float RIDGE_THRESHOLD = 2.0f;
    private static final float VALLEY_THRESHOLD = -2.0f;
    private static final float FEATURE_PROTECTION_FACTOR = 0.35f;
    private static final Map<Integer, List<class_2338>> OFFSETS_CACHE = new HashMap<Integer, List<class_2338>>();

    public AdaptiveSmoothHandler(PushdozerConfig config) {
        super(config);
    }

    @Override
    protected int calculateTargetHeight(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> columns, AbstractTerrainToolHandler.TerrainColumn currentColumn, class_2338 columnXZ, class_2338 brushCenter) {
        float smoothStrength = this.config.getSmoothStrength();
        float multiScaleHeight = this.calculateMultiScaleSmoothedHeight(columns, currentColumn, columnXZ, brushCenter);
        TerrainFeature feature = this.detectTerrainFeature(columns, currentColumn, columnXZ);
        float protectedHeight = this.applyFeatureProtection(currentColumn.getOriginalHeight(), multiScaleHeight, feature);
        float t = Math.max(0.0f, Math.min(1.0f, smoothStrength));
        float s = t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
        float targetHeight = (float)currentColumn.getOriginalHeight() * (1.0f - s) + protectedHeight * s;
        return Math.round(targetHeight);
    }

    private float calculateBilateralSmoothedHeight(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> columns, AbstractTerrainToolHandler.TerrainColumn currentColumn, class_2338 columnXZ, class_2338 brushCenter, int brushRadius) {
        float totalWeight = 0.0f;
        float weightedHeightSum = 0.0f;
        float spatialSigma = (float)brushRadius / 2.0f;
        float twoSpatialSigmaSquared = 2.0f * spatialSigma * spatialSigma;
        float kernelRadius = spatialSigma * 2.0f;
        float heightSigma = this.getAdaptiveHeightSigma(brushRadius);
        float twoHeightSigmaSquared = 2.0f * heightSigma * heightSigma;
        class_2338 brushCenterXZ = new class_2338(brushCenter.method_10263(), 0, brushCenter.method_10260());
        float falloff = this.calculateFalloffWithoutSqrt(columnXZ, brushCenterXZ, brushRadius);
        for (class_2338 offset : this.getOffsetsForRadius(kernelRadius)) {
            class_2338 neighborColumnXZ = new class_2338(columnXZ.method_10263() + offset.method_10263(), 0, columnXZ.method_10260() + offset.method_10260());
            AbstractTerrainToolHandler.TerrainColumn neighborColumn = columns.get(neighborColumnXZ);
            if (neighborColumn == null) continue;
            double spatialDistanceSq = offset.method_10263() * offset.method_10263() + offset.method_10260() * offset.method_10260();
            float heightDiff = Math.abs(neighborColumn.getOriginalHeight() - currentColumn.getOriginalHeight());
            float spatialWeight = (float)Math.exp(-spatialDistanceSq / (double)twoSpatialSigmaSquared);
            float heightWeight = (float)Math.exp(-heightDiff * heightDiff / twoHeightSigmaSquared);
            float bilateralWeight = spatialWeight * heightWeight;
            weightedHeightSum += (float)neighborColumn.getOriginalHeight() * (bilateralWeight *= falloff);
            totalWeight += bilateralWeight;
        }
        if (totalWeight <= 0.0f) {
            return currentColumn.getOriginalHeight();
        }
        return weightedHeightSum / totalWeight;
    }

    private float getAdaptiveHeightSigma(int brushRadius) {
        if (brushRadius <= 5) {
            return 2.0f;
        }
        if (brushRadius <= 10) {
            return 3.0f;
        }
        return 4.0f;
    }

    private float calculateMultiScaleSmoothedHeight(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> columns, AbstractTerrainToolHandler.TerrainColumn currentColumn, class_2338 columnXZ, class_2338 brushCenter) {
        float totalWeight = 0.0f;
        float weightedSum = 0.0f;
        for (int i = 0; i < SCALE_FACTORS.length; ++i) {
            float scale = SCALE_FACTORS[i];
            float weight = SCALE_WEIGHTS[i];
            int scaledRadius = Math.max(1, Math.round((float)this.config.getRadius() * scale));
            float smoothedHeight = this.calculateBilateralSmoothedHeight(columns, currentColumn, columnXZ, brushCenter, scaledRadius);
            weightedSum += smoothedHeight * weight;
            totalWeight += weight;
        }
        return totalWeight > 0.0f ? weightedSum / totalWeight : (float)currentColumn.getOriginalHeight();
    }

    private TerrainFeature detectTerrainFeature(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> columns, AbstractTerrainToolHandler.TerrainColumn currentColumn, class_2338 columnXZ) {
        float centerHeight = currentColumn.getOriginalHeight();
        ArrayList<Float> neighborHeights = new ArrayList<Float>();
        for (class_2338 class_23382 : this.getOffsetsForRadius(2.0f)) {
            class_2338 neighborXZ;
            AbstractTerrainToolHandler.TerrainColumn neighbor;
            if (class_23382.method_10263() == 0 && class_23382.method_10260() == 0 || (neighbor = columns.get(neighborXZ = new class_2338(columnXZ.method_10263() + class_23382.method_10263(), 0, columnXZ.method_10260() + class_23382.method_10260()))) == null) continue;
            neighborHeights.add(Float.valueOf(neighbor.getOriginalHeight()));
        }
        if (neighborHeights.isEmpty()) {
            return TerrainFeature.FLAT;
        }
        float avgNeighbor = 0.0f;
        Iterator iterator = neighborHeights.iterator();
        while (iterator.hasNext()) {
            float h = ((Float)iterator.next()).floatValue();
            avgNeighbor += h;
        }
        float f = centerHeight - (avgNeighbor /= (float)neighborHeights.size());
        if (f > 2.0f) {
            return TerrainFeature.RIDGE;
        }
        if (f < -2.0f) {
            return TerrainFeature.VALLEY;
        }
        return TerrainFeature.FLAT;
    }

    private float applyFeatureProtection(float originalHeight, float smoothedHeight, TerrainFeature feature) {
        if (feature == TerrainFeature.FLAT) {
            return smoothedHeight;
        }
        float p = 0.35f;
        return originalHeight * p + smoothedHeight * (1.0f - p);
    }

    private float calculateFalloffWithoutSqrt(class_2338 columnXZ, class_2338 brushCenterXZ, int brushRadius) {
        int dx = columnXZ.method_10263() - brushCenterXZ.method_10263();
        int dz = columnXZ.method_10260() - brushCenterXZ.method_10260();
        float d2 = dx * dx + dz * dz;
        float r0 = (float)brushRadius * 0.8f;
        float r1sq = (float)brushRadius * (float)brushRadius;
        float r0sq = r0 * r0;
        if (d2 <= r0sq) {
            return 1.0f;
        }
        if (d2 >= r1sq) {
            return 0.0f;
        }
        float t = (d2 - r0sq) / (r1sq - r0sq);
        t = Math.max(0.0f, Math.min(1.0f, t));
        return (float)(Math.cos((double)t * Math.PI) * 0.5 + 0.5);
    }

    private List<class_2338> getOffsetsForRadius(float radius) {
        int maxR = Math.max(1, Math.round(radius));
        int key = maxR * maxR;
        List<class_2338> cached = OFFSETS_CACHE.get(key);
        if (cached != null) {
            return cached;
        }
        ArrayList<class_2338> offsets = new ArrayList<class_2338>();
        int r2 = maxR * maxR;
        for (int dz = -maxR; dz <= maxR; ++dz) {
            for (int dx = -maxR; dx <= maxR; ++dx) {
                int d2 = dx * dx + dz * dz;
                if (d2 > r2) continue;
                offsets.add(new class_2338(dx, 0, dz));
            }
        }
        OFFSETS_CACHE.put(key, Collections.unmodifiableList(offsets));
        return OFFSETS_CACHE.get(key);
    }

    private static enum TerrainFeature {
        RIDGE,
        VALLEY,
        FLAT;

    }
}

