/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.items.handlers;

import com.pushdozer.PushdozerMod;
import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.network.NetworkManager;
import com.pushdozer.operations.BlockOperation;
import com.pushdozer.operations.UndoAction;
import com.pushdozer.shapes.GeometryShape;
import com.pushdozer.util.ShapeUtil;
import com.pushdozer.util.TerrainBlockSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2266;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2381;
import net.minecraft.class_2397;
import net.minecraft.class_2404;
import net.minecraft.class_2473;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2523;
import net.minecraft.class_2527;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3709;
import net.minecraft.class_3962;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlacementHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"pushdozer");
    private final PushdozerConfig config;
    private static final class_6862<class_2248> DECORATIVE_BLOCKS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"pushdozer", (String)"decorative"));
    private static final Map<class_2248, class_2248> BLOCK_REPLACEMENT_MAP = new HashMap<class_2248, class_2248>();

    public PlacementHandler(PushdozerConfig config) {
        this.config = config;
    }

    public List<class_2338> handlePlacement(class_1657 player, class_1937 world) {
        List<class_2338> placedPositions = new ArrayList<class_2338>();
        if (world.field_9236) {
            return placedPositions;
        }
        if (!this.hasPlacementPermission(player, world)) {
            return placedPositions;
        }
        LOGGER.debug("\u5f00\u59cb\u653e\u7f6e\u64cd\u4f5c\uff0c\u73a9\u5bb6: {}", (Object)player.method_5477().getString());
        class_2338 basePos = ShapeUtil.getTargetBlockPos(player, this.config);
        LOGGER.debug("\u57fa\u51c6\u4f4d\u7f6e\uff1a{}", (Object)basePos);
        GeometryShape shape = ShapeUtil.createShape(player, this.config, basePos);
        if (shape == null) {
            LOGGER.error("\u521b\u5efa\u51e0\u4f55\u4f53\u5931\u8d25\uff0c\u653e\u7f6e\u64cd\u4f5c\u4e2d\u65ad\u3002");
            return placedPositions;
        }
        placedPositions = this.processBlockPlacement(shape, player, world);
        return placedPositions;
    }

    private boolean hasPlacementPermission(class_1657 player, class_1937 world) {
        if (world.method_8503() != null && world.method_8503().method_3724()) {
            return true;
        }
        if (player instanceof class_3222 && this.config.getRadius() > 100) {
            LOGGER.warn("\u73a9\u5bb6 {} \u5c1d\u8bd5\u6267\u884c\u8fc7\u5927\u8303\u56f4\u653e\u7f6e\u64cd\u4f5c: \u534a\u5f84 {}", (Object)player.method_5477().getString(), (Object)this.config.getRadius());
            return false;
        }
        return true;
    }

    private List<class_2338> processBlockPlacement(GeometryShape shape, class_1657 player, class_1937 world) {
        ArrayList<class_2338> placedBlocks = new ArrayList<class_2338>();
        ArrayList<class_2680> originalStates = new ArrayList<class_2680>();
        ArrayList<class_2680> newStates = new ArrayList<class_2680>();
        class_2338 center = shape.getCenter();
        int minY = shape.getMinY(center);
        int maxY = shape.getMaxY(center);
        boolean startedPlacing = false;
        for (int y = maxY; y >= minY; --y) {
            ArrayList<class_2338> layerBlocks = new ArrayList<class_2338>();
            ArrayList<class_2680> layerNewStates = new ArrayList<class_2680>();
            boolean layerHasNonAllowedBlocks = false;
            for (class_2338 pos : shape.getBlocksInLayer(center, y)) {
                if (this.isAllowedBlock(world.method_8320(pos), world, pos)) continue;
                layerHasNonAllowedBlocks = true;
                break;
            }
            if (!layerHasNonAllowedBlocks && !startedPlacing) continue;
            startedPlacing = true;
            for (class_2338 pos : shape.getBlocksInLayer(center, y)) {
                if (!this.isValidPlacementPosition(pos, world, shape, player)) continue;
                layerBlocks.add(pos);
                originalStates.add(world.method_8320(pos));
                placedBlocks.add(pos);
                class_2248 fillBlock = this.getFillBlock(pos, world);
                fillBlock = this.applyBlockReplacementRules(fillBlock);
                class_2680 newState = fillBlock.method_9564();
                newStates.add(newState);
                layerNewStates.add(newState);
            }
            this.placeBlocksBulk(layerBlocks, layerNewStates, world);
        }
        if (!placedBlocks.isEmpty()) {
            class_3218 serverWorld;
            LOGGER.info("\u521b\u5efa\u64a4\u9500\u64cd\u4f5c\uff0c\u653e\u7f6e\u65b9\u5757\u6570: {}", (Object)placedBlocks.size());
            BlockOperation.BoundaryExtension boundaryExtension = BlockOperation.collectBoundaryExtension(placedBlocks, world);
            LOGGER.info("\u8fb9\u754c\u6269\u5c55\u6536\u96c6\u5b8c\u6210\uff0c\u6269\u5c55\u4f4d\u7f6e\u6570: {}", (Object)boundaryExtension.getSize());
            UndoAction undoAction = new UndoAction(UndoAction.ActionType.PLACE, placedBlocks, originalStates, newStates, boundaryExtension.getPositions(), boundaryExtension.getOriginalStates(), boundaryExtension.getNewStates());
            LOGGER.info("\u64a4\u9500\u64cd\u4f5c\u521b\u5efa\u5b8c\u6210\uff0c\u9a8c\u8bc1\u72b6\u6001: {}", (Object)undoAction.isValid());
            PushdozerMod.pushUndoAction(player, undoAction);
            PushdozerMod.debugUndoStacks(player);
            if (world instanceof class_3218 && !(serverWorld = (class_3218)world).method_8503().method_3724()) {
                NetworkManager.broadcastTerrainOperation(serverWorld, "PLACE", placedBlocks, newStates);
                LOGGER.info("\u5e7f\u64ad\u653e\u7f6e\u64cd\u4f5c\u5230\u5176\u4ed6\u73a9\u5bb6\uff0c\u5f71\u54cd\u65b9\u5757\u6570: {}\uff0c\u8fb9\u754c\u6269\u5c55: {}", (Object)placedBlocks.size(), (Object)boundaryExtension.getSize());
            }
        } else {
            LOGGER.info("\u6ca1\u6709\u653e\u7f6e\u4efb\u4f55\u65b9\u5757\uff0c\u8df3\u8fc7\u64a4\u9500\u64cd\u4f5c\u521b\u5efa");
        }
        return placedBlocks;
    }

    private class_2248 getFillBlock(class_2338 pos, class_1937 world) {
        if (this.config.getPlaceMode() == PushdozerConfig.PlaceMode.NATURAL_BLOCK) {
            return this.config.getSelectedNaturalBlock();
        }
        return TerrainBlockSelector.getNaturalTerrainBlock(pos, world);
    }

    private class_2248 applyBlockReplacementRules(class_2248 originalBlock) {
        class_2248 replacement = BLOCK_REPLACEMENT_MAP.get(originalBlock);
        if (replacement != null) {
            return replacement;
        }
        if (this.shouldReplaceSpecialBlock(originalBlock)) {
            return this.getReplacementForSpecialBlock(originalBlock);
        }
        if (this.shouldReplaceByTag(originalBlock)) {
            return this.getReplacementByTag(originalBlock);
        }
        if (this.isGrowingPlant(originalBlock)) {
            return class_2246.field_10219;
        }
        return originalBlock;
    }

    private boolean shouldReplaceSpecialBlock(class_2248 block) {
        return block instanceof class_2527 || block instanceof class_3709 || block instanceof class_3962 || block instanceof class_2510 || block instanceof class_2482;
    }

    private class_2248 getReplacementForSpecialBlock(class_2248 block) {
        if (block instanceof class_2527 || block instanceof class_3709) {
            return class_2246.field_10445;
        }
        if (block instanceof class_3962) {
            return class_2246.field_10219;
        }
        if (block instanceof class_2510 || block instanceof class_2482) {
            return class_2246.field_10566;
        }
        return block;
    }

    private boolean shouldReplaceByTag(class_2248 block) {
        return block.method_9564().method_26164(class_3481.field_16584) || block.method_9564().method_26164(class_3481.field_25147) || block.method_9564().method_26164(class_3481.field_15471) || block.method_9564().method_26164(class_3481.field_15481);
    }

    private class_2248 getReplacementByTag(class_2248 block) {
        if (block.method_9564().method_26164(class_3481.field_16584) || block.method_9564().method_26164(class_3481.field_25147)) {
            return class_2246.field_10445;
        }
        if (block.method_9564().method_26164(class_3481.field_15471)) {
            return class_2246.field_10566;
        }
        if (block.method_9564().method_26164(class_3481.field_15481)) {
            return class_2246.field_10219;
        }
        return block;
    }

    private void placeBlocksBulk(List<class_2338> positions, List<class_2680> states, class_1937 world) {
        int flags = 50;
        for (int i = 0; i < positions.size(); ++i) {
            class_2338 pos = positions.get(i);
            class_2680 newState = states.get(i);
            world.method_8652(pos, newState, 50);
            if (!(newState.method_26204() instanceof class_2346)) continue;
            world.method_39279(pos, newState.method_26204(), 2);
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            for (int i = 0; i < positions.size(); ++i) {
                class_2338 pos = positions.get(i);
                class_2680 newState = states.get(i);
                serverWorld.method_22336().method_15513(pos);
                world.method_8408(pos, newState.method_26204());
                world.method_8408(pos.method_10074(), newState.method_26204());
            }
        }
    }

    private boolean isValidPlacementPosition(class_2338 pos, class_1937 world, GeometryShape shape, class_1657 player) {
        if (pos == null || world == null || shape == null || player == null) {
            PushdozerMod.LOGGER.error("isValidPlacementPosition \u65b9\u6cd5\u63a5\u6536\u5230 null \u53c2");
            return false;
        }
        class_2680 state = world.method_8320(pos);
        PushdozerConfig.HeightMode heightMode = this.config.getHeightMode();
        if (heightMode == PushdozerConfig.HeightMode.FOLLOW_PLAYER ? pos.method_10264() > player.method_31478() - 1 : (heightMode == PushdozerConfig.HeightMode.LOCKED_ONCE || heightMode == PushdozerConfig.HeightMode.CUSTOM) && pos.method_10264() > this.config.getLockedHeight()) {
            return false;
        }
        if (this.isAboveOrAtPlayerLevel(pos, player)) {
            return false;
        }
        if (!shape.isWithinBounds(pos, shape.getCenter())) {
            return false;
        }
        if (this.config.isBlockIgnored(state.method_26204())) {
            return false;
        }
        return this.isAirOrDecorative(state, world, pos);
    }

    private boolean isAboveOrAtPlayerLevel(class_2338 pos, class_1657 player) {
        return pos.method_10263() == player.method_31477() && pos.method_10260() == player.method_31479() && pos.method_10264() >= player.method_31478();
    }

    private boolean isAirOrDecorative(class_2680 state, class_1937 world, class_2338 pos) {
        class_2248 block = state.method_26204();
        return state.method_26215() || this.isDecorativeBlock(block) || this.isNonSolidBlock(state, world, pos);
    }

    private boolean isNonSolidBlock(class_2680 state, class_1937 world, class_2338 pos) {
        return state.method_26215() || state.method_26220((class_1922)world, pos).method_1110() || state.method_26204() instanceof class_2346;
    }

    private boolean isAllowedBlock(class_2680 state, class_1937 world, class_2338 pos) {
        class_2248 block = state.method_26204();
        return state.method_26215() || this.isDecorativeBlock(block) || block instanceof class_2397 || this.isWoodBlock(block) || block instanceof class_2211 || block instanceof class_2404 || this.isNonSolidBlock(state, world, pos);
    }

    private boolean isWoodBlock(class_2248 block) {
        return block.method_9564().method_26164(class_3481.field_15475);
    }

    private boolean isGrowingPlant(class_2248 block) {
        return block instanceof class_2261 || block instanceof class_2397 || block instanceof class_2381 || block instanceof class_2541 || block instanceof class_2523 || block instanceof class_2266 || block instanceof class_2211 || block instanceof class_2302 || block instanceof class_2473;
    }

    private boolean isDecorativeBlock(class_2248 block) {
        return block.method_9564().method_26164(DECORATIVE_BLOCKS);
    }

    static {
        BLOCK_REPLACEMENT_MAP.put(class_2246.field_10164, class_2246.field_10340);
        BLOCK_REPLACEMENT_MAP.put(class_2246.field_10102, class_2246.field_9979);
        BLOCK_REPLACEMENT_MAP.put(class_2246.field_10255, class_2246.field_10340);
        BLOCK_REPLACEMENT_MAP.put(class_2246.field_10477, class_2246.field_10491);
        BLOCK_REPLACEMENT_MAP.put(class_2246.field_28048, class_2246.field_10340);
        BLOCK_REPLACEMENT_MAP.put(class_2246.field_28411, class_2246.field_10340);
        BLOCK_REPLACEMENT_MAP.put(class_2246.field_10302, class_2246.field_10219);
        BLOCK_REPLACEMENT_MAP.put(class_2246.field_17563, class_2246.field_10219);
        BLOCK_REPLACEMENT_MAP.put(class_2246.field_10424, class_2246.field_10219);
        BLOCK_REPLACEMENT_MAP.put(class_2246.field_10029, class_2246.field_10219);
        BLOCK_REPLACEMENT_MAP.put(class_2246.field_10211, class_2246.field_10219);
    }
}

