/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.items.handlers;

import com.pushdozer.items.handlers.AbstractTerrainToolHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class SpatialIndex {
    private final Map<Integer, Map<Integer, List<class_2338>>> gridIndex = new HashMap<Integer, Map<Integer, List<class_2338>>>();
    private final int gridSize;
    private final Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> terrainData;

    public SpatialIndex(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> terrainData, int gridSize) {
        this.terrainData = terrainData;
        this.gridSize = gridSize;
        this.buildIndex();
    }

    private void buildIndex() {
        for (class_2338 pos : this.terrainData.keySet()) {
            int gridX = pos.method_10263() / this.gridSize;
            int gridZ = pos.method_10260() / this.gridSize;
            this.gridIndex.computeIfAbsent(gridX, k -> new HashMap()).computeIfAbsent(gridZ, k -> new ArrayList()).add(pos);
        }
    }

    public List<class_2338> findInRange(class_2338 center, int radius) {
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        int minGridX = (center.method_10263() - radius) / this.gridSize;
        int maxGridX = (center.method_10263() + radius) / this.gridSize;
        int minGridZ = (center.method_10260() - radius) / this.gridSize;
        int maxGridZ = (center.method_10260() + radius) / this.gridSize;
        int radiusSq = radius * radius;
        for (int gridX = minGridX; gridX <= maxGridX; ++gridX) {
            Map<Integer, List<class_2338>> zMap = this.gridIndex.get(gridX);
            if (zMap == null) continue;
            for (int gridZ = minGridZ; gridZ <= maxGridZ; ++gridZ) {
                List<class_2338> positions = zMap.get(gridZ);
                if (positions == null) continue;
                for (class_2338 pos : positions) {
                    if (!(pos.method_10262((class_2382)center) <= (double)radiusSq)) continue;
                    result.add(pos);
                }
            }
        }
        return result;
    }

    public Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> findTerrainColumnsInRange(class_2338 center, int radius) {
        HashMap<class_2338, AbstractTerrainToolHandler.TerrainColumn> result = new HashMap<class_2338, AbstractTerrainToolHandler.TerrainColumn>();
        List<class_2338> positions = this.findInRange(center, radius);
        for (class_2338 pos : positions) {
            AbstractTerrainToolHandler.TerrainColumn column = this.terrainData.get(pos);
            if (column == null) continue;
            result.put(pos, column);
        }
        return result;
    }

    public AbstractTerrainToolHandler.TerrainColumn getTerrainColumn(class_2338 pos) {
        return this.terrainData.get(pos);
    }

    public boolean contains(class_2338 pos) {
        return this.terrainData.containsKey(pos);
    }

    public int size() {
        return this.terrainData.size();
    }

    public void clear() {
        this.gridIndex.clear();
        this.terrainData.clear();
    }

    public void addTerrainData(class_2338 pos, AbstractTerrainToolHandler.TerrainColumn column) {
        this.terrainData.put(pos, column);
        int gridX = pos.method_10263() / this.gridSize;
        int gridZ = pos.method_10260() / this.gridSize;
        this.gridIndex.computeIfAbsent(gridX, k -> new HashMap()).computeIfAbsent(gridZ, k -> new ArrayList()).add(pos);
    }

    public void removeTerrainData(class_2338 pos) {
        List<class_2338> positions;
        this.terrainData.remove(pos);
        int gridX = pos.method_10263() / this.gridSize;
        int gridZ = pos.method_10260() / this.gridSize;
        Map<Integer, List<class_2338>> zMap = this.gridIndex.get(gridX);
        if (zMap != null && (positions = zMap.get(gridZ)) != null) {
            positions.remove(pos);
            if (positions.isEmpty()) {
                zMap.remove(gridZ);
                if (zMap.isEmpty()) {
                    this.gridIndex.remove(gridX);
                }
            }
        }
    }

    public IndexStats getStats() {
        int totalPositions = this.terrainData.size();
        int totalGrids = this.gridIndex.values().stream().mapToInt(zMap -> zMap.size()).sum();
        return new IndexStats(totalPositions, totalGrids, this.gridSize);
    }

    public static class IndexStats {
        public final int totalPositions;
        public final int totalGrids;
        public final int gridSize;

        public IndexStats(int totalPositions, int totalGrids, int gridSize) {
            this.totalPositions = totalPositions;
            this.totalGrids = totalGrids;
            this.gridSize = gridSize;
        }

        public String toString() {
            return String.format("SpatialIndex{positions=%d, grids=%d, gridSize=%d}", this.totalPositions, this.totalGrids, this.gridSize);
        }
    }
}

