/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.panels;

import com.pushdozer.PushdozerMod;
import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.ui.screens.PushdozerConfigScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;

public class HeightConfigPanel {
    private static final int COLOR_PANEL_BG = -1072689136;
    private static final int COLOR_PANEL_BORDER = -1;
    private static final int COLOR_TITLE_BG = -533712848;
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final int PANEL_WIDTH = 250;
    private static final int PANEL_HEIGHT = 125;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_MARGIN = 5;
    private static final int TITLE_HEIGHT = 20;
    private final PushdozerConfigScreen parent;
    private final PushdozerConfig config;
    private final List<class_364> widgets = new ArrayList<class_364>();
    private boolean visible = false;
    private int panelLeft;
    private int panelTop;
    private int titleX;
    private int titleY;
    private class_2561 titleText;
    private class_4185 followPlayerButton;
    private class_4185 lockOnceButton;
    private class_4185 noLimitButton;
    private class_4185 customHeightButton;
    private class_357 heightSlider;

    public HeightConfigPanel(PushdozerConfigScreen parent, PushdozerConfig config) {
        this.parent = parent;
        this.config = config;
        this.panelLeft = (parent.getScreenWidth() - 250) / 2;
        this.panelTop = (parent.getScreenHeight() - 125) / 2;
        this.initializeWidgets();
        this.initializeTitlePosition();
    }

    private void initializeWidgets() {
        this.widgets.clear();
        int startY = this.panelTop + 20 + 5;
        int buttonWidth = 117;
        int buttonFullWidth = 240;
        this.followPlayerButton = class_4185.method_46430((class_2561)this.getButtonText(PushdozerConfig.HeightMode.FOLLOW_PLAYER), button -> this.selectHeightMode(PushdozerConfig.HeightMode.FOLLOW_PLAYER)).method_46434(this.panelLeft + 5, startY, buttonWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.height_follow_player"))).method_46431();
        this.lockOnceButton = class_4185.method_46430((class_2561)this.getButtonText(PushdozerConfig.HeightMode.LOCKED_ONCE), button -> this.selectHeightMode(PushdozerConfig.HeightMode.LOCKED_ONCE)).method_46434(this.panelLeft + 10 + buttonWidth, startY, buttonWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.height_locked_once"))).method_46431();
        this.noLimitButton = class_4185.method_46430((class_2561)this.getButtonText(PushdozerConfig.HeightMode.NO_LIMIT), button -> this.selectHeightMode(PushdozerConfig.HeightMode.NO_LIMIT)).method_46434(this.panelLeft + 5, startY + 20 + 5, buttonWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.height_no_limit"))).method_46431();
        this.customHeightButton = class_4185.method_46430((class_2561)this.getButtonText(PushdozerConfig.HeightMode.CUSTOM), button -> this.selectHeightMode(PushdozerConfig.HeightMode.CUSTOM)).method_46434(this.panelLeft + 10 + buttonWidth, startY + 20 + 5, buttonWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.height_custom"))).method_46431();
        int currentHeight = this.config.getLockedHeight();
        this.heightSlider = new HeightConfigSlider(this.panelLeft + 5, startY + 50, buttonFullWidth, 20, (class_2561)class_2561.method_43469((String)"pushdozer.config.height_value", (Object[])new Object[]{currentHeight}), (double)(currentHeight + 64) / 384.0);
        class_4185 doneButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.button.done"), button -> {
            this.hide();
            this.parent.showMainPanel();
        }).method_46434(this.panelLeft + 5, this.panelTop + 125 - 20 - 5, buttonFullWidth, 20).method_46431();
        this.widgets.add((class_364)this.followPlayerButton);
        this.widgets.add((class_364)this.lockOnceButton);
        this.widgets.add((class_364)this.noLimitButton);
        this.widgets.add((class_364)this.customHeightButton);
        this.widgets.add((class_364)this.heightSlider);
        this.widgets.add((class_364)doneButton);
    }

    private class_2561 getButtonText(PushdozerConfig.HeightMode mode) {
        PushdozerConfig.HeightMode currentMode = this.config.getHeightMode();
        boolean isLockedOnce = this.config.isLockedOnceMode();
        String prefix = mode == PushdozerConfig.HeightMode.LOCKED_ONCE ? (isLockedOnce ? "\u2611 " : "") : (mode == PushdozerConfig.HeightMode.CUSTOM ? (currentMode == mode && !isLockedOnce ? "\u2611 " : "") : (currentMode == mode ? "\u2611 " : ""));
        class_5250 baseText = switch (mode) {
            default -> throw new MatchException(null, null);
            case PushdozerConfig.HeightMode.FOLLOW_PLAYER -> class_2561.method_43471((String)"pushdozer.config.height_follow_player");
            case PushdozerConfig.HeightMode.LOCKED_ONCE -> class_2561.method_43471((String)"pushdozer.config.height_locked_once");
            case PushdozerConfig.HeightMode.NO_LIMIT -> class_2561.method_43471((String)"pushdozer.config.height_no_limit");
            case PushdozerConfig.HeightMode.CUSTOM -> class_2561.method_43471((String)"pushdozer.config.height_custom");
        };
        return class_2561.method_43470((String)prefix).method_10852((class_2561)baseText);
    }

    private void initializeTitlePosition() {
        this.titleText = class_2561.method_43471((String)"pushdozer.panel.height_config.title");
        if (this.parent.getClient() != null) {
            int titleWidth = this.parent.getClient().field_1772.method_27525((class_5348)this.titleText);
            this.titleX = this.panelLeft + (250 - titleWidth) / 2;
            Objects.requireNonNull(this.parent.getClient().field_1772);
            this.titleY = this.panelTop + (20 - 9) / 2;
        }
    }

    private void selectHeightMode(PushdozerConfig.HeightMode mode) {
        if (mode == PushdozerConfig.HeightMode.LOCKED_ONCE) {
            if (this.parent.getClient() != null && this.parent.getClient().field_1724 != null) {
                int y = this.parent.getClient().field_1724.method_31478() - 1;
                this.config.setLockedHeight(y);
                this.config.setHeightMode(PushdozerConfig.HeightMode.CUSTOM);
                this.config.setLockedOnceMode(true);
                this.updateButtonStates();
                this.heightSlider.field_22763 = false;
                PushdozerMod.saveConfig();
                this.parent.getClient().field_1724.method_7353((class_2561)class_2561.method_43469((String)"pushdozer.message.height_mode_locked_once", (Object[])new Object[]{y}), true);
            }
        } else {
            this.config.setHeightMode(mode);
            this.config.setLockedOnceMode(false);
            this.updateButtonStates();
            this.heightSlider.field_22763 = mode == PushdozerConfig.HeightMode.CUSTOM;
            PushdozerMod.saveConfig();
            if (this.parent.getClient() != null && this.parent.getClient().field_1724 != null) {
                class_5250 message = switch (mode) {
                    case PushdozerConfig.HeightMode.FOLLOW_PLAYER -> class_2561.method_43471((String)"pushdozer.message.height_mode_follow_player");
                    case PushdozerConfig.HeightMode.NO_LIMIT -> class_2561.method_43471((String)"pushdozer.message.height_mode_no_limit");
                    case PushdozerConfig.HeightMode.CUSTOM -> {
                        int customHeight = this.config.getLockedHeight();
                        yield class_2561.method_43469((String)"pushdozer.message.height_mode_custom", (Object[])new Object[]{customHeight});
                    }
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)mode));
                };
                this.parent.getClient().field_1724.method_7353((class_2561)message, true);
            }
        }
    }

    private void updateButtonStates() {
        this.followPlayerButton.method_25355(this.getButtonText(PushdozerConfig.HeightMode.FOLLOW_PLAYER));
        this.lockOnceButton.method_25355(this.getButtonText(PushdozerConfig.HeightMode.LOCKED_ONCE));
        this.noLimitButton.method_25355(this.getButtonText(PushdozerConfig.HeightMode.NO_LIMIT));
        this.customHeightButton.method_25355(this.getButtonText(PushdozerConfig.HeightMode.CUSTOM));
    }

    public void show() {
        this.visible = true;
        this.panelLeft = (this.parent.getScreenWidth() - 250) / 2;
        this.panelTop = (this.parent.getScreenHeight() - 125) / 2;
        this.initializeWidgets();
        this.initializeTitlePosition();
        this.updateButtonStates();
    }

    public void hide() {
        this.visible = false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        this.renderBackground(context);
        this.renderTitle(context);
        this.renderButtons(context, mouseX, mouseY, delta);
    }

    private void renderBackground(class_332 context) {
        context.method_25294(this.panelLeft, this.panelTop, this.panelLeft + 250, this.panelTop + 125, -1072689136);
        context.method_25294(this.panelLeft, this.panelTop, this.panelLeft + 250, this.panelTop + 20, -533712848);
        context.method_49601(this.panelLeft, this.panelTop, 250, 125, -1);
    }

    private void renderTitle(class_332 context) {
        if (this.titleText != null && this.parent.getClient() != null) {
            context.method_27535(this.parent.getClient().field_1772, this.titleText, this.titleX, this.titleY, 0xFFFFFF);
        }
    }

    private void renderButtons(class_332 context, int mouseX, int mouseY, float delta) {
        for (class_364 widget : this.widgets) {
            if (!(widget instanceof class_4068)) continue;
            ((class_4068)widget).method_25394(context, mouseX, mouseY, delta);
        }
        PushdozerConfig.HeightMode currentMode = this.config.getHeightMode();
        boolean isLockedOnce = this.config.isLockedOnceMode();
        if (currentMode == PushdozerConfig.HeightMode.FOLLOW_PLAYER && this.followPlayerButton != null) {
            context.method_25294(this.followPlayerButton.method_46426(), this.followPlayerButton.method_46427(), this.followPlayerButton.method_46426() + this.followPlayerButton.method_25368(), this.followPlayerButton.method_46427() + this.followPlayerButton.method_25364(), -7829368);
            context.method_25294(this.followPlayerButton.method_46426() + 1, this.followPlayerButton.method_46427() + 1, this.followPlayerButton.method_46426() + this.followPlayerButton.method_25368() - 1, this.followPlayerButton.method_46427() + this.followPlayerButton.method_25364() - 1, -11184811);
        }
        if (isLockedOnce && this.lockOnceButton != null) {
            context.method_25294(this.lockOnceButton.method_46426(), this.lockOnceButton.method_46427(), this.lockOnceButton.method_46426() + this.lockOnceButton.method_25368(), this.lockOnceButton.method_46427() + this.lockOnceButton.method_25364(), -7829368);
            context.method_25294(this.lockOnceButton.method_46426() + 1, this.lockOnceButton.method_46427() + 1, this.lockOnceButton.method_46426() + this.lockOnceButton.method_25368() - 1, this.lockOnceButton.method_46427() + this.lockOnceButton.method_25364() - 1, -11184811);
        }
        if (currentMode == PushdozerConfig.HeightMode.NO_LIMIT && this.noLimitButton != null) {
            context.method_25294(this.noLimitButton.method_46426(), this.noLimitButton.method_46427(), this.noLimitButton.method_46426() + this.noLimitButton.method_25368(), this.noLimitButton.method_46427() + this.noLimitButton.method_25364(), -7829368);
            context.method_25294(this.noLimitButton.method_46426() + 1, this.noLimitButton.method_46427() + 1, this.noLimitButton.method_46426() + this.noLimitButton.method_25368() - 1, this.noLimitButton.method_46427() + this.noLimitButton.method_25364() - 1, -11184811);
        }
        if (currentMode == PushdozerConfig.HeightMode.CUSTOM && !isLockedOnce && this.customHeightButton != null) {
            context.method_25294(this.customHeightButton.method_46426(), this.customHeightButton.method_46427(), this.customHeightButton.method_46426() + this.customHeightButton.method_25368(), this.customHeightButton.method_46427() + this.customHeightButton.method_25364(), -7829368);
            context.method_25294(this.customHeightButton.method_46426() + 1, this.customHeightButton.method_46427() + 1, this.customHeightButton.method_46426() + this.customHeightButton.method_25368() - 1, this.customHeightButton.method_46427() + this.customHeightButton.method_25364() - 1, -11184811);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (class_364 widget : this.widgets) {
            class_339 clickable;
            if (!(widget instanceof class_339) || !(clickable = (class_339)widget).method_25405(mouseX, mouseY)) continue;
            return clickable.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (class_364 widget : this.widgets) {
            class_339 clickable;
            if (!(widget instanceof class_339) || !(clickable = (class_339)widget).method_25405(mouseX, mouseY)) continue;
            return clickable.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (class_364 widget : this.widgets) {
            class_339 clickable;
            if (!(widget instanceof class_339) || !(clickable = (class_339)widget).method_25405(mouseX, mouseY)) continue;
            return clickable.method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    private class HeightConfigSlider
    extends class_357 {
        public HeightConfigSlider(int x, int y, int width, int height, class_2561 text, double value) {
            super(x, y, width, height, text, value);
        }

        protected void method_25346() {
            int height = (int)Math.round(this.field_22753 * 384.0) - 64;
            this.method_25355((class_2561)class_2561.method_43469((String)"pushdozer.config.height_value", (Object[])new Object[]{height}));
        }

        protected void method_25344() {
            int height = (int)Math.round(this.field_22753 * 384.0) - 64;
            HeightConfigPanel.this.config.setLockedHeight(height);
        }
    }
}

