/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.panels.workmode;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.ui.panels.workmode.WorkModeConfigPanel;
import com.pushdozer.ui.screens.MultiSelectPlantSelectionScreen;
import com.pushdozer.ui.screens.PushdozerConfigScreen;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_357;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import net.minecraft.class_7919;

public class BatchPlantConfigPanel
extends WorkModeConfigPanel {
    public BatchPlantConfigPanel(PushdozerConfigScreen parent, PushdozerConfig config) {
        super(parent, config);
    }

    @Override
    protected void initializeWidgets() {
        this.widgets.clear();
        int currentY = this.panelTop + 20 + 5;
        this.addPlantTypeButton(currentY);
        currentY += 25;
        currentY = this.addTypeSpecificOptions(currentY);
        currentY = this.addCommonParameters(currentY);
    }

    private void addPlantTypeButton(int yPos) {
        class_5676 plantTypeButton = class_5676.method_32606(PushdozerConfig.PlantType::getDisplayText).method_32624((Object[])PushdozerConfig.PlantType.values()).method_32619((Object)this.config.getPlantType()).method_32617(this.panelLeft + 5, yPos, 200, 20, (class_2561)class_2561.method_43471((String)"pushdozer.config.plant_type"), (button, type) -> {
            if (this.config.getPlantType() != type) {
                this.config.setPlantType((PushdozerConfig.PlantType)((Object)type));
                this.show();
            }
        });
        this.widgets.add(plantTypeButton);
    }

    private int addTypeSpecificOptions(int yPos) {
        PushdozerConfig.PlantType plantType = this.config.getPlantType();
        if (plantType == null) {
            plantType = PushdozerConfig.PlantType.TREES;
            this.config.setPlantType(plantType);
        }
        switch (plantType) {
            case TREES: {
                class_5676 treeSpeciesButton = class_5676.method_32606(PushdozerConfig.TreeSpecies::getDisplayText).method_32624((Object[])PushdozerConfig.TreeSpecies.values()).method_32619((Object)this.config.getSelectedTree()).method_32617(this.panelLeft + 5, yPos, 200, 20, (class_2561)class_2561.method_43471((String)"pushdozer.config.tree_species"), (btn, species) -> this.config.setSelectedTree((PushdozerConfig.TreeSpecies)((Object)species)));
                this.widgets.add(treeSpeciesButton);
                yPos += 25;
                break;
            }
            case FLOWERS: {
                class_5676 flowerGroupButton = class_5676.method_32606(PushdozerConfig.FlowerGroup::getDisplayText).method_32624((Object[])PushdozerConfig.FlowerGroup.values()).method_32619((Object)this.config.getSelectedFlowerGroup()).method_32617(this.panelLeft + 5, yPos, 200, 20, (class_2561)class_2561.method_43471((String)"pushdozer.config.flower_group"), (btn, group) -> this.config.setSelectedFlowerGroup((PushdozerConfig.FlowerGroup)((Object)group)));
                this.widgets.add(flowerGroupButton);
                yPos += 25;
                break;
            }
            case GRASS: {
                break;
            }
            case CUSTOM: {
                class_4185 selectPlantsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.config.select_plant_types"), button -> this.openPlantSelectionScreen()).method_46434(this.panelLeft + 5, yPos, 200, 20).method_46431();
                selectPlantsButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.select_plant_types")));
                this.widgets.add(selectPlantsButton);
                yPos += 25;
            }
        }
        return yPos;
    }

    private void openPlantSelectionScreen() {
        List<class_2248> currentlySelected = this.config.getCustomPlantBlocks();
        MultiSelectPlantSelectionScreen plantScreen = new MultiSelectPlantSelectionScreen(this.parent, this::onPlantsSelected, currentlySelected);
        if (this.parent.getClient() != null) {
            this.parent.getClient().method_1507((class_437)plantScreen);
        }
    }

    private void onPlantsSelected(List<class_2248> selectedBlocks) {
        this.config.setCustomPlantBlocks(selectedBlocks);
        this.show();
    }

    private int addCommonParameters(int yPos) {
        CustomSlider densitySlider = new CustomSlider(this.panelLeft + 5, yPos, 200, 20, "pushdozer.config.plant_density", this.config.getPlantDensity(), this.config::setPlantDensity);
        densitySlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.config.plant_density.tooltip")));
        this.widgets.add(densitySlider);
        CustomSlider clusterSlider = new CustomSlider(this.panelLeft + 5, yPos += 25, 200, 20, "pushdozer.config.cluster_scale", this.config.getClusterScale(), this.config::setClusterScale);
        clusterSlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.config.cluster_scale.tooltip")));
        this.widgets.add(clusterSlider);
        return yPos += 25;
    }

    @Override
    protected class_2561 getTitleText() {
        return class_2561.method_43471((String)"pushdozer.panel.batch_plant.title");
    }

    @Override
    public void saveConfig() {
    }

    private static class CustomSlider
    extends class_357 {
        private final Consumer<Float> onValueChanged;
        private final String key;

        public CustomSlider(int x, int y, int width, int height, String key, float value, Consumer<Float> onValueChanged) {
            super(x, y, width, height, (class_2561)class_2561.method_43471((String)key), (double)value);
            this.onValueChanged = onValueChanged;
            this.key = key;
            this.method_25346();
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43469((String)(this.key + ".value"), (Object[])new Object[]{String.format("%d", (int)(this.field_22753 * 100.0))}));
        }

        protected void method_25344() {
            this.onValueChanged.accept(Float.valueOf((float)this.field_22753));
        }
    }
}

