/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.panels.workmode;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.ui.panels.workmode.WorkModeConfigPanel;
import com.pushdozer.ui.screens.NaturalBlockSelectionScreen;
import com.pushdozer.ui.screens.PushdozerConfigScreen;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import net.minecraft.class_7923;

public class PlaceConfigPanel
extends WorkModeConfigPanel {
    private class_4185 adaptiveBiomeButton;
    private class_4185 naturalBlockButton;

    public PlaceConfigPanel(PushdozerConfigScreen parent, PushdozerConfig config) {
        super(parent, config);
    }

    @Override
    protected class_2561 getTitleText() {
        return class_2561.method_43471((String)"pushdozer.mode.place");
    }

    @Override
    protected void initializeWidgets() {
        this.widgets.clear();
        int contentLeft = this.panelLeft + 5;
        int contentTop = this.panelTop + 20 + 5;
        int contentWidth = 200;
        this.adaptiveBiomeButton = class_4185.method_46430((class_2561)this.getButtonText(), button -> this.selectPlaceMode()).method_46434(contentLeft, contentTop, contentWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.place_mode"))).method_46431();
        this.widgets.add(this.adaptiveBiomeButton);
        this.naturalBlockButton = class_4185.method_46430((class_2561)this.getNaturalBlockButtonText(), button -> this.openNaturalBlockSelection()).method_46434(contentLeft, contentTop + 20 + 5, contentWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.terrain_block_selection"))).method_46431();
        this.widgets.add(this.naturalBlockButton);
        this.updateButtonStates();
    }

    private void selectPlaceMode() {
        this.config.setPlaceMode(PushdozerConfig.PlaceMode.ADAPTIVE_BIOME);
        this.updateButtonStates();
    }

    private void openNaturalBlockSelection() {
        this.config.setPlaceMode(PushdozerConfig.PlaceMode.NATURAL_BLOCK);
        NaturalBlockSelectionScreen selectionScreen = new NaturalBlockSelectionScreen(this.parent, this::onNaturalBlockSelected);
        if (this.parent.getClient() != null) {
            this.parent.getClient().method_1507((class_437)selectionScreen);
        }
    }

    private void onNaturalBlockSelected(class_2248 selectedBlock) {
        String blockId = class_7923.field_41175.method_10221((Object)selectedBlock).toString();
        this.config.setSelectedNaturalBlockId(blockId);
        this.updateButtonStates();
    }

    private class_2561 getButtonText() {
        String prefix = this.config.getPlaceMode() == PushdozerConfig.PlaceMode.ADAPTIVE_BIOME ? "\u2611 " : "";
        return class_2561.method_43470((String)prefix).method_10852(PushdozerConfig.PlaceMode.ADAPTIVE_BIOME.getDisplayText());
    }

    private class_2561 getNaturalBlockButtonText() {
        String prefix = this.config.getPlaceMode() == PushdozerConfig.PlaceMode.NATURAL_BLOCK ? "\u2611 " : "";
        Object buttonText = class_2561.method_43471((String)"pushdozer.place_mode.natural_block").getString();
        if (this.config.getPlaceMode() == PushdozerConfig.PlaceMode.NATURAL_BLOCK) {
            class_2248 selectedBlock = this.config.getSelectedNaturalBlock();
            String blockName = class_2561.method_43471((String)selectedBlock.method_9539()).getString();
            buttonText = (String)buttonText + ": " + blockName;
        }
        return class_2561.method_43470((String)(prefix + (String)buttonText));
    }

    private void updateButtonStates() {
        if (this.adaptiveBiomeButton != null) {
            this.adaptiveBiomeButton.method_25355(this.getButtonText());
        }
        if (this.naturalBlockButton != null) {
            this.naturalBlockButton.method_25355(this.getNaturalBlockButtonText());
        }
    }

    @Override
    protected void renderWidgets(class_332 context, int mouseX, int mouseY, float delta) {
        PushdozerConfig.PlaceMode currentMode = this.config.getPlaceMode();
        if (currentMode == PushdozerConfig.PlaceMode.ADAPTIVE_BIOME && this.adaptiveBiomeButton != null) {
            context.method_25294(this.adaptiveBiomeButton.method_46426(), this.adaptiveBiomeButton.method_46427(), this.adaptiveBiomeButton.method_46426() + this.adaptiveBiomeButton.method_25368(), this.adaptiveBiomeButton.method_46427() + this.adaptiveBiomeButton.method_25364(), -7829368);
            context.method_25294(this.adaptiveBiomeButton.method_46426() + 1, this.adaptiveBiomeButton.method_46427() + 1, this.adaptiveBiomeButton.method_46426() + this.adaptiveBiomeButton.method_25368() - 1, this.adaptiveBiomeButton.method_46427() + this.adaptiveBiomeButton.method_25364() - 1, -11184811);
        }
        if (currentMode == PushdozerConfig.PlaceMode.NATURAL_BLOCK && this.naturalBlockButton != null) {
            context.method_25294(this.naturalBlockButton.method_46426(), this.naturalBlockButton.method_46427(), this.naturalBlockButton.method_46426() + this.naturalBlockButton.method_25368(), this.naturalBlockButton.method_46427() + this.naturalBlockButton.method_25364(), -7829368);
            context.method_25294(this.naturalBlockButton.method_46426() + 1, this.naturalBlockButton.method_46427() + 1, this.naturalBlockButton.method_46426() + this.naturalBlockButton.method_25368() - 1, this.naturalBlockButton.method_46427() + this.naturalBlockButton.method_25364() - 1, -11184811);
        }
        super.renderWidgets(context, mouseX, mouseY, delta);
    }

    @Override
    public void saveConfig() {
        try {
            this.config.save();
            this.parent.showErrorMessage(class_2561.method_43471((String)"pushdozer.config.saved").getString());
        }
        catch (Exception e) {
            this.parent.showErrorMessage(class_2561.method_43471((String)"pushdozer.config.save_failed").getString());
            e.printStackTrace();
        }
    }
}

