/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.panels.brushgeometry;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.ui.screens.PushdozerConfigScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_5348;

public class GeometrySelectionPanel {
    private static final int COLOR_PANEL_BG = -1072689136;
    private static final int COLOR_PANEL_BORDER = -1;
    private static final int COLOR_TITLE_BG = -533712848;
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final int PANEL_WIDTH = 210;
    private static final int PANEL_HEIGHT = 125;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_MARGIN = 5;
    private static final int TITLE_HEIGHT = 20;
    private final PushdozerConfigScreen parent;
    private final PushdozerConfig config;
    private final Consumer<PushdozerConfig.GeometryType> onSelectionChanged;
    private final List<class_364> widgets = new ArrayList<class_364>();
    private boolean visible = false;
    private int panelLeft;
    private int panelTop;
    private int titleX;
    private int titleY;
    private class_2561 titleText;

    public GeometrySelectionPanel(PushdozerConfigScreen parent, PushdozerConfig config, Consumer<PushdozerConfig.GeometryType> onSelectionChanged) {
        this.parent = parent;
        this.config = config;
        this.onSelectionChanged = onSelectionChanged;
        this.panelLeft = (parent.getScreenWidth() - 210) / 2;
        this.panelTop = (parent.getScreenHeight() - 125) / 2;
        this.initializeWidgets();
        this.initializeTitlePosition();
    }

    private void initializeWidgets() {
        this.widgets.clear();
        int startY = this.panelTop + 20 + 5;
        PushdozerConfig.GeometryType[] types = PushdozerConfig.GeometryType.values();
        int buttonWidth = 97;
        for (int i = 0; i < types.length; ++i) {
            PushdozerConfig.GeometryType type = types[i];
            int row = i / 2;
            int col = i % 2;
            int buttonX = this.panelLeft + 5 + col * (buttonWidth + 5);
            int buttonY = startY + row * 25;
            class_4185 button = class_4185.method_46430((class_2561)this.getButtonText(type), btn -> this.selectGeometry(type)).method_46434(buttonX, buttonY, buttonWidth, 20).method_46431();
            this.widgets.add((class_364)button);
        }
    }

    private class_2561 getButtonText(PushdozerConfig.GeometryType type) {
        String prefix = this.config.getGeometryType() == type ? "\u2611 " : "";
        return class_2561.method_43470((String)prefix).method_10852(type.getDisplayText());
    }

    private void updateButtonStates() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            class_364 widget = this.widgets.get(i);
            if (!(widget instanceof class_4185)) continue;
            class_4185 button = (class_4185)widget;
            PushdozerConfig.GeometryType type = PushdozerConfig.GeometryType.values()[i];
            button.method_25355(this.getButtonText(type));
        }
    }

    private void initializeTitlePosition() {
        this.titleText = class_2561.method_43471((String)"pushdozer.panel.brush_shape_selection.title");
        if (this.parent.getClient() != null) {
            int titleWidth = this.parent.getClient().field_1772.method_27525((class_5348)this.titleText);
            this.titleX = this.panelLeft + (210 - titleWidth) / 2;
            Objects.requireNonNull(this.parent.getClient().field_1772);
            this.titleY = this.panelTop + (20 - 9) / 2;
        }
    }

    private void selectGeometry(PushdozerConfig.GeometryType type) {
        this.config.setGeometryType(type);
        this.updateButtonStates();
        if (this.onSelectionChanged != null) {
            this.onSelectionChanged.accept(type);
        }
        this.hide();
    }

    public void show() {
        this.visible = true;
        this.panelLeft = (this.parent.getScreenWidth() - 210) / 2;
        this.panelTop = (this.parent.getScreenHeight() - 125) / 2;
        this.initializeWidgets();
        this.initializeTitlePosition();
        this.updateButtonStates();
    }

    public void hide() {
        this.visible = false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        this.renderBackground(context);
        this.renderTitle(context);
        this.renderButtons(context, mouseX, mouseY, delta);
    }

    private void renderBackground(class_332 context) {
        context.method_25294(this.panelLeft, this.panelTop, this.panelLeft + 210, this.panelTop + 125, -1072689136);
        context.method_25294(this.panelLeft, this.panelTop, this.panelLeft + 210, this.panelTop + 20, -533712848);
        context.method_49601(this.panelLeft, this.panelTop, 210, 125, -1);
    }

    private void renderTitle(class_332 context) {
        if (this.parent.getClient() != null) {
            context.method_51439(this.parent.getClient().field_1772, this.titleText, this.titleX, this.titleY, 0xFFFFFF, false);
        }
    }

    private void renderButtons(class_332 context, int mouseX, int mouseY, float delta) {
        for (class_364 widget : this.widgets) {
            if (!(widget instanceof class_4068)) continue;
            ((class_4068)widget).method_25394(context, mouseX, mouseY, delta);
        }
        PushdozerConfig.GeometryType currentType = this.config.getGeometryType();
        for (class_364 widget : this.widgets) {
            if (!(widget instanceof class_4185)) continue;
            class_4185 button = (class_4185)widget;
            boolean isSelected = false;
            for (PushdozerConfig.GeometryType type : PushdozerConfig.GeometryType.values()) {
                if (!type.getDisplayText().equals((Object)button.method_25369().getString()) && !("\u2611 " + type.getDisplayText().getString()).equals(button.method_25369().getString())) continue;
                isSelected = type == currentType;
                break;
            }
            if (!isSelected) continue;
            context.method_25294(button.method_46426(), button.method_46427(), button.method_46426() + button.method_25368(), button.method_46427() + button.method_25364(), -7829368);
            context.method_25294(button.method_46426() + 1, button.method_46427() + 1, button.method_46426() + button.method_25368() - 1, button.method_46427() + button.method_25364() - 1, -11184811);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        if (mouseX < (double)this.panelLeft || mouseX > (double)(this.panelLeft + 210) || mouseY < (double)this.panelTop || mouseY > (double)(this.panelTop + 125)) {
            this.hide();
            return true;
        }
        this.handleMouseEvent(clickable -> clickable.method_25402(mouseX, mouseY, button));
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.visible) {
            return false;
        }
        return this.handleMouseEvent(clickable -> clickable.method_25403(mouseX, mouseY, button, deltaX, deltaY));
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        return this.handleMouseEvent(clickable -> clickable.method_25406(mouseX, mouseY, button));
    }

    private boolean handleMouseEvent(Function<class_339, Boolean> eventHandler) {
        for (class_364 widget : this.widgets) {
            class_339 clickable;
            if (!(widget instanceof class_339) || !eventHandler.apply(clickable = (class_339)widget).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

