/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.panels.workmode;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.ui.screens.PushdozerConfigScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_5348;

public abstract class WorkModeConfigPanel {
    protected static final int COLOR_PANEL_BG = -1072689136;
    protected static final int COLOR_PANEL_BORDER = -1;
    protected static final int COLOR_TITLE_BG = -533712848;
    protected static final int COLOR_WHITE = 0xFFFFFF;
    protected static final int PANEL_WIDTH = 210;
    protected static final int PANEL_HEIGHT = 140;
    protected static final int TITLE_HEIGHT = 20;
    protected static final int WIDGET_HEIGHT = 20;
    protected static final int WIDGET_MARGIN = 5;
    protected static final int CONFIRM_BUTTON_HEIGHT = 20;
    protected static final int CONFIRM_BUTTON_MARGIN = 5;
    protected final PushdozerConfigScreen parent;
    protected final PushdozerConfig config;
    protected final List<class_364> widgets = new ArrayList<class_364>();
    protected class_4185 confirmButton;
    protected boolean visible = false;
    protected int panelLeft;
    protected int panelTop;
    protected int titleX;
    protected int titleY;
    protected class_2561 titleText;

    public WorkModeConfigPanel(PushdozerConfigScreen parent, PushdozerConfig config) {
        this.parent = parent;
        this.config = config;
        this.panelLeft = (parent.getScreenWidth() - 210) / 2;
        this.panelTop = (parent.getScreenHeight() - 140) / 2;
        this.initializeTitlePosition();
        this.initializeWidgets();
        this.initializeConfirmButton();
        this.panelTop = (parent.getScreenHeight() - this.getPanelHeight()) / 2;
        this.recalculateAllWidgetPositions();
    }

    protected void recalculateWidgetPositions() {
    }

    protected abstract void initializeWidgets();

    protected abstract class_2561 getTitleText();

    protected int getPanelHeight() {
        int confirmButtonY = this.calculateConfirmButtonY();
        return confirmButtonY + 20 + 5 - this.panelTop;
    }

    protected int calculateConfirmButtonY() {
        int contentWidgetCount = this.widgets.size();
        if (this.confirmButton != null && this.widgets.contains(this.confirmButton)) {
            contentWidgetCount = this.widgets.size() - 1;
        }
        if (contentWidgetCount > 0) {
            int lastWidgetY = this.panelTop + 20 + 5 + (contentWidgetCount - 1) * 25 + 20;
            return lastWidgetY + 5;
        }
        return this.panelTop + 20 + 5 + 5;
    }

    protected int calculateContentHeight() {
        int widgetCount = this.widgets.size() - 1;
        if (widgetCount <= 0) {
            return 10;
        }
        return widgetCount * 20 + (widgetCount - 1) * 5 + 5 + 5;
    }

    protected void initializeConfirmButton() {
        int confirmButtonY = this.calculateConfirmButtonY();
        this.confirmButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.button.done"), button -> {
            this.saveConfig();
            this.closeSubPanel();
        }).method_46434(this.panelLeft + 5, confirmButtonY, 200, 20).method_46431();
        this.widgets.add((class_364)this.confirmButton);
    }

    public abstract void saveConfig();

    protected void closeSubPanel() {
        this.hide();
        this.parent.showMainPanel();
    }

    protected void initializeTitlePosition() {
        this.titleText = this.getTitleText();
        if (this.parent.getClient() != null) {
            int titleWidth = this.parent.getClient().field_1772.method_27525((class_5348)this.titleText);
            this.titleX = this.panelLeft + (210 - titleWidth) / 2;
            Objects.requireNonNull(this.parent.getClient().field_1772);
            this.titleY = this.panelTop + (20 - 9) / 2;
        }
    }

    public void show() {
        this.visible = true;
        this.panelLeft = (this.parent.getScreenWidth() - 210) / 2;
        this.widgets.clear();
        this.confirmButton = null;
        this.initializeWidgets();
        this.initializeConfirmButton();
        this.panelTop = (this.parent.getScreenHeight() - this.getPanelHeight()) / 2;
        this.recalculateAllWidgetPositions();
    }

    protected void recalculateAllWidgetPositions() {
        this.initializeTitlePosition();
        if (this.confirmButton != null) {
            int confirmButtonY = this.calculateConfirmButtonY();
            int confirmButtonX = this.panelLeft + 5;
            int confirmButtonWidth = 200;
            this.confirmButton.method_48229(confirmButtonX, confirmButtonY);
            this.confirmButton.method_25358(confirmButtonWidth);
        }
        this.recalculateContentWidgetPositions();
    }

    protected void recalculateContentWidgetPositions() {
        int currentY = this.panelTop + 20 + 5;
        for (class_364 widget : this.widgets) {
            if (widget == this.confirmButton || !(widget instanceof class_339)) continue;
            class_339 clickableWidget = (class_339)widget;
            clickableWidget.method_48229(clickableWidget.method_46426(), currentY);
            currentY += 25;
        }
    }

    public void hide() {
        this.visible = false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        this.renderBackground(context);
        this.renderTitle(context);
        this.renderWidgets(context, mouseX, mouseY, delta);
    }

    protected void renderBackground(class_332 context) {
        context.method_25294(this.panelLeft, this.panelTop, this.panelLeft + 210, this.panelTop + this.getPanelHeight(), -1072689136);
        context.method_25294(this.panelLeft, this.panelTop, this.panelLeft + 210, this.panelTop + 20, -533712848);
        context.method_49601(this.panelLeft, this.panelTop, 210, this.getPanelHeight(), -1);
    }

    protected void renderTitle(class_332 context) {
        if (this.parent.getClient() != null && this.titleText != null) {
            context.method_51439(this.parent.getClient().field_1772, this.titleText, this.titleX, this.titleY, 0xFFFFFF, false);
        }
    }

    protected void renderWidgets(class_332 context, int mouseX, int mouseY, float delta) {
        for (class_364 widget : this.widgets) {
            if (!(widget instanceof class_4068)) continue;
            ((class_4068)widget).method_25394(context, mouseX, mouseY, delta);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        if (mouseX >= (double)this.panelLeft && mouseX <= (double)(this.panelLeft + 210) && mouseY >= (double)this.panelTop && mouseY <= (double)(this.panelTop + this.getPanelHeight())) {
            for (class_364 widget : this.widgets) {
                class_339 clickableWidget;
                if (!(widget instanceof class_339) || !(clickableWidget = (class_339)widget).method_25402(mouseX, mouseY, button)) continue;
                return true;
            }
            return true;
        }
        this.hide();
        this.parent.showMainPanel();
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.visible) {
            return false;
        }
        for (class_364 widget : this.widgets) {
            class_339 clickableWidget;
            if (!(widget instanceof class_339) || !(clickableWidget = (class_339)widget).method_25405(mouseX, mouseY) || !clickableWidget.method_25403(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        for (class_364 widget : this.widgets) {
            class_339 clickableWidget;
            if (!(widget instanceof class_339) || !(clickableWidget = (class_339)widget).method_25405(mouseX, mouseY) || !clickableWidget.method_25406(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public List<class_364> getWidgets() {
        return this.widgets;
    }

    protected class_357 createSlider(int x, int y, int width, class_2561 message, double value, final SliderApplyValue applyValue) {
        return new class_357(this, x, y, width, 20, message, value){

            protected void method_25346() {
            }

            protected void method_25344() {
                applyValue.apply(this);
            }
        };
    }

    @FunctionalInterface
    protected static interface SliderApplyValue {
        public void apply(class_357 var1);
    }
}

