/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.screens;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3481;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class NaturalBlockSelectionScreen
extends class_437 {
    private final class_437 parent;
    private final Consumer<class_2248> onBlockSelected;
    private List<BlockCategory> blockCategories;
    private class_2248 selectedBlock = null;
    private static List<BlockCategory> cachedCategories = null;
    private static Map<class_2248, String> globalSearchStrings = new HashMap<class_2248, String>();
    private int currentPage = 0;
    private String searchText = "";
    private class_342 searchBox;
    private static final int BLOCKS_PER_ROW = 4;
    private static final int BLOCK_SIZE = 20;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_SPACING = 10;
    private static final int CATEGORIES_PER_PAGE = 4;
    private static final int CATEGORY_BUTTON_HEIGHT = 20;
    private static final int TOP_MARGIN = 35;
    private static final int BOTTOM_MARGIN = 10;
    private static final int SEARCH_BOTTOM_SPACING = 5;
    private static final int PAGE_NUMBER_SPACING = 10;
    private static final int PANEL_BACKGROUND_COLOR = 0x40000000;
    private static final int BLOCK_BORDER_COLOR = -7631989;
    private static final int BLOCK_BACKGROUND_COLOR = -13158601;
    private static final int BLOCK_HOVER_COLOR = -11184811;
    private static final int SCROLL_BAR_BACKGROUND_COLOR = 0x33FFFFFF;
    private static final int SCROLL_BAR_COLOR = -5592406;
    private static final int SCROLL_BAR_HIGHLIGHT_COLOR = -1;
    private static final int SCROLL_BAR_SHADOW_COLOR = -11184811;
    private static final int SELECTED_BLOCK_BORDER_COLOR = -1;

    public NaturalBlockSelectionScreen(class_437 parent, Consumer<class_2248> onBlockSelected) {
        super((class_2561)class_2561.method_43471((String)"pushdozer.screen.terrain_block_selection.title"));
        this.parent = parent;
        this.onBlockSelected = onBlockSelected;
        this.blockCategories = this.getAllRelevantBlocks();
    }

    protected void method_25426() {
        super.method_25426();
        this.addSearchAndButtons(false);
        this.refreshCategoryButtons();
    }

    public void method_25393() {
        super.method_25393();
    }

    private void addSearchAndButtons(boolean restoreFocus) {
        int totalWidth = 170;
        int startX = (this.field_22789 - totalWidth) / 2;
        int buttonY = this.field_22790 - 20 - 10;
        int searchBoxY = buttonY - 20 - 5;
        this.searchBox = new class_342(this.field_22793, startX, searchBoxY, totalWidth, 20, (class_2561)class_2561.method_43471((String)"pushdozer.screen.terrain_block_selection.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(true);
        this.searchBox.method_1862(true);
        this.searchBox.method_1888(true);
        this.searchBox.method_1852(this.searchText);
        this.searchBox.method_25365(restoreFocus);
        this.searchBox.method_1863(this::onSearchTextChanged);
        this.method_37063((class_364)this.searchBox);
        this.addPageButtons();
        this.addSelectionButtons();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean result = super.method_25402(mouseX, mouseY, button);
        if (this.searchBox != null) {
            if (this.searchBox.method_25405(mouseX, mouseY)) {
                this.searchBox.method_25365(true);
                return true;
            }
            this.searchBox.method_25365(false);
        }
        return result;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.method_25370()) {
            if (keyCode == 256) {
                this.searchBox.method_25365(false);
                return true;
            }
            if (keyCode == 257) {
                this.focusOnMatch();
                return true;
            }
            if (this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.searchBox != null && this.searchBox.method_25370() && this.searchBox.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    private void focusOnMatch() {
        if (this.searchText.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.blockCategories.size(); ++i) {
            BlockCategory category = this.blockCategories.get(i);
            for (int j = 0; j < category.blocks.size(); ++j) {
                class_2248 block = category.blocks.get(j);
                String blockName = class_2561.method_43471((String)block.method_63499()).getString().toLowerCase();
                String blockId = class_7923.field_41175.method_10221((Object)block).method_12832().toLowerCase();
                if (!blockName.contains(this.searchText.toLowerCase()) && !blockId.contains(this.searchText.toLowerCase())) continue;
                int targetPage = i / 4;
                if (this.currentPage != targetPage) {
                    this.currentPage = targetPage;
                    this.refreshCategoryButtons();
                }
                this.scrollToBlock(block, j);
                return;
            }
        }
    }

    private void scrollToBlock(class_2248 targetBlock, int blockIndex) {
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof ScrollablePanel)) continue;
            ScrollablePanel panel = (ScrollablePanel)child;
            if (!panel.blocks.contains(targetBlock)) continue;
            int row = blockIndex / 4;
            int targetScrollOffset = row * 24;
            int maxScroll = Math.max(0, (panel.blocks.size() + 4 - 1) / 4 - panel.getVisibleRows()) * 24;
            panel.scrollOffset = Math.max(0, Math.min(targetScrollOffset, maxScroll));
            break;
        }
    }

    private void onSearchTextChanged(String text) {
        if (!text.equals(this.searchText)) {
            this.searchText = text;
            this.refreshCategoryButtons();
        }
    }

    private boolean matchesSearch(class_2248 block) {
        if (this.searchText.isEmpty()) {
            return true;
        }
        String searchLower = this.searchText.toLowerCase();
        String searchString = globalSearchStrings.get(block);
        if (searchString != null) {
            return searchString.contains(searchLower);
        }
        String blockName = class_2561.method_43471((String)block.method_63499()).getString().toLowerCase();
        String blockId = class_7923.field_41175.method_10221((Object)block).method_12832().toLowerCase();
        return blockName.contains(searchLower) || blockId.contains(searchLower);
    }

    private void addPageButtons() {
        this.method_37063((class_364)new PageButtonWidget(10, this.field_22790 / 2, 20, 20, (class_2561)class_2561.method_43470((String)"<"), button -> this.changePage(-1), (class_2561)class_2561.method_43471((String)"pushdozer.screen.terrain_block_selection.previous_page")));
        this.method_37063((class_364)new PageButtonWidget(this.field_22789 - 30, this.field_22790 / 2, 20, 20, (class_2561)class_2561.method_43470((String)">"), button -> this.changePage(1), (class_2561)class_2561.method_43471((String)"pushdozer.screen.terrain_block_selection.next_page")));
    }

    private void changePage(int delta) {
        int totalPages = (this.blockCategories.size() - 1) / 4 + 1;
        this.currentPage += delta;
        if (this.currentPage < 0) {
            this.currentPage = totalPages - 1;
        } else if (this.currentPage >= totalPages) {
            this.currentPage = 0;
        }
        this.refreshCategoryButtons();
    }

    private void refreshCategoryButtons() {
        boolean wasFocused = this.searchBox != null && this.searchBox.method_25370();
        this.method_37067();
        this.addSearchAndButtons(wasFocused);
        int categorySpacing = 8;
        int blockSpacing = 4;
        int categoryToBlockSpacing = 10;
        int scrollBarWidth = 4;
        int categoryWidth = 80 + blockSpacing * 3 + scrollBarWidth;
        int totalWidth2 = 4 * categoryWidth + 3 * categorySpacing;
        int startX2 = (this.field_22789 - totalWidth2) / 2;
        int startY = 35;
        int startIndex = this.currentPage * 4;
        for (int i = 0; i < 4 && startIndex + i < this.blockCategories.size(); ++i) {
            BlockCategory category = this.blockCategories.get(startIndex + i);
            int columnX = startX2 + i * (categoryWidth + categorySpacing);
            List<class_2248> filteredBlocks = category.blocks.stream().filter(this::matchesSearch).collect(Collectors.toList());
            class_5250 categoryText = class_2561.method_43470((String)(category.getTranslatedName().getString() + " (" + filteredBlocks.size() + ")"));
            this.method_37063((class_364)class_4185.method_46430((class_2561)categoryText, button -> this.toggleCategorySelection(category)).method_46434(columnX, startY, categoryWidth, 20).method_46431());
            int bottomSpace = 65;
            int panelHeight = this.field_22790 - startY - 20 - categoryToBlockSpacing - bottomSpace + 2;
            ScrollablePanel scrollPanel = new ScrollablePanel(columnX, startY + 20 + categoryToBlockSpacing, categoryWidth, panelHeight, filteredBlocks);
            this.method_37063((class_364)scrollPanel);
        }
    }

    private void addSelectionButtons() {
        int y = this.field_22790 - 20 - 10;
        int totalWidth = 170;
        int startX = (this.field_22789 - totalWidth) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.ok"), button -> this.onConfirm()).method_46434(startX, y, 80, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> this.method_25419()).method_46434(startX + 80 + 10, y, 80, 20).method_46431());
    }

    private String getPageText() {
        int totalPages = (this.blockCategories.size() - 1) / 4 + 1;
        return String.format("%d/%d", this.currentPage + 1, totalPages);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        if (this.selectedBlock != null) {
            String selectedBlockName = class_2561.method_43471((String)this.selectedBlock.method_63499()).getString();
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)("\u9009\u4e2d: " + selectedBlockName)), this.field_22789 / 2, 25, 0xFFFFFF);
        }
        String pageText = this.getPageText();
        int searchBoxY = this.field_22790 - 20 - 10 - 20 - 5;
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)pageText), this.field_22789 / 2, searchBoxY - 10, 0xFFFFFF);
    }

    private void toggleBlockSelection(class_2248 block) {
        this.selectedBlock = this.selectedBlock == block ? null : block;
    }

    private void toggleCategorySelection(BlockCategory category) {
        if (category.blocks.contains(this.selectedBlock)) {
            this.selectedBlock = null;
        } else if (!category.blocks.isEmpty()) {
            this.selectedBlock = category.blocks.getFirst();
        }
        this.refreshCategoryButtons();
    }

    private void onConfirm() {
        if (this.selectedBlock != null) {
            this.onBlockSelected.accept(this.selectedBlock);
        }
        this.method_25419();
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private List<BlockCategory> getAllRelevantBlocks() {
        cachedCategories = null;
        System.out.println("\u6b63\u5728\u91cd\u5efa\u5730\u5f62\u65b9\u5757\u5206\u7c7b\u7f13\u5b58...");
        LinkedHashMap<String, BlockCategory> categoryMap = new LinkedHashMap<String, BlockCategory>();
        HashSet<String> processedBlockIds = new HashSet<String>();
        for (class_2248 block : class_7923.field_41175) {
            String blockId = class_7923.field_41175.method_10221((Object)block).toString();
            String blockIdPath = class_7923.field_41175.method_10221((Object)block).method_12832().toLowerCase();
            if (processedBlockIds.contains(blockId)) continue;
            processedBlockIds.add(blockId);
            List<String> categoryKeys = this.getCategoriesForBlock(block);
            for (String categoryKey : categoryKeys) {
                BlockCategory category = categoryMap.computeIfAbsent(categoryKey, key -> new BlockCategory((String)key, this.getCategoryPriority((String)key)));
                category.addBlock(block);
            }
        }
        cachedCategories = new ArrayList(categoryMap.values());
        cachedCategories.sort(Comparator.comparingInt(BlockCategory::getPriority));
        for (BlockCategory category : cachedCategories) {
            category.blocks.sort(Comparator.comparing(b -> class_7923.field_41175.method_10221(b).method_12832()));
        }
        System.out.println("\u5730\u5f62\u65b9\u5757\u5206\u7c7b\u5b8c\u6210\uff0c\u5171 " + cachedCategories.size() + " \u4e2a\u5206\u7c7b\uff1a");
        for (BlockCategory category : cachedCategories) {
            System.out.println("  " + category.getTranslatedName().getString() + ": " + category.blocks.size() + " \u4e2a\u65b9\u5757");
            if (!category.translationKey.equals("pushdozer.category.leaves")) continue;
            System.out.println("    \u6811\u53f6\u5206\u7c7b\u4e2d\u7684\u65b9\u5757\uff1a");
            for (class_2248 block : category.blocks) {
                String blockId = class_7923.field_41175.method_10221((Object)block).method_12832();
                System.out.println("      - " + blockId);
            }
            boolean hasCherryLeaves = category.blocks.stream().anyMatch(b -> class_7923.field_41175.method_10221(b).method_12832().equals("cherry_leaves"));
            boolean hasFloweringAzaleaLeaves = category.blocks.stream().anyMatch(b -> class_7923.field_41175.method_10221(b).method_12832().equals("flowering_azalea_leaves"));
            System.out.println("    \u68c0\u67e5\u7ed3\u679c\uff1a");
            System.out.println("      cherry_leaves: " + (hasCherryLeaves ? "\u2705 \u5df2\u5305\u542b" : "\u274c \u672a\u5305\u542b"));
            System.out.println("      flowering_azalea_leaves: " + (hasFloweringAzaleaLeaves ? "\u2705 \u5df2\u5305\u542b" : "\u274c \u672a\u5305\u542b"));
        }
        return cachedCategories;
    }

    private int getCategoryPriority(String categoryKey) {
        return switch (categoryKey) {
            case "pushdozer.category.terrain" -> 1;
            case "pushdozer.category.ice_snow" -> 2;
            case "pushdozer.category.ores" -> 3;
            case "pushdozer.category.copper" -> 4;
            case "pushdozer.category.wood" -> 5;
            case "pushdozer.category.leaves" -> 6;
            case "pushdozer.category.biological" -> 7;
            case "pushdozer.category.stairs_slabs" -> 8;
            case "pushdozer.category.dyed" -> 9;
            case "pushdozer.category.functional" -> 10;
            case "pushdozer.category.glowing" -> 11;
            case "pushdozer.category.decorative" -> 12;
            case "pushdozer.category.redstone" -> 13;
            case "pushdozer.category.fluid" -> 14;
            case "pushdozer.category.miscellaneous" -> 15;
            default -> 100;
        };
    }

    private List<String> getCategoriesForBlock(class_2248 block) {
        ArrayList<String> categories = new ArrayList<String>();
        String blockId = class_7923.field_41175.method_10221((Object)block).method_12832().toLowerCase();
        if (blockId.equals("water") || blockId.equals("lava")) {
            categories.add("pushdozer.category.fluid");
            return categories;
        }
        class_2680 defaultState = block.method_9564();
        if (defaultState.method_26215()) {
            return categories;
        }
        if (block.method_36555() < 0.0f && !blockId.equals("obsidian") && !blockId.equals("bedrock")) {
            return categories;
        }
        if (blockId.contains("sign") || blockId.contains("button") || blockId.contains("pressure_plate") || blockId.contains("lever")) {
            return categories;
        }
        try {
            if ((block.method_9564().method_26164(class_3481.field_20339) || block.method_9564().method_26164(class_3481.field_20341) || block.method_9564().method_26164(class_3481.field_15462) || block.method_9564().method_26164(class_3481.field_44471) || block.method_9564().method_26164(class_3481.field_16443) || block.method_9564().method_26164(class_3481.field_15501) || block.method_9564().method_26164(class_3481.field_15481) || block.method_9564().method_26164(class_3481.field_26983) || block.method_9564().method_26164(class_3481.field_23799) || block.method_9564().method_26164(class_3481.field_22414) || block.method_9564().method_26164(class_3481.field_15483) || block.method_9564().method_26164(class_3481.field_15495) || block.method_9564().method_26164(class_3481.field_15487) || block.method_9564().method_26164(class_3481.field_16584) || block.method_9564().method_26164(class_3481.field_25147) || blockId.contains("torch") || blockId.contains("lantern") || blockId.contains("chain") || blockId.contains("end_rod") || blockId.contains("lily_pad") || blockId.contains("sugar_cane") || blockId.contains("bamboo") || blockId.contains("fungus") || blockId.contains("sea_pickle") || blockId.contains("vine") || blockId.contains("grass") || blockId.contains("fern") || blockId.contains("bush") || blockId.equals("painting") || blockId.contains("pale_hanging_moss") || blockId.contains("item_frame") || blockId.contains("carpet") || blockId.contains("pane") || blockId.equals("brewing_stand") || blockId.contains("repeater") || blockId.contains("comparator") || blockId.contains("tripwire_hook") || blockId.contains("redstone_wire") || blockId.contains("rail") || blockId.contains("powered_rail") || blockId.contains("detector_rail") || blockId.contains("activator_rail") || blockId.equals("bell") || blockId.contains("dripleaf") || blockId.contains("cake") || blockId.equals("cobweb") || blockId.equals("cocoa") || blockId.equals("conduit") || blockId.equals("dragon_egg") || blockId.contains("dragon_head") || blockId.equals("flower_pot") || blockId.equals("frogspawn") || blockId.equals("iron_bars") || blockId.contains("kelp") || blockId.equals("lightning_rod") || blockId.equals("sculk_vein") || blockId.contains("skull") || blockId.contains("head") || blockId.equals("pointed_dripstone") || blockId.equals("tripwire") || blockId.equals("turtle_egg") || blockId.equals("sculk_catalyst") || blockId.equals("sculk_shrieker") || blockId.equals("sculk_sensor") || blockId.contains("potted_") || blockId.equals("attached_melon_stem") || blockId.equals("attached_pumpkin_stem") || blockId.contains("coral") && !blockId.contains("coral_block") || blockId.equals("nether_wart") || blockId.equals("red_mushroom") || blockId.equals("brown_mushroom")) && !blockId.equals("cherry_leaves") && !blockId.equals("flowering_azalea_leaves") && !blockId.equals("frosted_ice") && !blockId.equals("grass_block") && !blockId.equals("glowstone") && !blockId.equals("sea_lantern") && !blockId.contains("shroomlight") && !blockId.contains("froglight") && !blockId.equals("redstone_lamp") && !blockId.contains("glow_lichen") && !blockId.equals("beacon") && !blockId.equals("lantern") && !blockId.equals("soul_lantern") && !blockId.equals("campfire") && !blockId.equals("soul_campfire") && !blockId.equals("end_rod") && !blockId.equals("torch") && !blockId.equals("soul_torch") && !blockId.equals("redstone_torch") && !blockId.equals("respawn_anchor")) {
                return categories;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to check tags for block: " + blockId + ", skipping: " + e.getMessage());
            return categories;
        }
        try {
            if ((block.method_9564().method_26164(class_3481.field_29822) || block.method_9564().method_26164(class_3481.field_25806) || block.method_9564().method_26164(class_3481.field_15466) || blockId.equals("obsidian") || blockId.equals("bedrock") || blockId.equals("mud") || blockId.equals("muddy_mangrove_roots") || blockId.equals("packed_mud") || blockId.equals("dirt_path") || blockId.equals("farmland") || blockId.equals("gravel") || blockId.equals("calcite") || blockId.equals("clay") || blockId.equals("deepslate") || blockId.equals("stone") || blockId.equals("cobblestone") || blockId.equals("cobbled_deepslate") || blockId.equals("end_stone") || blockId.contains("blackstone") || blockId.equals("crying_obsidian") || blockId.equals("crimson_nylium") || blockId.equals("warped_nylium") || blockId.equals("netherrack") || blockId.equals("soul_sand") || blockId.equals("soul_soil") || blockId.equals("basalt") || blockId.equals("smooth_basalt") || blockId.equals("magma_block") || blockId.equals("infested_stone") || blockId.equals("infested_deepslate") || blockId.equals("infested_cobblestone") || blockId.equals("suspicious_gravel") || blockId.contains("soil") && !blockId.contains("soul")) && !block.method_9564().method_26164(class_3481.field_15504) && !block.method_9564().method_26164(class_3481.field_15459) && !block.method_9564().method_26164(class_3481.field_15469) && !blockId.contains("wall") && !blockId.contains("slab") && !blockId.contains("stairs")) {
                if (blockId.equals("grass_block")) {
                    System.out.println("DEBUG: \u627e\u5230\u8349\u65b9\u5757: " + blockId + ", \u662f\u5426\u5728BlockTags.DIRT\u4e2d: " + block.method_9564().method_26164(class_3481.field_29822));
                    System.out.println("DEBUG: " + blockId + " \u88ab\u5206\u7c7b\u5230\u5730\u5f62\u5206\u7c7b");
                }
                categories.add("pushdozer.category.terrain");
                return categories;
            }
            if (block.method_9564().method_26164(class_3481.field_15467) || block.method_9564().method_26164(class_3481.field_29823) || blockId.equals("snow") || blockId.equals("snow_block") || blockId.equals("powder_snow") || blockId.equals("packed_ice") || blockId.equals("blue_ice") || blockId.equals("frosted_ice")) {
                if (blockId.equals("frosted_ice")) {
                    System.out.println("DEBUG: \u627e\u5230\u971c\u51b0\u65b9\u5757: " + blockId + ", \u662f\u5426\u5728BlockTags.ICE\u4e2d: " + block.method_9564().method_26164(class_3481.field_15467));
                    System.out.println("DEBUG: " + blockId + " \u662f\u5426\u5728BlockTags.REPLACEABLE\u4e2d: " + block.method_9564().method_26164(class_3481.field_44471));
                    System.out.println("DEBUG: " + blockId + " \u88ab\u5206\u7c7b\u5230\u51b0\u4e0e\u96ea\u5206\u7c7b");
                }
                categories.add("pushdozer.category.ice_snow");
                return categories;
            }
            if (blockId.contains("ore") && !blockId.contains("spore") && !blockId.contains("copper") || blockId.equals("ancient_debris") || blockId.endsWith("_block") && (blockId.contains("coal") || blockId.contains("iron") || blockId.contains("gold") || blockId.contains("diamond") || blockId.contains("emerald") || blockId.contains("lapis") || blockId.contains("netherite") || blockId.contains("raw_") && !blockId.contains("copper"))) {
                categories.add("pushdozer.category.ores");
                return categories;
            }
            if (blockId.contains("copper")) {
                categories.add("pushdozer.category.copper");
                return categories;
            }
            if (block.method_9564().method_26164(class_3481.field_15475) || block.method_9564().method_26164(class_3481.field_15471) || blockId.contains("bamboo_block") || blockId.contains("stripped_bamboo") || blockId.contains("hyphae") || blockId.equals("bamboo_mosaic")) {
                categories.add("pushdozer.category.wood");
                return categories;
            }
            if (block.method_9564().method_26164(class_3481.field_15503) || blockId.equals("cherry_leaves") || blockId.equals("flowering_azalea_leaves")) {
                if (blockId.equals("cherry_leaves") || blockId.equals("flowering_azalea_leaves")) {
                    System.out.println("DEBUG: \u627e\u5230\u7279\u6b8a\u6811\u53f6\u65b9\u5757: " + blockId + ", \u662f\u5426\u5728BlockTags.LEAVES\u4e2d: " + block.method_9564().method_26164(class_3481.field_15503));
                    System.out.println("DEBUG: " + blockId + " \u662f\u5426\u5728BlockTags.REPLACEABLE\u4e2d: " + block.method_9564().method_26164(class_3481.field_44471));
                }
                categories.add("pushdozer.category.leaves");
                return categories;
            }
            if (blockId.contains("coral_block") || blockId.contains("dead_coral_block") || blockId.equals("dried_kelp_block") || blockId.equals("sponge") || blockId.equals("wet_sponge") || blockId.equals("melon") || blockId.equals("pumpkin") || blockId.equals("carved_pumpkin") || blockId.equals("jack_o_lantern") || blockId.equals("hay_bale") || blockId.equals("beehive") || blockId.equals("honeycomb_block") || blockId.equals("slime_block") || blockId.equals("honey_block") || blockId.equals("resin_block") || blockId.equals("cactus") || blockId.equals("brown_mushroom_block") || blockId.equals("red_mushroom_block") || blockId.equals("mushroom_stem") || blockId.equals("nether_wart_block") || blockId.equals("warped_wart_block") || blockId.equals("bone_block") || blockId.equals("sniffer_egg") || blockId.equals("moss_block") || blockId.equals("pale_moss_block") || blockId.equals("mangrove_roots") || blockId.equals("tube_coral_block") || blockId.equals("brain_coral_block") || blockId.equals("bubble_coral_block") || blockId.equals("fire_coral_block") || blockId.equals("horn_coral_block") || blockId.equals("dead_tube_coral_block") || blockId.equals("dead_brain_coral_block") || blockId.equals("dead_bubble_coral_block") || blockId.equals("dead_fire_coral_block") || blockId.equals("dead_horn_coral_block")) {
                categories.add("pushdozer.category.biological");
                return categories;
            }
            if (block.method_9564().method_26164(class_3481.field_15459) || block.method_9564().method_26164(class_3481.field_15469)) {
                categories.add("pushdozer.category.stairs_slabs");
                return categories;
            }
            if (blockId.contains("stained_") || blockId.contains("terracotta") || blockId.contains("concrete") || blockId.contains("glass") && !blockId.equals("glass") || blockId.contains("glazed_terracotta")) {
                categories.add("pushdozer.category.dyed");
                return categories;
            }
            if (block.method_9564().method_26164(class_3481.field_15486) || block.method_9564().method_26164(class_3481.field_26985) || block.method_9564().method_26164(class_3481.field_21490) || blockId.contains("chest") || blockId.contains("barrel") || blockId.contains("furnace") || blockId.contains("smoker") || blockId.contains("grindstone") || blockId.contains("loom") || blockId.contains("stonecutter") || blockId.contains("lectern") || blockId.contains("composter") || blockId.contains("enchanting_table") || blockId.contains("ender_chest") || blockId.contains("crafting_table") || blockId.contains("bookshelf") || blockId.equals("bee_nest") || blockId.equals("spawner") || blockId.equals("trial_spawner")) {
                categories.add("pushdozer.category.functional");
                return categories;
            }
            if (blockId.equals("glowstone") || blockId.equals("sea_lantern") || blockId.contains("shroomlight") || blockId.contains("froglight") || blockId.equals("redstone_lamp") || blockId.contains("glow_lichen") || blockId.equals("beacon") || blockId.equals("lantern") || blockId.equals("soul_lantern") || blockId.equals("campfire") || blockId.equals("soul_campfire") || blockId.equals("end_rod") || blockId.equals("torch") || blockId.equals("soul_torch") || blockId.equals("redstone_torch") || blockId.equals("respawn_anchor")) {
                categories.add("pushdozer.category.glowing");
                return categories;
            }
            if (blockId.contains("brick") || blockId.contains("sandstone") || blockId.contains("prismarine") || blockId.contains("quartz") || blockId.equals("smooth_stone") || blockId.contains("glass") || blockId.contains("polished_") || blockId.contains("chiseled_") || blockId.equals("purpur_block") || blockId.equals("purpur_pillar") || block.method_9564().method_26164(class_3481.field_15504)) {
                categories.add("pushdozer.category.decorative");
                return categories;
            }
            if (blockId.contains("piston") || blockId.contains("dispenser") || blockId.contains("observer") || blockId.contains("hopper") || blockId.equals("tnt") || blockId.contains("target") || blockId.contains("button") || blockId.contains("pressure_plate") || blockId.contains("lever") || blockId.contains("redstone") || blockId.equals("dropper")) {
                categories.add("pushdozer.category.redstone");
                return categories;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to check tags for block: " + blockId + ", using miscellaneous: " + e.getMessage());
        }
        categories.add("pushdozer.category.miscellaneous");
        return categories;
    }

    private static class BlockCategory {
        String translationKey;
        List<class_2248> blocks;
        private int priority;
        private Set<String> addedBlockIds;

        BlockCategory(String translationKey, int priority) {
            this.translationKey = translationKey;
            this.priority = priority;
            this.blocks = new ArrayList<class_2248>();
            this.addedBlockIds = new HashSet<String>();
        }

        public class_2561 getTranslatedName() {
            return class_2561.method_43471((String)this.translationKey);
        }

        public void addBlock(class_2248 block) {
            String blockId = class_7923.field_41175.method_10221((Object)block).toString();
            if (!this.addedBlockIds.contains(blockId)) {
                this.blocks.add(block);
                this.addedBlockIds.add(blockId);
                if (!globalSearchStrings.containsKey(block)) {
                    String blockName = class_2561.method_43471((String)block.method_63499()).getString().toLowerCase();
                    String blockIdPath = class_7923.field_41175.method_10221((Object)block).method_12832().toLowerCase();
                    globalSearchStrings.put(block, blockName + "|" + blockIdPath);
                }
            }
        }

        public int getPriority() {
            return this.priority;
        }
    }

    private class ScrollablePanel
    extends class_4185 {
        private final List<class_2248> blocks;
        private int scrollOffset;
        private static final int SCROLL_BAR_WIDTH = 4;
        private static final int BLOCK_SPACING = 4;
        private int hoveredX;
        private int hoveredY;
        private boolean isDraggingScrollBar;
        private int dragStartY;
        private int dragStartScrollOffset;
        private long hoverStartTime;
        private static final long TOOLTIP_DELAY = 500L;
        private class_2248 lastHoveredBlock;

        public ScrollablePanel(int x, int y, int width, int height, List<class_2248> blocks) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), button -> {}, field_40754);
            this.scrollOffset = 0;
            this.isDraggingScrollBar = false;
            this.dragStartY = 0;
            this.dragStartScrollOffset = 0;
            this.hoverStartTime = 0L;
            this.lastHoveredBlock = null;
            this.blocks = blocks;
        }

        private int getVisibleRows() {
            return this.field_22759 / 24;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            int totalRows = (this.blocks.size() + 4 - 1) / 4;
            int visibleRows = this.getVisibleRows();
            class_2248 hoveredBlock = null;
            int backgroundWidth = 92;
            int backgroundHeight = visibleRows * 24 - 4;
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + backgroundWidth, this.method_46427() + backgroundHeight, 0x40000000);
            context.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
            for (int i = 0; i < this.blocks.size(); ++i) {
                int row = i / 4;
                int col = i % 4;
                if (row < this.scrollOffset / 24 || row >= this.scrollOffset / 24 + visibleRows) continue;
                int blockX = this.method_46426() + col * 24;
                int blockY = this.method_46427() + (row - this.scrollOffset / 24) * 24;
                this.renderBlockButton(context, this.blocks.get(i), blockX, blockY, mouseX, mouseY);
                if (mouseX < blockX || mouseX >= blockX + 20 || mouseY < blockY || mouseY >= blockY + 20) continue;
                hoveredBlock = this.blocks.get(i);
                this.hoveredX = mouseX;
                this.hoveredY = mouseY;
            }
            context.method_44380();
            context.method_25294(this.method_46426() + this.field_22758 - 4, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + backgroundHeight, 0x33FFFFFF);
            if (totalRows > visibleRows) {
                int scrollBarHeight = Math.max(20, backgroundHeight * visibleRows / totalRows);
                int scrollBarY = this.method_46427() + (int)((float)(backgroundHeight - scrollBarHeight) * (float)this.scrollOffset / (float)((totalRows - visibleRows) * 24));
                this.drawScrollBar(context, this.method_46426() + this.field_22758 - 4, scrollBarY, scrollBarHeight);
            }
            if (hoveredBlock != null) {
                long currentTime = System.currentTimeMillis();
                if (this.lastHoveredBlock != hoveredBlock) {
                    this.hoverStartTime = currentTime;
                    this.lastHoveredBlock = hoveredBlock;
                }
                if (currentTime - this.hoverStartTime >= 500L) {
                    context.method_51438(NaturalBlockSelectionScreen.this.field_22793, (class_2561)hoveredBlock.method_9518(), this.hoveredX, this.hoveredY);
                }
            } else {
                this.lastHoveredBlock = null;
            }
        }

        private void renderBlockButton(class_332 context, class_2248 block, int x, int y, int mouseX, int mouseY) {
            String blockId;
            class_1799 displayStack;
            int borderColor = block == NaturalBlockSelectionScreen.this.selectedBlock ? -1 : -7631989;
            context.method_25294(x, y, x + 20, y + 20, borderColor);
            context.method_25294(x + 1, y + 1, x + 20 - 1, y + 20 - 1, -13158601);
            if (mouseX >= x && mouseX < x + 20 && mouseY >= y && mouseY < y + 20) {
                context.method_25294(x + 1, y + 1, x + 20 - 1, y + 20 - 1, -11184811);
            }
            if (!(displayStack = this.getDisplayStack(block)).method_7960()) {
                context.method_51427(displayStack, x + 2, y + 2);
            }
            if ((blockId = class_7923.field_41175.method_10221((Object)block).method_12832()).contains("wall_head") || blockId.contains("wall_skull") || blockId.contains("wall_sign")) {
                int underlineY = y + 20 - 3;
                int underlineColor = block == NaturalBlockSelectionScreen.this.selectedBlock ? -1 : -10066330;
                context.method_25294(x + 2, underlineY, x + 20 - 2, underlineY + 1, underlineColor);
            }
            if (block == NaturalBlockSelectionScreen.this.selectedBlock) {
                context.method_25294(x + 1, y + 1, x + 20 - 1, y + 20 - 1, -2130706433);
                context.method_51439(NaturalBlockSelectionScreen.this.field_22793, (class_2561)class_2561.method_43470((String)"\u2611"), x + 20 - 8, y + 20 - 9, -16777216, false);
            }
        }

        private class_1799 getDisplayStack(class_2248 block) {
            if (block == class_2246.field_10382) {
                return class_1802.field_8705.method_7854();
            }
            if (block == class_2246.field_10164) {
                return class_1802.field_8187.method_7854();
            }
            if (block == class_2246.field_10110) {
                return new class_1799((class_1935)class_2246.field_10295);
            }
            if (block == class_2246.field_10238) {
                return class_1802.field_8158.method_7854();
            }
            if (block == class_2246.field_10463) {
                return class_1802.field_17532.method_7854();
            }
            if (block == class_2246.field_22124) {
                return class_1802.field_21992.method_7854();
            }
            if (block == class_2246.field_23079) {
                return class_1802.field_23070.method_7854();
            }
            String translationKey = block.method_63499();
            if (translationKey.contains("wall_sign")) {
                String baseSignKey = translationKey.replace("wall_sign", "sign");
                try {
                    class_2248 baseSign = (class_2248)class_7923.field_41175.method_63535(class_7923.field_41175.method_10221((Object)block).method_45136(baseSignKey));
                    if (baseSign != class_2246.field_10124) {
                        return baseSign.method_8389().method_7854();
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to find base sign for wall sign: " + block.method_63499() + ", using original block");
                }
            }
            if (block == class_2246.field_10293) {
                return class_1802.field_8317.method_7854();
            }
            if (block == class_2246.field_10609) {
                return class_1802.field_8179.method_7854();
            }
            if (block == class_2246.field_10247) {
                return class_1802.field_8567.method_7854();
            }
            if (block == class_2246.field_10341) {
                return class_1802.field_8186.method_7854();
            }
            if (block == class_2246.field_10036) {
                return class_1802.field_8884.method_7854();
            }
            String blockId = class_7923.field_41175.method_10221((Object)block).method_12832();
            if (blockId.contains("wall_head") || blockId.contains("wall_skull")) {
                String baseHeadId = blockId.replace("wall_", "");
                try {
                    class_2248 baseHead = (class_2248)class_7923.field_41175.method_63535(class_7923.field_41175.method_10221((Object)block).method_45136(baseHeadId));
                    if (baseHead != class_2246.field_10124) {
                        return baseHead.method_8389().method_7854();
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to find base head for wall head: " + block.method_63499() + ", using original block");
                }
            }
            if (block == class_2246.field_9987) {
                return class_1802.field_8542.method_7854();
            }
            if (block == class_2246.field_10525) {
                return class_1802.field_8866.method_7854();
            }
            if (block == class_2246.field_10465) {
                return class_1802.field_8238.method_7854();
            }
            if (block == class_2246.field_16540) {
                return class_1802.field_16538.method_7854();
            }
            if (block == class_2246.field_10499) {
                return class_1802.field_8077.method_7854();
            }
            if (block == class_2246.field_31037) {
                return class_1802.field_30904.method_7854();
            }
            if (block == class_2246.field_10260) {
                return class_1802.field_8849.method_7854();
            }
            if (block == class_2246.field_47336) {
                return class_1802.field_47314.method_7854();
            }
            if (block == class_2246.field_10081) {
                return class_1802.field_8840.method_7854();
            }
            if (block == class_2246.field_10027) {
                return class_1802.field_8827.method_7854();
            }
            if (block == class_2246.field_10613) {
                return class_1802.field_8827.method_7854();
            }
            if (block == class_2246.field_10316) {
                return class_1802.field_8281.method_7854();
            }
            if (block == class_2246.field_10398) {
                return class_1802.field_8827.method_7854();
            }
            if (block == class_2246.field_9974) {
                return class_1802.field_8790.method_7854();
            }
            if (block == class_2246.field_22121) {
                return class_1802.field_21987.method_7854();
            }
            if (block == class_2246.field_22114) {
                return class_1802.field_21988.method_7854();
            }
            if (block == class_2246.field_22125) {
                return class_1802.field_21989.method_7854();
            }
            if (block == class_2246.field_22116) {
                return class_1802.field_21990.method_7854();
            }
            if (block == class_2246.field_22117) {
                return class_1802.field_21991.method_7854();
            }
            if (block == class_2246.field_22123) {
                return class_1802.field_21992.method_7854();
            }
            if (block == class_2246.field_23078) {
                return class_1802.field_23070.method_7854();
            }
            if (block == class_2246.field_22122) {
                return class_1802.field_22017.method_7854();
            }
            if (block == class_2246.field_28411) {
                return class_1802.field_28409.method_7854();
            }
            if (block == class_2246.field_37569) {
                return class_1802.field_37524.method_7854();
            }
            if (block == class_2246.field_37570) {
                return class_1802.field_37525.method_7854();
            }
            if (block == class_2246.field_37571) {
                return class_1802.field_37538.method_7854();
            }
            if (block == class_2246.field_28108) {
                return class_1802.field_28101.method_7854();
            }
            if (block == class_2246.field_43231) {
                return class_1802.field_43194.method_7854();
            }
            if (block == class_2246.field_37568) {
                return class_1802.field_37523.method_7854();
            }
            class_1799 itemStack = block.method_8389().method_7854();
            if (itemStack.method_7960()) {
                if (block == class_2246.field_10124) {
                    return class_1799.field_8037;
                }
                if (block == class_2246.field_10543) {
                    return class_1799.field_8037;
                }
                if (block == class_2246.field_10243) {
                    return class_1799.field_8037;
                }
                if (block == class_2246.field_10369) {
                    return class_1799.field_8037;
                }
                String blockIdPath = class_7923.field_41175.method_10221((Object)block).method_12832().toLowerCase();
                if (blockIdPath.contains("portal")) {
                    return class_1802.field_8281.method_7854();
                }
                if (blockIdPath.contains("light")) {
                    return class_1802.field_8801.method_7854();
                }
                if (blockIdPath.contains("air")) {
                    return class_1799.field_8037;
                }
                if (blockIdPath.contains("void")) {
                    return class_1799.field_8037;
                }
                return class_1802.field_20391.method_7854();
            }
            return itemStack;
        }

        public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            if (this.method_25405(mouseX, mouseY)) {
                int totalRows = (this.blocks.size() + 4 - 1) / 4;
                int maxScroll = Math.max(0, (totalRows - this.getVisibleRows()) * 24);
                this.scrollOffset = Math.max(0, Math.min(this.scrollOffset - (int)(verticalAmount * 10.0), maxScroll));
                return true;
            }
            return false;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25405(mouseX, mouseY)) {
                int totalRows = (this.blocks.size() + 4 - 1) / 4;
                int backgroundHeight = this.getVisibleRows() * 24 - 4;
                if (mouseX >= (double)(this.method_46426() + this.field_22758 - 4) && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + backgroundHeight) && totalRows > this.getVisibleRows()) {
                    this.isDraggingScrollBar = true;
                    this.dragStartY = (int)mouseY;
                    this.dragStartScrollOffset = this.scrollOffset;
                    return true;
                }
                int startRow = this.scrollOffset / 24;
                for (int i = startRow * 4; i < Math.min(this.blocks.size(), (startRow + this.getVisibleRows()) * 4); ++i) {
                    int row = i / 4 - startRow;
                    int col = i % 4;
                    int blockX = this.method_46426() + col * 24;
                    int blockY = this.method_46427() + row * 24;
                    if (!(mouseX >= (double)blockX) || !(mouseX < (double)(blockX + 20)) || !(mouseY >= (double)blockY) || !(mouseY < (double)(blockY + 20))) continue;
                    NaturalBlockSelectionScreen.this.toggleBlockSelection(this.blocks.get(i));
                    return true;
                }
            }
            return false;
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.isDraggingScrollBar) {
                int totalRows = (this.blocks.size() + 4 - 1) / 4;
                int backgroundHeight = this.getVisibleRows() * 24 - 4;
                int maxScroll = Math.max(0, (totalRows - this.getVisibleRows()) * 24);
                int dragDistance = (int)mouseY - this.dragStartY;
                int scrollBarHeight = Math.max(20, backgroundHeight * this.getVisibleRows() / totalRows);
                int scrollableHeight = backgroundHeight - scrollBarHeight;
                if (scrollableHeight > 0) {
                    double scrollRatio = (double)dragDistance / (double)scrollableHeight;
                    int newScrollOffset = this.dragStartScrollOffset + (int)(scrollRatio * (double)maxScroll);
                    this.scrollOffset = Math.max(0, Math.min(newScrollOffset, maxScroll));
                }
                return true;
            }
            return false;
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            if (this.isDraggingScrollBar) {
                this.isDraggingScrollBar = false;
                return true;
            }
            return false;
        }

        private void drawScrollBar(class_332 context, int x, int y, int height) {
            context.method_25294(x, y, x + 4, y + height, 0x33FFFFFF);
            context.method_25294(x, y, x + 4, y + height, -5592406);
            context.method_25294(x, y, x + 4 - 1, y + 1, -1);
            context.method_25294(x, y, x + 1, y + height - 1, -1);
            context.method_25294(x + 4 - 1, y, x + 4, y + height, -11184811);
            context.method_25294(x, y + height - 1, x + 4, y + height, -11184811);
        }
    }

    private class PageButtonWidget
    extends class_4185 {
        private final class_2561 tooltipText;

        public PageButtonWidget(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress, class_2561 tooltipText) {
            super(x, y, width, height, message, onPress, field_40754);
            this.tooltipText = tooltipText;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_48579(context, mouseX, mouseY, delta);
            if (this.method_25405(mouseX, mouseY)) {
                context.method_51438(NaturalBlockSelectionScreen.this.field_22793, this.tooltipText, mouseX, mouseY);
            }
        }
    }
}

