/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.network;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.network.PermissionCheckPayload;
import com.pushdozer.network.TerrainOperationPayload;
import com.pushdozer.network.UndoRedoPayload;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2338;
import net.minecraft.class_638;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientNetworkHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"pushdozer");

    public static void registerClientNetworking() {
        PayloadTypeRegistry.playS2C().register(TerrainOperationPayload.ID, TerrainOperationPayload.CODEC);
        ClientNetworkHandler.registerClientHandlers();
        LOGGER.info("Pushdozer\u5ba2\u6237\u7aef\u7f51\u7edc\u5904\u7406\u5668\u6ce8\u518c\u5b8c\u6210");
    }

    private static void registerClientHandlers() {
        ClientPlayNetworking.registerGlobalReceiver(TerrainOperationPayload.ID, (payload, context) -> context.client().execute(() -> {
            try {
                class_638 world = context.client().field_1687;
                if (world != null) {
                    for (int i = 0; i < payload.positions().size() && i < payload.states().size(); ++i) {
                        world.method_8501(payload.positions().get(i), payload.states().get(i));
                    }
                    LOGGER.debug("\u5ba2\u6237\u7aef\u5e94\u7528\u5730\u5f62\u64cd\u4f5c: {} \u4e2a\u65b9\u5757", (Object)payload.positions().size());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5ba2\u6237\u7aef\u5904\u7406\u5730\u5f62\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
            }
        }));
    }

    public static void sendUndoRedoRequest(boolean isUndo) {
        try {
            UndoRedoPayload payload = new UndoRedoPayload(isUndo);
            ClientPlayNetworking.send((class_8710)payload);
            LOGGER.debug("\u53d1\u9001{}\u8bf7\u6c42\u5230\u670d\u52a1\u5668", (Object)(isUndo ? "\u64a4\u9500" : "\u91cd\u505a"));
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001\u64a4\u9500/\u91cd\u505a\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
    }

    public static void sendConfigSync(PushdozerConfig config) {
        LOGGER.debug("\u914d\u7f6e\u540c\u6b65\u5df2\u7981\u7528\uff0c\u6bcf\u4e2a\u73a9\u5bb6\u7684\u914d\u7f6e\u662f\u72ec\u7acb\u7684");
    }

    public static void sendPermissionCheck(String operationType, class_2338 centerPos, int radius) {
        try {
            PermissionCheckPayload payload = new PermissionCheckPayload(operationType, centerPos, radius);
            ClientPlayNetworking.send((class_8710)payload);
            LOGGER.debug("\u53d1\u9001\u6743\u9650\u68c0\u67e5\u8bf7\u6c42: {}", (Object)operationType);
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001\u6743\u9650\u68c0\u67e5\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
    }
}

