/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.render;

import com.pushdozer.shapes.BoxShape;
import com.pushdozer.shapes.ConeShape;
import com.pushdozer.shapes.CylinderShape;
import com.pushdozer.shapes.EllipsoidShape;
import com.pushdozer.shapes.GeometryShape;
import com.pushdozer.shapes.OctahedronShape;
import com.pushdozer.shapes.SphereShape;
import com.pushdozer.shapes.TetrahedronShape;
import com.pushdozer.shapes.TriangularPrismShape;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;

public class PointCloudRenderer {
    private static final int SPHERE_LATS = 32;
    private static final int SPHERE_LONGS = 32;
    private static final int ELLIPSOID_LATS = 24;
    private static final int ELLIPSOID_LONGS = 40;
    private static final int DEFAULT_SEGMENTS = 48;
    private static final int HEIGHT_SEGMENTS = 10;

    public static void render(class_4587 matrices, class_4597 vertexConsumers, GeometryShape shape, class_2338 basePos) {
        class_1921 renderLayer = class_1921.method_23594();
        try {
            class_4588 buffer = vertexConsumers.getBuffer(renderLayer);
            class_243 center = class_243.method_24953((class_2382)basePos);
            if (shape instanceof SphereShape) {
                SphereShape sphere = (SphereShape)shape;
                PointCloudRenderer.renderSpherePoints(buffer, matrices.method_23760().method_23761(), center, (float)sphere.getRadius());
            } else if (shape instanceof ConeShape) {
                ConeShape cone = (ConeShape)shape;
                PointCloudRenderer.renderConePoints(buffer, matrices.method_23760().method_23761(), center, cone.getBaseRadius(), cone.getHeight());
            } else if (shape instanceof CylinderShape) {
                CylinderShape cylinder = (CylinderShape)shape;
                PointCloudRenderer.renderCylinderPoints(buffer, matrices.method_23760().method_23761(), center, cylinder.getRadius(), cylinder.getHeight());
            } else if (shape instanceof EllipsoidShape) {
                EllipsoidShape ellipsoid = (EllipsoidShape)shape;
                PointCloudRenderer.renderEllipsoidPoints(buffer, matrices.method_23760().method_23761(), center, ellipsoid.getRadiusX(), ellipsoid.getRadiusY(), ellipsoid.getRadiusZ());
            } else if (shape instanceof OctahedronShape) {
                OctahedronShape octahedron = (OctahedronShape)shape;
                PointCloudRenderer.renderOctahedronPoints(buffer, matrices.method_23760().method_23761(), center, octahedron.getRadius());
            } else if (shape instanceof TetrahedronShape) {
                TetrahedronShape tetrahedronShape = (TetrahedronShape)shape;
                PointCloudRenderer.renderTetrahedronPoints(buffer, matrices.method_23760().method_23761(), center, (float)tetrahedronShape.getEdgeLength());
            } else if (shape instanceof TriangularPrismShape) {
                TriangularPrismShape triangularPrismShape = (TriangularPrismShape)shape;
                PointCloudRenderer.renderTriangularPrismPoints(buffer, matrices.method_23760().method_23761(), center, (float)triangularPrismShape.getSideLength(), (float)triangularPrismShape.getHeight());
            } else if (shape instanceof BoxShape) {
                BoxShape boxShape = (BoxShape)shape;
                class_238 boundingBox = boxShape.getBoundingBox(new class_2338((int)center.field_1352, (int)center.field_1351, (int)center.field_1350));
                PointCloudRenderer.renderBoxPoints(buffer, matrices.method_23760().method_23761(), boundingBox);
            } else if (shape instanceof class_238) {
                class_238 box = (class_238)shape;
                PointCloudRenderer.renderBoxPoints(buffer, matrices.method_23760().method_23761(), box);
            }
            if (vertexConsumers instanceof class_4597.class_4598) {
                class_4597.class_4598 immediate = (class_4597.class_4598)vertexConsumers;
                immediate.method_22993();
            }
        }
        catch (Exception e) {
            System.err.println("PointCloudRenderer error: " + e.getMessage());
        }
    }

    private static void renderSpherePoints(class_4588 buffer, Matrix4f matrix, class_243 center, float radius) {
        PointCloudRenderer.renderSpheroidPoints(buffer, matrix, center, radius, radius, radius, 32, 32);
    }

    private static void renderEllipsoidPoints(class_4588 buffer, Matrix4f matrix, class_243 center, float radiusX, float radiusY, float radiusZ) {
        PointCloudRenderer.renderSpheroidPoints(buffer, matrix, center, radiusX, radiusY, radiusZ, 24, 40);
    }

    private static void renderSpheroidPoints(class_4588 buffer, Matrix4f matrix, class_243 center, float radiusX, float radiusY, float radiusZ, int lats, int longs) {
        for (int lat = 0; lat <= lats; ++lat) {
            double theta = Math.PI * (-0.5 + (double)lat / (double)lats);
            for (int lon = 0; lon <= longs; ++lon) {
                double phi = (double)(lon * 2) * Math.PI / (double)longs;
                class_243 point = PointCloudRenderer.getSpheroidVertex(center, radiusX, radiusY, radiusZ, theta, phi);
                PointCloudRenderer.addPointAsLine(buffer, matrix, point);
            }
        }
    }

    private static void renderConePoints(class_4588 buffer, Matrix4f matrix, class_243 center, float radius, float height) {
        double bottomY = (double)(-height) / 2.0;
        for (int i = 0; i < 48; ++i) {
            double angle = (double)(i * 2) * Math.PI / 48.0;
            class_243 basePoint = center.method_1031((double)radius * Math.cos(angle), bottomY, (double)radius * Math.sin(angle));
            PointCloudRenderer.addPointAsLine(buffer, matrix, basePoint);
        }
        class_243 apex = center.method_1031(0.0, (double)height / 2.0, 0.0);
        PointCloudRenderer.addPointAsLine(buffer, matrix, apex);
        for (int i = 0; i < 48; ++i) {
            double angle = (double)(i * 2) * Math.PI / 48.0;
            for (int h = 0; h <= 10; ++h) {
                double heightRatio = (double)h / 10.0;
                double currentRadius = (double)radius * (1.0 - heightRatio);
                double y = bottomY + (double)height * heightRatio;
                class_243 sidePoint = center.method_1031(currentRadius * Math.cos(angle), y, currentRadius * Math.sin(angle));
                PointCloudRenderer.addPointAsLine(buffer, matrix, sidePoint);
            }
        }
    }

    private static void renderCylinderPoints(class_4588 buffer, Matrix4f matrix, class_243 center, float radius, float height) {
        double angle;
        int i;
        double bottomY = (double)(-height) / 2.0;
        double topY = (double)height / 2.0;
        for (i = 0; i < 48; ++i) {
            angle = (double)(i * 2) * Math.PI / 48.0;
            class_243 basePoint = center.method_1031((double)radius * Math.cos(angle), bottomY, (double)radius * Math.sin(angle));
            PointCloudRenderer.addPointAsLine(buffer, matrix, basePoint);
        }
        for (i = 0; i < 48; ++i) {
            angle = (double)(i * 2) * Math.PI / 48.0;
            class_243 topPoint = center.method_1031((double)radius * Math.cos(angle), topY, (double)radius * Math.sin(angle));
            PointCloudRenderer.addPointAsLine(buffer, matrix, topPoint);
        }
        for (i = 0; i < 48; ++i) {
            angle = (double)(i * 2) * Math.PI / 48.0;
            for (int h = 0; h <= 10; ++h) {
                double heightRatio = (double)h / 10.0;
                double y = bottomY + (double)height * heightRatio;
                class_243 sidePoint = center.method_1031((double)radius * Math.cos(angle), y, (double)radius * Math.sin(angle));
                PointCloudRenderer.addPointAsLine(buffer, matrix, sidePoint);
            }
        }
    }

    private static void renderOctahedronPoints(class_4588 buffer, Matrix4f matrix, class_243 center, float radius) {
        int[][] faces;
        class_243[] vertices = new class_243[]{center.method_1031(0.0, (double)radius, 0.0), center.method_1031(0.0, (double)(-radius), 0.0), center.method_1031((double)radius, 0.0, 0.0), center.method_1031((double)(-radius), 0.0, 0.0), center.method_1031(0.0, 0.0, (double)radius), center.method_1031(0.0, 0.0, (double)(-radius))};
        for (int[] face : faces = new int[][]{{0, 2, 4}, {0, 4, 3}, {0, 3, 5}, {0, 5, 2}, {1, 4, 2}, {1, 3, 4}, {1, 5, 3}, {1, 2, 5}}) {
            class_243 v1 = vertices[face[0]];
            class_243 v2 = vertices[face[1]];
            class_243 v3 = vertices[face[2]];
            int gridSize = 8;
            for (int i = 0; i <= gridSize; ++i) {
                for (int j = 0; j <= gridSize - i; ++j) {
                    double u = (double)i / (double)gridSize;
                    double v = (double)j / (double)gridSize;
                    double w = 1.0 - u - v;
                    if (!(w >= 0.0)) continue;
                    class_243 point = v1.method_1021(w).method_1019(v2.method_1021(u)).method_1019(v3.method_1021(v));
                    PointCloudRenderer.addPointAsLine(buffer, matrix, point);
                }
            }
        }
    }

    private static void renderBoxPoints(class_4588 buffer, Matrix4f matrix, class_238 box) {
        double minX = box.field_1323;
        double maxX = box.field_1320;
        double minY = box.field_1322;
        double maxY = box.field_1325;
        double minZ = box.field_1321;
        double maxZ = box.field_1324;
        int gridDensity = 12;
        PointCloudRenderer.renderBoxFace(buffer, matrix, minX, maxX, minY, maxY, minZ, minZ, gridDensity, true);
        PointCloudRenderer.renderBoxFace(buffer, matrix, minX, maxX, minY, maxY, maxZ, maxZ, gridDensity, true);
        PointCloudRenderer.renderBoxFace(buffer, matrix, minX, minX, minY, maxY, minZ, maxZ, gridDensity, false);
        PointCloudRenderer.renderBoxFace(buffer, matrix, maxX, maxX, minY, maxY, minZ, maxZ, gridDensity, false);
        PointCloudRenderer.renderBoxFace(buffer, matrix, minX, maxX, minY, minY, minZ, maxZ, gridDensity, false);
        PointCloudRenderer.renderBoxFace(buffer, matrix, minX, maxX, maxY, maxY, minZ, maxZ, gridDensity, false);
    }

    private static void renderBoxFace(class_4588 buffer, Matrix4f matrix, double x1, double x2, double y1, double y2, double z1, double z2, int density, boolean isFrontBack) {
        double stepX = (x2 - x1) / (double)density;
        double stepY = (y2 - y1) / (double)density;
        double stepZ = (z2 - z1) / (double)density;
        for (int i = 0; i <= density; ++i) {
            for (int j = 0; j <= density; ++j) {
                double z;
                double y;
                double x;
                if (isFrontBack) {
                    x = x1 + (double)i * stepX;
                    y = y1 + (double)j * stepY;
                    z = z1;
                } else {
                    y = y1 + (double)i * stepY;
                    z = z1 + (double)j * stepZ;
                    x = x1;
                }
                PointCloudRenderer.addPointAsLine(buffer, matrix, new class_243(x, y, z));
            }
        }
    }

    private static void renderTetrahedronPoints(class_4588 buffer, Matrix4f matrix, class_243 center, float edgeLength) {
        int[][] faces;
        double scale = (double)edgeLength / (2.0 * Math.sqrt(2.0));
        class_243[] vertices = new class_243[]{center.method_1031(scale, scale, scale), center.method_1031(scale, -scale, -scale), center.method_1031(-scale, scale, -scale), center.method_1031(-scale, -scale, scale)};
        for (int[] face : faces = new int[][]{{0, 1, 2}, {0, 2, 3}, {0, 3, 1}, {1, 3, 2}}) {
            class_243 v1 = vertices[face[0]];
            class_243 v2 = vertices[face[1]];
            class_243 v3 = vertices[face[2]];
            int gridSize = 8;
            for (int i = 0; i <= gridSize; ++i) {
                for (int j = 0; j <= gridSize - i; ++j) {
                    double u = (double)i / (double)gridSize;
                    double v = (double)j / (double)gridSize;
                    double w = 1.0 - u - v;
                    if (!(w >= 0.0)) continue;
                    class_243 point = v1.method_1021(w).method_1019(v2.method_1021(u)).method_1019(v3.method_1021(v));
                    PointCloudRenderer.addPointAsLine(buffer, matrix, point);
                }
            }
        }
    }

    private static void renderTriangularPrismPoints(class_4588 buffer, Matrix4f matrix, class_243 center, float sideLength, float height) {
        double triangleHeight = (double)sideLength * Math.sqrt(3.0) / 2.0;
        class_243[] bottomVertices = new class_243[]{center.method_1031(0.0, (double)(-height / 2.0f), triangleHeight / 2.0), center.method_1031((double)(-sideLength / 2.0f), (double)(-height / 2.0f), -triangleHeight / 2.0), center.method_1031((double)(sideLength / 2.0f), (double)(-height / 2.0f), -triangleHeight / 2.0)};
        class_243[] topVertices = new class_243[]{center.method_1031(0.0, (double)(height / 2.0f), triangleHeight / 2.0), center.method_1031((double)(-sideLength / 2.0f), (double)(height / 2.0f), -triangleHeight / 2.0), center.method_1031((double)(sideLength / 2.0f), (double)(height / 2.0f), -triangleHeight / 2.0)};
        PointCloudRenderer.renderRectangleFacePoints(buffer, matrix, bottomVertices[0], bottomVertices[1], topVertices[1], topVertices[0]);
        PointCloudRenderer.renderRectangleFacePoints(buffer, matrix, bottomVertices[1], bottomVertices[2], topVertices[2], topVertices[1]);
        PointCloudRenderer.renderRectangleFacePoints(buffer, matrix, bottomVertices[2], bottomVertices[0], topVertices[0], topVertices[2]);
    }

    private static void renderRectangleFacePoints(class_4588 buffer, Matrix4f matrix, class_243 v1, class_243 v2, class_243 v3, class_243 v4) {
        int gridSize = 8;
        for (int i = 0; i <= gridSize; ++i) {
            for (int j = 0; j <= gridSize; ++j) {
                double u = (double)i / (double)gridSize;
                double v = (double)j / (double)gridSize;
                class_243 point = v1.method_1021((1.0 - u) * (1.0 - v)).method_1019(v2.method_1021(u * (1.0 - v))).method_1019(v3.method_1021(u * v)).method_1019(v4.method_1021((1.0 - u) * v));
                PointCloudRenderer.addPointAsLine(buffer, matrix, point);
            }
        }
    }

    private static void addPointAsLine(class_4588 buffer, Matrix4f matrix, class_243 point) {
        float pointSize = 0.1f;
        class_243 start = point.method_1031((double)(-pointSize), 0.0, 0.0);
        class_243 end = point.method_1031((double)pointSize, 0.0, 0.0);
        buffer.method_22918(matrix, (float)start.field_1352, (float)start.field_1351, (float)start.field_1350).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22914(1.0f, 0.0f, 0.0f);
        buffer.method_22918(matrix, (float)end.field_1352, (float)end.field_1351, (float)end.field_1350).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22914(1.0f, 0.0f, 0.0f);
    }

    private static class_243 getSpheroidVertex(class_243 center, float radiusX, float radiusY, float radiusZ, double lat, double lon) {
        double x = Math.cos(lat) * Math.cos(lon);
        double y = Math.sin(lat);
        double z = Math.cos(lat) * Math.sin(lon);
        return center.method_1031(x * (double)radiusX, y * (double)radiusY, z * (double)radiusZ);
    }
}

