/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.render;

import com.pushdozer.shapes.ConeShape;
import com.pushdozer.shapes.CylinderShape;
import com.pushdozer.shapes.EllipsoidShape;
import com.pushdozer.shapes.GeometryShape;
import com.pushdozer.shapes.OctahedronShape;
import com.pushdozer.shapes.SphereShape;
import com.pushdozer.shapes.TetrahedronShape;
import com.pushdozer.shapes.TriangularPrismShape;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;

public class WireframeRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void render(class_4587 matrices, class_4597 vertexConsumers, GeometryShape shape, class_2338 basePos) {
        class_1921 renderLayer = class_1921.method_23594();
        try {
            class_4588 lines = vertexConsumers.getBuffer(renderLayer);
            matrices.method_22903();
            try {
                class_243 center = class_243.method_24953((class_2382)basePos);
                matrices.method_22904(center.field_1352, center.field_1351, center.field_1350);
                GeometryShape geometryShape = shape;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SphereShape.class, ConeShape.class, CylinderShape.class, EllipsoidShape.class, OctahedronShape.class, TetrahedronShape.class, TriangularPrismShape.class}, (Object)geometryShape, n)) {
                    case 0: {
                        SphereShape sphere = (SphereShape)geometryShape;
                        WireframeRenderer.renderSphereWireframe(lines, matrices.method_23760().method_23761(), (float)sphere.getRadius());
                        return;
                    }
                    case 1: {
                        ConeShape cone = (ConeShape)geometryShape;
                        WireframeRenderer.renderConeWireframe(lines, matrices.method_23760().method_23761(), cone.getBaseRadius(), cone.getHeight());
                        return;
                    }
                    case 2: {
                        CylinderShape cylinder = (CylinderShape)geometryShape;
                        WireframeRenderer.renderCylinderWireframe(lines, matrices.method_23760().method_23761(), cylinder.getRadius(), cylinder.getHeight());
                        return;
                    }
                    case 3: {
                        EllipsoidShape ellipsoid = (EllipsoidShape)geometryShape;
                        WireframeRenderer.renderEllipsoidWireframe(lines, matrices.method_23760().method_23761(), ellipsoid.getRadiusX(), ellipsoid.getRadiusY(), ellipsoid.getRadiusZ());
                        return;
                    }
                    case 4: {
                        OctahedronShape octahedron = (OctahedronShape)geometryShape;
                        WireframeRenderer.renderOctahedronWireframe(lines, matrices.method_23760().method_23761(), octahedron.getRadius());
                        return;
                    }
                    case 5: {
                        TetrahedronShape tetrahedron = (TetrahedronShape)geometryShape;
                        WireframeRenderer.renderTetrahedronWireframe(lines, matrices.method_23760().method_23761(), (int)tetrahedron.getEdgeLength());
                        return;
                    }
                    case 6: {
                        TriangularPrismShape prism = (TriangularPrismShape)geometryShape;
                        WireframeRenderer.renderTriangularPrismWireframe(lines, matrices.method_23760().method_23761(), (int)prism.getSideLength(), (int)prism.getHeight());
                        return;
                    }
                    default: {
                        matrices.method_22904(-center.field_1352, -center.field_1351, -center.field_1350);
                        class_238 box = null;
                        if (shape != null) {
                            box = shape.getBoundingBox(basePos);
                        }
                        if (box == null) return;
                        WireframeRenderer.drawBoxWireframe(lines, matrices.method_23760().method_23761(), box);
                        return;
                    }
                }
            }
            finally {
                matrices.method_22909();
            }
        }
        catch (Exception e) {
            System.err.println("WireframeRenderer error: " + e.getMessage());
        }
    }

    private static void renderSphereWireframe(class_4588 lines, Matrix4f matrix, float radius) {
        int latitudeBands = 14;
        int longitudeBands = 20;
        for (int lat = 0; lat <= latitudeBands; ++lat) {
            double theta = (double)lat * Math.PI / (double)latitudeBands;
            double sinTheta = Math.sin(theta);
            double cosTheta = Math.cos(theta);
            class_243 lastPoint = null;
            for (int lon = 0; lon <= longitudeBands; ++lon) {
                double phi = (double)(lon * 2) * Math.PI / (double)longitudeBands;
                float x = (float)((double)radius * Math.cos(phi) * sinTheta);
                float y = (float)((double)radius * cosTheta);
                float z = (float)((double)radius * Math.sin(phi) * sinTheta);
                if (lastPoint != null) {
                    WireframeRenderer.drawLine(lines, matrix, (float)lastPoint.field_1352, (float)lastPoint.field_1351, (float)lastPoint.field_1350, x, y, z);
                }
                lastPoint = new class_243((double)x, (double)y, (double)z);
            }
        }
        for (int lon = 0; lon < longitudeBands; ++lon) {
            double phi = (double)(lon * 2) * Math.PI / (double)longitudeBands;
            class_243 lastPoint = null;
            for (int lat = 0; lat <= latitudeBands; ++lat) {
                double theta = (double)lat * Math.PI / (double)latitudeBands;
                float x = (float)((double)radius * Math.cos(phi) * Math.sin(theta));
                float y = (float)((double)radius * Math.cos(theta));
                float z = (float)((double)radius * Math.sin(phi) * Math.sin(theta));
                if (lastPoint != null) {
                    WireframeRenderer.drawLine(lines, matrix, (float)lastPoint.field_1352, (float)lastPoint.field_1351, (float)lastPoint.field_1350, x, y, z);
                }
                lastPoint = new class_243((double)x, (double)y, (double)z);
            }
        }
    }

    private static void renderConeWireframe(class_4588 lines, Matrix4f matrix, int baseRadius, int height) {
        int segments = 32;
        class_243 lastPoint = null;
        float bottomY = (float)(-height) / 2.0f;
        float topY = (float)height / 2.0f;
        for (int i = 0; i <= segments; ++i) {
            double angle = (double)(i * 2) * Math.PI / (double)segments;
            float x = (float)((double)baseRadius * Math.cos(angle));
            float z = (float)((double)baseRadius * Math.sin(angle));
            float y = bottomY;
            if (lastPoint != null) {
                WireframeRenderer.drawLine(lines, matrix, (float)lastPoint.field_1352, (float)lastPoint.field_1351, (float)lastPoint.field_1350, x, y, z);
            }
            lastPoint = new class_243((double)x, (double)y, (double)z);
        }
        float topX = 0.0f;
        float topZ = 0.0f;
        for (int i = 0; i < segments; i += 4) {
            double angle = (double)(i * 2) * Math.PI / (double)segments;
            float x = (float)((double)baseRadius * Math.cos(angle));
            float z = (float)((double)baseRadius * Math.sin(angle));
            float y = bottomY;
            WireframeRenderer.drawLine(lines, matrix, x, y, z, topX, topY, topZ);
        }
    }

    private static void renderCylinderWireframe(class_4588 lines, Matrix4f matrix, int radius, int height) {
        float z;
        float x;
        double angle;
        int i;
        int segments = 32;
        class_243 lastPointBottom = null;
        class_243 lastPointTop = null;
        float bottomY = (float)(-height) / 2.0f;
        float topY = (float)height / 2.0f;
        for (i = 0; i <= segments; ++i) {
            angle = (double)(i * 2) * Math.PI / (double)segments;
            x = (float)((double)radius * Math.cos(angle));
            z = (float)((double)radius * Math.sin(angle));
            float yBottom = bottomY;
            if (lastPointBottom != null) {
                WireframeRenderer.drawLine(lines, matrix, (float)lastPointBottom.field_1352, (float)lastPointBottom.field_1351, (float)lastPointBottom.field_1350, x, yBottom, z);
                WireframeRenderer.drawLine(lines, matrix, (float)lastPointTop.field_1352, (float)lastPointTop.field_1351, (float)lastPointTop.field_1350, x, topY, z);
            }
            lastPointBottom = new class_243((double)x, (double)yBottom, (double)z);
            lastPointTop = new class_243((double)x, (double)topY, (double)z);
        }
        for (i = 0; i < segments; i += 8) {
            angle = (double)(i * 2) * Math.PI / (double)segments;
            x = (float)((double)radius * Math.cos(angle));
            z = (float)((double)radius * Math.sin(angle));
            WireframeRenderer.drawLine(lines, matrix, x, bottomY, z, x, topY, z);
        }
    }

    private static void renderEllipsoidWireframe(class_4588 lines, Matrix4f matrix, int radiusX, int radiusY, int radiusZ) {
        int latitudeBands = 12;
        int longitudeBands = 16;
        for (int lat = 0; lat <= latitudeBands; ++lat) {
            double theta = (double)lat * Math.PI / (double)latitudeBands;
            double sinTheta = Math.sin(theta);
            double cosTheta = Math.cos(theta);
            class_243 lastPoint = null;
            for (int lon = 0; lon <= longitudeBands; ++lon) {
                double phi = (double)(lon * 2) * Math.PI / (double)longitudeBands;
                float x = (float)((double)radiusX * Math.cos(phi) * sinTheta);
                float y = (float)((double)radiusY * cosTheta);
                float z = (float)((double)radiusZ * Math.sin(phi) * sinTheta);
                if (lastPoint != null) {
                    WireframeRenderer.drawLine(lines, matrix, (float)lastPoint.field_1352, (float)lastPoint.field_1351, (float)lastPoint.field_1350, x, y, z);
                }
                lastPoint = new class_243((double)x, (double)y, (double)z);
            }
        }
        for (int lon = 0; lon < longitudeBands; ++lon) {
            double phi = (double)(lon * 2) * Math.PI / (double)longitudeBands;
            class_243 lastPoint = null;
            for (int lat = 0; lat <= latitudeBands; ++lat) {
                double theta = (double)lat * Math.PI / (double)latitudeBands;
                float x = (float)((double)radiusX * Math.cos(phi) * Math.sin(theta));
                float y = (float)((double)radiusY * Math.cos(theta));
                float z = (float)((double)radiusZ * Math.sin(phi) * Math.sin(theta));
                if (lastPoint != null) {
                    WireframeRenderer.drawLine(lines, matrix, (float)lastPoint.field_1352, (float)lastPoint.field_1351, (float)lastPoint.field_1350, x, y, z);
                }
                lastPoint = new class_243((double)x, (double)y, (double)z);
            }
        }
    }

    private static void renderOctahedronWireframe(class_4588 lines, Matrix4f matrix, int radius) {
        float[] vertices = new float[]{0.0f, radius, 0.0f, 0.0f, -radius, 0.0f, radius, 0.0f, 0.0f, -radius, 0.0f, 0.0f, 0.0f, 0.0f, radius, 0.0f, 0.0f, -radius};
        int[] edges = new int[]{0, 2, 0, 3, 0, 4, 0, 5, 1, 2, 1, 3, 1, 4, 1, 5, 2, 4, 2, 5, 3, 4, 3, 5};
        for (int i = 0; i < edges.length; i += 2) {
            int v1 = edges[i] * 3;
            int v2 = edges[i + 1] * 3;
            float x1 = vertices[v1];
            float y1 = vertices[v1 + 1];
            float z1 = vertices[v1 + 2];
            float x2 = vertices[v2];
            float y2 = vertices[v2 + 1];
            float z2 = vertices[v2 + 2];
            WireframeRenderer.drawLine(lines, matrix, x1, y1, z1, x2, y2, z2);
        }
    }

    private static void renderTetrahedronWireframe(class_4588 lines, Matrix4f matrix, int radius) {
        double scale = (double)radius / (2.0 * Math.sqrt(2.0));
        float[] vertices = new float[]{(float)scale, (float)scale, (float)scale, (float)scale, (float)(-scale), (float)(-scale), (float)(-scale), (float)scale, (float)(-scale), (float)(-scale), (float)(-scale), (float)scale};
        int[] edges = new int[]{0, 1, 0, 2, 0, 3, 1, 2, 1, 3, 2, 3};
        for (int i = 0; i < edges.length; i += 2) {
            int v1 = edges[i] * 3;
            int v2 = edges[i + 1] * 3;
            float x1 = vertices[v1];
            float y1 = vertices[v1 + 1];
            float z1 = vertices[v1 + 2];
            float x2 = vertices[v2];
            float y2 = vertices[v2 + 1];
            float z2 = vertices[v2 + 2];
            WireframeRenderer.drawLine(lines, matrix, x1, y1, z1, x2, y2, z2);
        }
    }

    private static void renderTriangularPrismWireframe(class_4588 lines, Matrix4f matrix, int sideLength, int height) {
        double triangleHeight = (double)sideLength * Math.sqrt(3.0) / 2.0;
        float bottomY = (float)(-height) / 2.0f;
        float topY = (float)height / 2.0f;
        float[] bottomVertices = new float[]{0.0f, bottomY, (float)(triangleHeight / 2.0), -sideLength / 2, bottomY, (float)(-triangleHeight / 2.0), sideLength / 2, bottomY, (float)(-triangleHeight / 2.0)};
        float[] topVertices = new float[]{0.0f, topY, (float)(triangleHeight / 2.0), -sideLength / 2, topY, (float)(-triangleHeight / 2.0), sideLength / 2, topY, (float)(-triangleHeight / 2.0)};
        WireframeRenderer.drawLine(lines, matrix, bottomVertices[0], bottomVertices[1], bottomVertices[2], bottomVertices[3], bottomVertices[4], bottomVertices[5]);
        WireframeRenderer.drawLine(lines, matrix, bottomVertices[3], bottomVertices[4], bottomVertices[5], bottomVertices[6], bottomVertices[7], bottomVertices[8]);
        WireframeRenderer.drawLine(lines, matrix, bottomVertices[6], bottomVertices[7], bottomVertices[8], bottomVertices[0], bottomVertices[1], bottomVertices[2]);
        WireframeRenderer.drawLine(lines, matrix, topVertices[0], topVertices[1], topVertices[2], topVertices[3], topVertices[4], topVertices[5]);
        WireframeRenderer.drawLine(lines, matrix, topVertices[3], topVertices[4], topVertices[5], topVertices[6], topVertices[7], topVertices[8]);
        WireframeRenderer.drawLine(lines, matrix, topVertices[6], topVertices[7], topVertices[8], topVertices[0], topVertices[1], topVertices[2]);
        WireframeRenderer.drawLine(lines, matrix, bottomVertices[0], bottomVertices[1], bottomVertices[2], topVertices[0], topVertices[1], topVertices[2]);
        WireframeRenderer.drawLine(lines, matrix, bottomVertices[3], bottomVertices[4], bottomVertices[5], topVertices[3], topVertices[4], topVertices[5]);
        WireframeRenderer.drawLine(lines, matrix, bottomVertices[6], bottomVertices[7], bottomVertices[8], topVertices[6], topVertices[7], topVertices[8]);
    }

    private static void drawBoxWireframe(class_4588 lines, Matrix4f matrix, class_238 box) {
        float minX = (float)box.field_1323;
        float minY = (float)box.field_1322;
        float minZ = (float)box.field_1321;
        float maxX = (float)box.field_1320;
        float maxY = (float)box.field_1325;
        float maxZ = (float)box.field_1324;
        WireframeRenderer.drawLine(lines, matrix, minX, minY, minZ, maxX, minY, minZ);
        WireframeRenderer.drawLine(lines, matrix, minX, minY, maxZ, maxX, minY, maxZ);
        WireframeRenderer.drawLine(lines, matrix, minX, maxY, minZ, maxX, maxY, minZ);
        WireframeRenderer.drawLine(lines, matrix, minX, maxY, maxZ, maxX, maxY, maxZ);
        WireframeRenderer.drawLine(lines, matrix, minX, minY, minZ, minX, maxY, minZ);
        WireframeRenderer.drawLine(lines, matrix, maxX, minY, minZ, maxX, maxY, minZ);
        WireframeRenderer.drawLine(lines, matrix, minX, minY, maxZ, minX, maxY, maxZ);
        WireframeRenderer.drawLine(lines, matrix, maxX, minY, maxZ, maxX, maxY, maxZ);
        WireframeRenderer.drawLine(lines, matrix, minX, minY, minZ, minX, minY, maxZ);
        WireframeRenderer.drawLine(lines, matrix, maxX, minY, minZ, maxX, minY, maxZ);
        WireframeRenderer.drawLine(lines, matrix, minX, maxY, minZ, minX, maxY, maxZ);
        WireframeRenderer.drawLine(lines, matrix, maxX, maxY, minZ, maxX, maxY, maxZ);
    }

    private static void drawLine(class_4588 lines, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2) {
        lines.method_22918(matrix, x1, y1, z1).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22914(1.0f, 0.0f, 0.0f);
        lines.method_22918(matrix, x2, y2, z2).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22914(1.0f, 0.0f, 0.0f);
    }
}

