/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.shapes;

import com.pushdozer.shapes.GeometryShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class BoxShape
implements GeometryShape {
    private class_238 box;
    private class_2338 center;

    public BoxShape(int length, int width, int height, class_2338 center) {
        this.center = center;
        this.updateBox(length, width, height);
    }

    private void updateBox(int length, int width, int height) {
        double centerX = (double)this.center.method_10263() + 0.5;
        double centerY = (double)this.center.method_10264() + 0.5;
        double centerZ = (double)this.center.method_10260() + 0.5;
        double halfLength = (double)length / 2.0;
        double halfWidth = (double)width / 2.0;
        double halfHeight = (double)height / 2.0;
        this.box = new class_238(centerX - halfLength, centerY - halfHeight, centerZ - halfWidth, centerX + halfLength, centerY + halfHeight, centerZ + halfWidth);
    }

    @Override
    public class_238 getBoundingBox(class_2338 basePos) {
        return this.box.method_989((double)(basePos.method_10263() - this.center.method_10263()), (double)(basePos.method_10264() - this.center.method_10264()), (double)(basePos.method_10260() - this.center.method_10260()));
    }

    @Override
    public void renderOutline(class_4587 matrices, class_4588 vertexConsumer, class_243 center, float red, float green, float blue, float alpha) {
    }

    @Override
    public void renderSolid(class_4587 matrices, class_4588 vertexConsumer, class_243 center, float red, float green, float blue, float alpha) {
    }

    @Override
    public boolean isInside(class_243 pos) {
        return this.box.method_1006(pos);
    }

    @Override
    public boolean isInside(class_2338 pos) {
        return this.box.method_1006(class_243.method_24953((class_2382)pos));
    }

    @Override
    public int getMinY(class_2338 basePos) {
        return (int)((double)basePos.method_10264() + this.box.field_1322 - (double)this.center.method_10264());
    }

    @Override
    public int getMaxY(class_2338 basePos) {
        return (int)((double)basePos.method_10264() + this.box.field_1325 - (double)this.center.method_10264());
    }

    @Override
    public List<class_2338> getBlocksInLayer(class_2338 basePos, int y) {
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        int minX = (int)Math.round(this.box.field_1323);
        int maxX = (int)Math.round(this.box.field_1320 - 1.0);
        int minZ = (int)Math.round(this.box.field_1321);
        int maxZ = (int)Math.round(this.box.field_1324 - 1.0);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                blocks.add(new class_2338(basePos.method_10263() + x - this.center.method_10263(), y, basePos.method_10260() + z - this.center.method_10260()));
            }
        }
        return blocks;
    }

    @Override
    public List<class_2338> getBlocksInRadius(class_243 center, int maxDistance) {
        return this.getBlocks();
    }

    @Override
    public boolean isWithinBounds(class_2338 pos, class_2338 basePos) {
        class_238 offsetBox = this.box.method_989((double)(basePos.method_10263() - this.center.method_10263()), (double)(basePos.method_10264() - this.center.method_10264()), (double)(basePos.method_10260() - this.center.method_10260()));
        return offsetBox.method_1006(class_243.method_24953((class_2382)pos));
    }

    @Override
    public void setCenter(class_2338 newCenter) {
        class_243 offset = new class_243((double)(newCenter.method_10263() - this.center.method_10263()), (double)(newCenter.method_10264() - this.center.method_10264()), (double)(newCenter.method_10260() - this.center.method_10260()));
        this.box = this.box.method_989(offset.field_1352, offset.field_1351, offset.field_1350);
        this.center = newCenter;
    }

    @Override
    public List<class_2338> getBlocks() {
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        int minX = (int)Math.round(this.box.field_1323);
        int maxX = (int)Math.round(this.box.field_1320 - 1.0);
        int minY = (int)Math.round(this.box.field_1322);
        int maxY = (int)Math.round(this.box.field_1325 - 1.0);
        int minZ = (int)Math.round(this.box.field_1321);
        int maxZ = (int)Math.round(this.box.field_1324 - 1.0);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    blocks.add(new class_2338(x, y, z));
                }
            }
        }
        return blocks;
    }

    @Override
    public Iterator<class_2338> getBlocksIterator() {
        return this.getBlocks().iterator();
    }

    @Override
    public class_2338 getCenter() {
        return this.center;
    }

    @Override
    public List<class_2338> getBlockPositions() {
        return this.getBlocks();
    }
}

