/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.shapes;

import com.pushdozer.shapes.GeometryShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class ConeShape
implements GeometryShape {
    private final int baseRadius;
    private final int height;
    private class_2338 center;

    public ConeShape(int baseRadius, int height, class_2338 center) {
        this.baseRadius = baseRadius;
        this.height = height;
        this.center = center;
    }

    @Override
    public class_238 getBoundingBox(class_2338 basePos) {
        return new class_238((double)(basePos.method_10263() - this.baseRadius), (double)(basePos.method_10264() - this.height / 2), (double)(basePos.method_10260() - this.baseRadius), (double)(basePos.method_10263() + this.baseRadius + 1), (double)(basePos.method_10264() + this.height / 2 + 1), (double)(basePos.method_10260() + this.baseRadius + 1));
    }

    @Override
    public void renderOutline(class_4587 matrices, class_4588 vertexConsumer, class_243 center, float red, float green, float blue, float alpha) {
    }

    @Override
    public void renderSolid(class_4587 matrices, class_4588 vertexConsumer, class_243 center, float red, float green, float blue, float alpha) {
    }

    @Override
    public boolean isInside(class_243 pos) {
        double dx = pos.field_1352 - (double)this.center.method_10263();
        double dz = pos.field_1350 - (double)this.center.method_10260();
        double distanceXZ = Math.sqrt(dx * dx + dz * dz);
        double y = pos.field_1351 - (double)this.center.method_10264();
        if (y < (double)(-this.height / 2) || y > (double)(this.height / 2)) {
            return false;
        }
        double radiusAtHeight = (double)this.baseRadius * (1.0 - (y + (double)(this.height / 2)) / (double)this.height);
        return distanceXZ <= radiusAtHeight;
    }

    @Override
    public boolean isInside(class_2338 pos) {
        double dx = pos.method_10263() - this.center.method_10263();
        double dz = pos.method_10260() - this.center.method_10260();
        double distanceXZ = Math.sqrt(dx * dx + dz * dz);
        int y = pos.method_10264() - this.center.method_10264();
        if (y < -this.height / 2 || y > this.height / 2) {
            return false;
        }
        double radiusAtHeight = (double)this.baseRadius * (1.0 - ((double)y + (double)this.height / 2.0) / (double)this.height);
        return distanceXZ <= radiusAtHeight;
    }

    @Override
    public int getMinY(class_2338 basePos) {
        return basePos.method_10264() - this.height / 2;
    }

    @Override
    public int getMaxY(class_2338 basePos) {
        return basePos.method_10264() + this.height / 2;
    }

    @Override
    public List<class_2338> getBlocksInLayer(class_2338 basePos, int y) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        int relativeY = y - basePos.method_10264();
        if (relativeY >= -this.height / 2 && relativeY <= this.height / 2) {
            double radiusAtHeight = (double)this.baseRadius * (1.0 - ((double)relativeY + (double)this.height / 2.0) / (double)this.height);
            int radius = (int)Math.ceil(radiusAtHeight);
            for (int x = basePos.method_10263() - radius; x <= basePos.method_10263() + radius; ++x) {
                for (int z = basePos.method_10260() - radius; z <= basePos.method_10260() + radius; ++z) {
                    double dz;
                    double dx = x - basePos.method_10263();
                    double distance = Math.sqrt(dx * dx + (dz = (double)(z - basePos.method_10260())) * dz);
                    if (!(distance <= radiusAtHeight)) continue;
                    positions.add(new class_2338(x, y, z));
                }
            }
        }
        return positions;
    }

    @Override
    public List<class_2338> getBlockPositions() {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        int centerX = this.center.method_10263();
        int centerY = this.center.method_10264();
        int centerZ = this.center.method_10260();
        int minY = centerY - this.height / 2;
        int maxY = centerY + this.height / 2;
        for (int y = minY; y <= maxY; ++y) {
            int relativeY = y - centerY;
            double radiusAtHeight = (double)this.baseRadius * (1.0 - ((double)relativeY + (double)this.height / 2.0) / (double)this.height);
            int radius = (int)Math.ceil(radiusAtHeight);
            for (int x = centerX - radius; x <= centerX + radius; ++x) {
                for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                    double dx = x - centerX;
                    double dz = z - centerZ;
                    double distance = Math.sqrt(dx * dx + dz * dz);
                    if (!(distance <= radiusAtHeight)) continue;
                    positions.add(new class_2338(x, y, z));
                }
            }
        }
        return positions;
    }

    @Override
    public List<class_2338> getBlocksInRadius(class_243 center, int maxDistance) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        class_2338 centerPos = class_2338.method_49638((class_2374)center);
        int coneCenterY = this.center.method_10264();
        int minY = coneCenterY - this.height / 2;
        int maxY = coneCenterY + this.height / 2;
        for (int y = Math.max(minY, centerPos.method_10264() - maxDistance); y <= Math.min(maxY, centerPos.method_10264() + maxDistance); ++y) {
            int relativeY = y - coneCenterY;
            double radiusAtHeight = (double)this.baseRadius * (1.0 - ((double)relativeY + (double)this.height / 2.0) / (double)this.height);
            int searchRadius = (int)Math.min(radiusAtHeight, (double)maxDistance);
            for (int x = this.center.method_10263() - searchRadius; x <= this.center.method_10263() + searchRadius; ++x) {
                for (int z = this.center.method_10260() - searchRadius; z <= this.center.method_10260() + searchRadius; ++z) {
                    double dz;
                    double dx = x - this.center.method_10263();
                    double distance = Math.sqrt(dx * dx + (dz = (double)(z - this.center.method_10260())) * dz);
                    if (!(distance <= (double)searchRadius)) continue;
                    positions.add(new class_2338(x, y, z));
                }
            }
        }
        return positions;
    }

    @Override
    public boolean isWithinBounds(class_2338 pos, class_2338 basePos) {
        return this.isInside(pos);
    }

    @Override
    public void setCenter(class_2338 center) {
        this.center = center;
    }

    @Override
    public List<class_2338> getBlocks() {
        return this.getBlockPositions();
    }

    @Override
    public Iterator<class_2338> getBlocksIterator() {
        return this.getBlockPositions().iterator();
    }

    @Override
    public class_2338 getCenter() {
        return this.center;
    }

    public int getBaseRadius() {
        return this.baseRadius;
    }

    public int getHeight() {
        return this.height;
    }
}

