/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.panels.workmode;

import com.pushdozer.PushdozerMod;
import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.ui.panels.workmode.WorkModeConfigPanel;
import com.pushdozer.ui.screens.PushdozerConfigScreen;
import net.minecraft.class_2561;
import net.minecraft.class_357;
import net.minecraft.class_4185;
import net.minecraft.class_7919;

public class SurfaceRoughenConfigPanel
extends WorkModeConfigPanel {
    private class_357 freqSlider;
    private class_357 perSlider;
    private class_357 octSlider;
    private class_4185 autoScaleBtn;

    public SurfaceRoughenConfigPanel(PushdozerConfigScreen parent, PushdozerConfig config) {
        super(parent, config);
    }

    @Override
    protected class_2561 getTitleText() {
        return class_2561.method_43471((String)"pushdozer.mode.surface_roughen");
    }

    @Override
    protected void initializeWidgets() {
        this.widgets.clear();
        int contentLeft = this.panelLeft + 5;
        int contentTop = this.panelTop + 20 + 5;
        int contentWidth = 200;
        class_357 strengthSlider = this.createStrengthSlider(contentLeft, contentTop, contentWidth);
        this.widgets.add(strengthSlider);
        class_357 smoothingSlider = this.createSmoothingSlider(contentLeft, contentTop += 25, contentWidth);
        this.widgets.add(smoothingSlider);
        this.autoScaleBtn = class_4185.method_46430((class_2561)this.getAutoScaleLabel(this.config.isNoiseAutoScale()), b -> {
            this.config.setNoiseAutoScale(!this.config.isNoiseAutoScale());
            this.show();
        }).method_46434(contentLeft, contentTop += 25, contentWidth, 20).method_46431();
        this.autoScaleBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.noise_auto_scale")));
        this.widgets.add(this.autoScaleBtn);
        contentTop += 25;
        if (!this.config.isNoiseAutoScale()) {
            this.freqSlider = this.createFrequencySlider(contentLeft, contentTop, contentWidth);
            this.widgets.add(this.freqSlider);
            this.perSlider = this.createPersistenceSlider(contentLeft, contentTop += 25, contentWidth);
            this.widgets.add(this.perSlider);
            this.octSlider = this.createOctavesSlider(contentLeft, contentTop += 25, contentWidth);
            this.widgets.add(this.octSlider);
            contentTop += 25;
        }
        class_4185 resetBtn = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.button.reset"), b -> {
            this.config.setRoughnessStrength(0.5f);
            this.config.setSmoothingIntensity(0.5f);
            this.config.setNoiseAutoScale(true);
            this.config.setNoiseFrequency(0.02f);
            this.config.setNoisePersistence(0.5f);
            this.config.setNoiseOctaves(4);
            this.show();
        }).method_46434(contentLeft, contentTop, contentWidth, 20).method_46431();
        resetBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.reset")));
        this.widgets.add(resetBtn);
    }

    private class_357 createStrengthSlider(int x, int y, int w) {
        float currentStrength = this.config.getRoughnessStrength();
        final float minStrength = 0.1f;
        final float maxStrength = 2.0f;
        class_357 strengthSlider = new class_357(this, x, y, w, 20, this.getStrengthText(currentStrength), (currentStrength - minStrength) / (maxStrength - minStrength)){
            final /* synthetic */ SurfaceRoughenConfigPanel this$0;
            {
                this.this$0 = this$0;
                super(x, y, width, height, text, value);
            }

            protected void method_25346() {
                float strength = (float)(this.field_22753 * (double)(maxStrength - minStrength) + (double)minStrength);
                this.method_25355(this.this$0.getStrengthText(strength));
            }

            protected void method_25344() {
                float strength = (float)(this.field_22753 * (double)(maxStrength - minStrength) + (double)minStrength);
                this.this$0.config.setRoughnessStrength(strength);
            }
        };
        strengthSlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.roughness_strength")));
        return strengthSlider;
    }

    private class_357 createSmoothingSlider(int x, int y, int w) {
        float currentSmoothing = this.config.getSmoothingIntensity();
        final float minSmoothing = 0.0f;
        final float maxSmoothing = 1.0f;
        class_357 smoothingSlider = new class_357(this, x, y, w, 20, this.getSmoothingText(currentSmoothing), (currentSmoothing - minSmoothing) / (maxSmoothing - minSmoothing)){
            final /* synthetic */ SurfaceRoughenConfigPanel this$0;
            {
                this.this$0 = this$0;
                super(x, y, width, height, text, value);
            }

            protected void method_25346() {
                float smoothing = (float)(this.field_22753 * (double)(maxSmoothing - minSmoothing) + (double)minSmoothing);
                this.method_25355(this.this$0.getSmoothingText(smoothing));
            }

            protected void method_25344() {
                float smoothing = (float)(this.field_22753 * (double)(maxSmoothing - minSmoothing) + (double)minSmoothing);
                this.this$0.config.setSmoothingIntensity(smoothing);
            }
        };
        smoothingSlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.smoothing_intensity")));
        return smoothingSlider;
    }

    private class_357 createFrequencySlider(int x, int y, int w) {
        final float fMin = 0.01f;
        final float fMax = 0.15f;
        float currentFreq = this.clamp(this.config.getNoiseFrequency(), fMin, fMax);
        class_357 slider = new class_357(this, x, y, w, 20, (class_2561)class_2561.method_43469((String)"pushdozer.config.noise_frequency", (Object[])new Object[]{String.format("%.3f", Float.valueOf(currentFreq))}), (currentFreq - fMin) / (fMax - fMin)){
            final /* synthetic */ SurfaceRoughenConfigPanel this$0;
            {
                this.this$0 = this$0;
                super(x, y, width, height, text, value);
            }

            protected void method_25346() {
                float v = (float)(this.field_22753 * (double)(fMax - fMin) + (double)fMin);
                this.method_25355((class_2561)class_2561.method_43469((String)"pushdozer.config.noise_frequency", (Object[])new Object[]{String.format("%.3f", Float.valueOf(v))}));
            }

            protected void method_25344() {
                float v = (float)(this.field_22753 * (double)(fMax - fMin) + (double)fMin);
                this.this$0.config.setNoiseFrequency(v);
            }
        };
        slider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.noise_frequency")));
        return slider;
    }

    private class_357 createPersistenceSlider(int x, int y, int w) {
        final float pMin = 0.1f;
        final float pMax = 0.9f;
        float currentPer = this.clamp(this.config.getNoisePersistence(), pMin, pMax);
        class_357 slider = new class_357(this, x, y, w, 20, (class_2561)class_2561.method_43469((String)"pushdozer.config.noise_persistence", (Object[])new Object[]{String.format("%.2f", Float.valueOf(currentPer))}), (currentPer - pMin) / (pMax - pMin)){
            final /* synthetic */ SurfaceRoughenConfigPanel this$0;
            {
                this.this$0 = this$0;
                super(x, y, width, height, text, value);
            }

            protected void method_25346() {
                float v = (float)(this.field_22753 * (double)(pMax - pMin) + (double)pMin);
                this.method_25355((class_2561)class_2561.method_43469((String)"pushdozer.config.noise_persistence", (Object[])new Object[]{String.format("%.2f", Float.valueOf(v))}));
            }

            protected void method_25344() {
                float v = (float)(this.field_22753 * (double)(pMax - pMin) + (double)pMin);
                this.this$0.config.setNoisePersistence(v);
            }
        };
        slider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.noise_persistence")));
        return slider;
    }

    private class_357 createOctavesSlider(int x, int y, int w) {
        final int oMin = 1;
        final int oMax = 6;
        int currentOct = Math.max(oMin, Math.min(oMax, this.config.getNoiseOctaves()));
        class_357 octSlider = new class_357(this, x, y, w, 20, (class_2561)class_2561.method_43469((String)"pushdozer.config.noise_octaves", (Object[])new Object[]{String.valueOf(currentOct)}), (double)(currentOct - oMin) / (double)(oMax - oMin)){
            final /* synthetic */ SurfaceRoughenConfigPanel this$0;
            {
                this.this$0 = this$0;
                super(x, y, width, height, text, value);
            }

            protected void method_25346() {
                int v = (int)Math.round(this.field_22753 * (double)(oMax - oMin) + (double)oMin);
                this.method_25355((class_2561)class_2561.method_43469((String)"pushdozer.config.noise_octaves", (Object[])new Object[]{String.valueOf(v)}));
            }

            protected void method_25344() {
                int v = (int)Math.round(this.field_22753 * (double)(oMax - oMin) + (double)oMin);
                this.this$0.config.setNoiseOctaves(v);
            }
        };
        octSlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.noise_octaves")));
        return octSlider;
    }

    private class_2561 getStrengthText(float strength) {
        return class_2561.method_43469((String)"pushdozer.config.roughness_strength", (Object[])new Object[]{String.format("%.2f", Float.valueOf(strength))});
    }

    private class_2561 getSmoothingText(float smoothing) {
        return class_2561.method_43469((String)"pushdozer.config.smoothing_intensity", (Object[])new Object[]{String.format("%.2f", Float.valueOf(smoothing))});
    }

    private class_2561 getAutoScaleLabel(boolean enabled) {
        String state = enabled ? class_2561.method_43471((String)"pushdozer.common.on").getString() : class_2561.method_43471((String)"pushdozer.common.off").getString();
        return class_2561.method_43469((String)"pushdozer.config.noise_auto_scale", (Object[])new Object[]{state});
    }

    private float clamp(float v, float min, float max) {
        return Math.max(min, Math.min(max, v));
    }

    @Override
    public void saveConfig() {
        try {
            this.config.save();
            this.parent.showErrorMessage(class_2561.method_43471((String)"pushdozer.config.saved").getString());
        }
        catch (Exception e) {
            PushdozerMod.LOGGER.error("Failed to save surface roughen config", (Throwable)e);
        }
    }
}

